/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Ability;
import pcgen.core.ArmorProf;
import pcgen.core.Campaign;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Language;
import pcgen.core.PCAlignment;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.character.CompanionMod;
import pcgen.core.spell.Spell;
import pcgen.gui.converter.ConversionDecider;
import pcgen.gui.converter.Loader;
import pcgen.gui.converter.loader.BasicLoader;
import pcgen.gui.converter.loader.ClassLoader;
import pcgen.gui.converter.loader.CopyLoader;
import pcgen.gui.converter.loader.EquipmentLoader;
import pcgen.gui.converter.loader.SelfCopyLoader;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.AbilityCategoryLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.StatsAndChecksLoader;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSTConverter
extends Observable {
    private final AbilityCategoryLoader catLoader = new AbilityCategoryLoader();
    private final StatsAndChecksLoader statCheckLoader = new StatsAndChecksLoader();
    private final EditorLoadContext context;
    private List<Loader> loaders;
    private Set<URI> written = new HashSet<URI>();
    private final String outDir;
    private final File rootDir;
    private final DoubleKeyMapToList<Loader, URI, CDOMObject> injected = new DoubleKeyMapToList();
    private final ConversionDecider decider;

    public LSTConverter(EditorLoadContext editorLoadContext, File file, String string, ConversionDecider conversionDecider) {
        this.context = editorLoadContext;
        this.rootDir = file;
        this.outDir = string;
        this.loaders = this.setupLoaders(this.context);
        this.decider = conversionDecider;
    }

    public int getNumFilesInCampaign(Campaign campaign) {
        int n = 0;
        for (Loader loader : this.loaders) {
            List<CampaignSourceEntry> list = loader.getFiles(campaign);
            n += list.size();
        }
        return n;
    }

    public void processCampaign(Campaign campaign) {
        try {
            this.catLoader.loadLstFiles(this.context, campaign.getSafeListFor(ListKey.FILE_ABILITY_CATEGORY));
        }
        catch (PersistenceLayerException persistenceLayerException) {
            persistenceLayerException.printStackTrace();
        }
        this.startItem(campaign);
    }

    private void startItem(Campaign campaign) {
        for (Loader loader : this.loaders) {
            List<CampaignSourceEntry> list = loader.getFiles(campaign);
            for (CampaignSourceEntry campaignSourceEntry : list) {
                URI uRI = campaignSourceEntry.getURI();
                this.setChanged();
                this.notifyObservers(uRI);
                if (this.written.contains(uRI)) continue;
                this.written.add(uRI);
                File file = new File(uRI);
                File file2 = this.findSubRoot(this.rootDir, file);
                if (file2 == null) {
                    Logging.log(Logging.WARNING, "Skipping campaign " + uRI + " as it is not in the selected source directory.");
                    continue;
                }
                String string = file.toString().substring(file2.toString().length() + 1);
                File file3 = new File(this.outDir, File.separator + string);
                if (file3.exists()) {
                    Logging.log(Logging.WARNING, "Won't overwrite: " + file3);
                    continue;
                }
                this.ensureParents(file3.getParentFile());
                try {
                    String string2 = this.load(uRI, loader);
                    if (string2 == null) continue;
                    FileWriter fileWriter = new FileWriter(file3);
                    fileWriter.write(string2);
                    fileWriter.close();
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    persistenceLayerException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private List<Loader> setupLoaders(EditorLoadContext editorLoadContext) {
        ArrayList<Loader> arrayList = new ArrayList<Loader>();
        arrayList.add(new BasicLoader<WeaponProf>(editorLoadContext, WeaponProf.class, ListKey.FILE_WEAPON_PROF));
        arrayList.add(new BasicLoader<ArmorProf>(editorLoadContext, ArmorProf.class, ListKey.FILE_ARMOR_PROF));
        arrayList.add(new BasicLoader<ShieldProf>(editorLoadContext, ShieldProf.class, ListKey.FILE_SHIELD_PROF));
        arrayList.add(new BasicLoader<Skill>(editorLoadContext, Skill.class, ListKey.FILE_SKILL));
        arrayList.add(new BasicLoader<Language>(editorLoadContext, Language.class, ListKey.FILE_LANGUAGE));
        arrayList.add(new BasicLoader<Ability>(editorLoadContext, Ability.class, ListKey.FILE_FEAT));
        arrayList.add(new BasicLoader<Ability>(editorLoadContext, Ability.class, ListKey.FILE_ABILITY));
        arrayList.add(new BasicLoader<Race>(editorLoadContext, Race.class, ListKey.FILE_RACE));
        arrayList.add(new BasicLoader<Domain>(editorLoadContext, Domain.class, ListKey.FILE_DOMAIN));
        arrayList.add(new BasicLoader<Spell>(editorLoadContext, Spell.class, ListKey.FILE_SPELL));
        arrayList.add(new BasicLoader<Deity>(editorLoadContext, Deity.class, ListKey.FILE_DEITY));
        arrayList.add(new BasicLoader<PCTemplate>(editorLoadContext, PCTemplate.class, ListKey.FILE_TEMPLATE));
        arrayList.add(new EquipmentLoader(editorLoadContext, ListKey.FILE_EQUIP));
        arrayList.add(new BasicLoader<EquipmentModifier>(editorLoadContext, EquipmentModifier.class, ListKey.FILE_EQUIP_MOD));
        arrayList.add(new BasicLoader<CompanionMod>(editorLoadContext, CompanionMod.class, ListKey.FILE_COMPANION_MOD));
        arrayList.add(new ClassLoader(editorLoadContext));
        arrayList.add(new CopyLoader(ListKey.FILE_ABILITY_CATEGORY));
        arrayList.add(new CopyLoader(ListKey.LICENSE_FILE));
        arrayList.add(new CopyLoader(ListKey.FILE_KIT));
        arrayList.add(new CopyLoader(ListKey.FILE_BIO_SET));
        arrayList.add(new CopyLoader(ListKey.FILE_PCC));
        arrayList.add(new SelfCopyLoader());
        return arrayList;
    }

    private void ensureParents(File file) {
        if (!file.exists()) {
            this.ensureParents(file.getParentFile());
            file.mkdir();
        }
    }

    private File findSubRoot(File file, File file2) {
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return null;
        }
        if (file3.getAbsolutePath().equals(file.getAbsolutePath())) {
            return file3;
        }
        return this.findSubRoot(file, file3);
    }

    private String load(URI uRI, Loader loader) throws InterruptedException, PersistenceLayerException {
        StringBuilder stringBuilder;
        this.context.setSourceURI(uRI);
        this.context.setExtractURI(uRI);
        try {
            stringBuilder = LstFileLoader.readFromURI(uRI);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            String string = PropertyFactory.getFormattedString("Errors.LstFileLoader.LoadError", uRI, persistenceLayerException.getMessage());
            Logging.errorPrint(string);
            return null;
        }
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length());
        String string = stringBuilder.toString();
        String[] stringArray = string.replaceAll("\r\n", "\r").split("(\r|\n)");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() == 0 || string2.charAt(0) == '#' || string2.startsWith("SOURCE")) {
                stringBuilder2.append(string2);
            } else {
                List<CDOMObject> list = loader.process(stringBuilder2, i, string2, this.decider);
                if (list != null) {
                    for (CDOMObject cDOMObject : list) {
                        this.injected.addToListFor(loader, uRI, cDOMObject);
                    }
                }
            }
            stringBuilder2.append("\n");
        }
        return stringBuilder2.toString();
    }

    public Collection<Loader> getInjectedLoaders() {
        return this.injected.getKeySet();
    }

    public Collection<URI> getInjectedURIs(Loader loader) {
        return this.injected.getSecondaryKeySet(loader);
    }

    public Collection<CDOMObject> getInjectedObjects(Loader loader, URI uRI) {
        return this.injected.getListFor(loader, uRI);
    }

    public void doStartup() throws PersistenceLayerException {
        GameMode gameMode = SettingsHandler.getGame();
        if (gameMode == null) {
            return;
        }
        File file = new File(SettingsHandler.getPcgenSystemDir(), "gameModes");
        File file2 = new File(file, gameMode.getFolderName());
        File file3 = new File(file2, "statsandchecks.lst");
        this.statCheckLoader.loadLstFile(this.context, file3.toURI());
        for (PCAlignment pObject : gameMode.getUnmodifiableAlignmentList()) {
            this.context.ref.registerAbbreviation(pObject, pObject.getKeyName());
        }
        for (PCStat pCStat : gameMode.getUnmodifiableStatList()) {
            this.context.ref.registerAbbreviation(pCStat, pCStat.getAbb());
        }
        for (SizeAdjustment sizeAdjustment : gameMode.getUnmodifiableSizeAdjustmentList()) {
            this.context.ref.registerAbbreviation(sizeAdjustment, sizeAdjustment.getAbbreviation());
        }
    }
}

