/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.inst.ObjectCache;
import pcgen.gui.converter.event.ProgressEvent;
import pcgen.gui.converter.event.ProgressListener;
import pcgen.gui.converter.event.TaskStrategyListener;
import pcgen.gui.converter.event.TaskStrategyMessage;
import pcgen.gui.converter.panel.ConvertSubPanel;
import pcgen.gui.utils.CursorControlUtilities;
import pcgen.gui.utils.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertPanel
extends JPanel {
    private static final long serialVersionUID = 1686411319132380251L;
    private final JPanel basePanel = new JPanel();
    private final JButton finishButton;
    private final JButton prevButton;
    private final JButton nextButton;
    private final JButton cancelButton;
    private final CDOMObject properties;
    private final ProgressListener pl;
    private final List<ConvertSubPanel> queue;
    private int currentPanel = -1;
    private final JLabel statusLabel = new JLabel();

    public ConvertPanel(List<ConvertSubPanel> list) {
        super(new BorderLayout());
        TaskStrategyListener taskStrategyListener = new TaskStrategyListener(){
            private String status;
            private long time;

            public void processMessage(Object object, String string) {
                JOptionPane.showMessageDialog(null, string);
            }

            public void processStatus(Object object, String string) {
                this.status = string;
                ConvertPanel.this.statusLabel.setText(string);
            }

            public void processActiveItem(Object object, String string) {
                long l = System.currentTimeMillis();
                if (l - this.time > 100L) {
                    ConvertPanel.this.statusLabel.setText(this.status + " [" + string + "]");
                    this.time = l;
                }
            }
        };
        TaskStrategyMessage.addTaskStrategyListener(taskStrategyListener);
        this.properties = new ObjectCache();
        Box box = Box.createHorizontalBox();
        this.prevButton = new JButton("< Previous");
        this.prevButton.setMnemonic('P');
        this.prevButton.addActionListener(new PreviousButtonListener());
        this.prevButton.setEnabled(false);
        box.add(this.prevButton);
        this.nextButton = new JButton("Next >");
        this.nextButton.setMnemonic('N');
        this.pl = new ProgressListener(){

            public void progressAllowed(ProgressEvent progressEvent) {
                ConvertPanel.this.nextButton.setEnabled(true);
            }

            public void progressNotAllowed(ProgressEvent progressEvent) {
                ConvertPanel.this.nextButton.setEnabled(false);
            }
        };
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        CursorControlUtilities.startWaitCursor(ConvertPanel.this.basePanel);
                        ConvertPanel.this.runNextPanel();
                        CursorControlUtilities.stopWaitCursor(ConvertPanel.this.basePanel);
                    }
                });
                thread.start();
            }
        });
        box.add(this.nextButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.checkExit();
            }
        });
        box.add(this.cancelButton);
        this.finishButton = new JButton("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.finishButton.setVisible(false);
        box.add(this.finishButton);
        this.basePanel.setPreferredSize(new Dimension(800, 500));
        JScrollPane jScrollPane = new JScrollPane(this.basePanel);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add(jScrollPane);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 1.0, 0.0, 2, 17);
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        jPanel.add((Component)this.statusLabel, gridBagConstraints);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 0, 13);
        jPanel.add((Component)box, gridBagConstraints);
        this.add((Component)jPanel, "South");
        this.queue = list;
        this.runNextPanel();
    }

    public void prepare(ConvertSubPanel convertSubPanel, boolean bl) {
        this.setButtonVisibility(convertSubPanel.isLast(), bl);
        convertSubPanel.addProgressListener(this.pl);
        convertSubPanel.performAnalysis(this.properties);
    }

    private void setButtonVisibility(boolean bl, boolean bl2) {
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(bl2);
        this.finishButton.setVisible(bl);
        this.cancelButton.setVisible(!bl);
    }

    public void checkExit() {
        System.exit(0);
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you wish to cancel and exit?", "Confirm Exit", 2);
        if (n == 0) {
            System.exit(0);
        }
    }

    private void runNextPanel() {
        ConvertSubPanel convertSubPanel = null;
        do {
            boolean bl = false;
            if (this.currentPanel >= 0 && this.currentPanel < this.queue.size()) {
                bl = this.queue.get(this.currentPanel).returnAllowed();
            }
            ++this.currentPanel;
            if (this.currentPanel < this.queue.size()) {
                convertSubPanel = this.queue.get(this.currentPanel);
                this.prepare(convertSubPanel, bl);
                this.basePanel.removeAll();
                convertSubPanel.setupDisplay(this.basePanel, this.properties);
                this.basePanel.repaint();
                continue;
            }
            convertSubPanel = null;
        } while (convertSubPanel != null && convertSubPanel.autoAdvance(this.properties));
    }

    public Component getStatusField() {
        return this.statusLabel;
    }

    public class PreviousButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CursorControlUtilities.startWaitCursor(ConvertPanel.this.basePanel);
            ConvertSubPanel convertSubPanel = null;
            do {
                ConvertPanel.this.currentPanel--;
                if (ConvertPanel.this.currentPanel >= 0 && ConvertPanel.this.currentPanel < ConvertPanel.this.queue.size()) {
                    convertSubPanel = (ConvertSubPanel)ConvertPanel.this.queue.get(ConvertPanel.this.currentPanel);
                    boolean bl = false;
                    if (ConvertPanel.this.currentPanel > 0) {
                        bl = ((ConvertSubPanel)ConvertPanel.this.queue.get(ConvertPanel.this.currentPanel - 1)).returnAllowed();
                    }
                    ConvertPanel.this.prepare(convertSubPanel, bl);
                    ConvertPanel.this.basePanel.removeAll();
                    convertSubPanel.setupDisplay(ConvertPanel.this.basePanel, ConvertPanel.this.properties);
                    ConvertPanel.this.basePanel.repaint();
                    continue;
                }
                convertSubPanel = null;
            } while (convertSubPanel != null && convertSubPanel.autoAdvance(ConvertPanel.this.properties));
            CursorControlUtilities.stopWaitCursor(ConvertPanel.this.basePanel);
        }
    }
}

