/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.npcgen.EquipmentTable;
import pcgen.core.npcgen.TreasureGenerator;
import pcgen.gui.PCGen_Frame1;

public class TreasureGeneratorDlg
extends JDialog {
    private JButton theGenerateButton = new JButton();
    private JComboBox theTableCombo = new JComboBox();
    private JButton theAddButton = new JButton();
    private JList theResultsList = new JList();

    public TreasureGeneratorDlg(Frame frame) {
        super(frame, "Treasure Generator", false);
        this.createControls();
        this.pack();
        this.setLocationRelativeTo(frame);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreasureGeneratorDlg.this.populateControls();
            }
        });
    }

    private void createControls() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.orange);
        jPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Select a table and click generate");
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel("Table:");
        jPanel3.add(jLabel2);
        this.theTableCombo.setPreferredSize(new Dimension(200, 19));
        jPanel3.add(this.theTableCombo);
        this.theGenerateButton.setText("Generate");
        this.theGenerateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreasureGeneratorDlg.this.generateTreasure();
            }
        });
        jPanel3.add(this.theGenerateButton);
        jPanel.add(jPanel3);
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel4 = new JPanel();
        DefaultListModel defaultListModel = new DefaultListModel();
        this.theResultsList.setModel(defaultListModel);
        this.theResultsList.updateUI();
        this.theResultsList.setVisibleRowCount(8);
        JScrollPane jScrollPane = new JScrollPane(this.theResultsList);
        jScrollPane.setPreferredSize(new Dimension(300, 80));
        jScrollPane.setAlignmentX(0.0f);
        jPanel4.add(jScrollPane);
        this.getContentPane().add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel();
        this.theAddButton.setText("Add to PC");
        this.theAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
                PlayerCharacter playerCharacter = null;
                if (pCGen_Frame1 != null) {
                    playerCharacter = pCGen_Frame1.getCurrentPC();
                }
                if (playerCharacter != null) {
                    for (Object object : TreasureGeneratorDlg.this.theResultsList.getSelectedValues()) {
                        Equipment equipment = (Equipment)object;
                        playerCharacter.addEquipment(equipment);
                        Globals.getContext().ref.importObject(equipment);
                    }
                }
            }
        });
        jPanel5.add(this.theAddButton);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreasureGeneratorDlg.this.setVisible(false);
                TreasureGeneratorDlg.this.dispose();
            }
        });
        jPanel5.add(jButton);
        this.getContentPane().add((Component)jPanel5, "South");
    }

    private void populateControls() {
        TreasureGenerator treasureGenerator = TreasureGenerator.getInstance();
        List<EquipmentTable> list = treasureGenerator.getTables(SettingsHandler.getGame());
        for (EquipmentTable equipmentTable : list) {
            this.theTableCombo.addItem(equipmentTable);
        }
        this.setVisible(true);
    }

    private void generateTreasure() {
        EquipmentTable equipmentTable = (EquipmentTable)this.theTableCombo.getSelectedItem();
        List<Equipment> list = equipmentTable.getEquipment();
        DefaultListModel defaultListModel = (DefaultListModel)this.theResultsList.getModel();
        for (Equipment equipment : list) {
            defaultListModel.addElement(equipment);
        }
        this.theResultsList.setSelectionInterval(0, list.size() - 1);
        this.theResultsList.updateUI();
    }
}

