/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import gmgen.GMGenSystem;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.PluginLoader;
import gmgen.pluginmgr.messages.FetchOpenPCGRequestMessage;
import gmgen.pluginmgr.messages.FileTypeMessage;
import gmgen.pluginmgr.messages.InitHolderListSendMessage;
import gmgen.pluginmgr.messages.NewMessage;
import gmgen.pluginmgr.messages.OpenMessage;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import gmgen.pluginmgr.messages.PCClosedMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.PauseRefreshMessage;
import gmgen.pluginmgr.messages.ResumeRefreshMessage;
import gmgen.pluginmgr.messages.SaveMessage;
import gmgen.pluginmgr.messages.SavePCGNotificationMessage;
import gmgen.pluginmgr.messages.SavePCGRequestMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.EventObject;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.TabbedPaneUI;
import pcgen.core.CustomData;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.character.Follower;
import pcgen.core.npcgen.NPCGenerator;
import pcgen.core.party.PCLoader;
import pcgen.core.party.Party;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.ExportPDFPopup;
import pcgen.gui.ExportPopup;
import pcgen.gui.ExportTextPopup;
import pcgen.gui.FrameActionListener;
import pcgen.gui.ImagePreview;
import pcgen.gui.KitSelector;
import pcgen.gui.MainPopupMenu;
import pcgen.gui.NPCGeneratorDlg;
import pcgen.gui.PCGenMenuBar;
import pcgen.gui.PCGenProp;
import pcgen.gui.PCPopupMenu;
import pcgen.gui.PToolBar;
import pcgen.gui.PcgFilter;
import pcgen.gui.PcpFilter;
import pcgen.gui.PreferencesDialog;
import pcgen.gui.StatusBar;
import pcgen.gui.UIFactory;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.Filterable;
import pcgen.gui.pcGenGUI;
import pcgen.gui.sources.InfoPanel;
import pcgen.gui.sources.MainSource;
import pcgen.gui.sources.SourceSelectionDialog;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.LinkableHtmlMessage;
import pcgen.gui.utils.Utility;
import pcgen.io.PCGFile;
import pcgen.io.PCGIOHandler;
import pcgen.util.FOPResourceChecker;
import pcgen.util.JEPResourceChecker;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

public class PCGen_Frame1
extends JFrame
implements GMBComponent,
Observer,
PCLoader {
    static final long serialVersionUID = 1042236188732008819L;
    public static int FIRST_CHAR_TAB = 1;
    private static PCGen_Frame1 inst;
    private static WaitCursorEventQueue waitQueue;
    private static boolean usingWaitCursor;
    private static CharacterInfo characterPane;
    private static StatusBar statusBar;
    static JTabbedPane baseTabbedPane;
    FrameActionListener frameActionListener;
    private final PcgFilter filter = new PcgFilter();
    private final PcpFilter partyFilter = new PcpFilter();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private FlowLayout flowLayout2 = new FlowLayout();
    private JPanel panelMain = new JPanel();
    private JPanel panelSouth = new JPanel();
    private JPanel panelSouthCenter = new JPanel();
    private JPanel panelSouthEast = new JPanel();
    private KitSelector kitSelector = null;
    private MainPopupMenu mainPopupMenu;
    private List<Component> tempTabList = new ArrayList<Component>(12);
    private MainSource mainSource;
    private InfoPanel infoPanel;
    private PCGenMenuBar pcgenMenuBar;
    private PCPopupMenu pcPopupMenu;
    private PToolBar toolBar;
    private PopupListener popupListener;
    private String partyFileName = "";
    private int newPCNameCount = 0;
    private pcGenGUI mainClass;

    public PCGen_Frame1() {
        inst = this;
        this.enableEvents(64L);
        this.setDefaultCloseOperation(0);
        this.frameActionListener = new FrameActionListener(this);
        this.mainPopupMenu = new MainPopupMenu(this.frameActionListener);
        this.pcPopupMenu = new PCPopupMenu(this.frameActionListener);
        this.popupListener = new PopupListener(baseTabbedPane, this.mainPopupMenu, this.pcPopupMenu);
        this.toolBar = PToolBar.createToolBar(this);
        this.pcgenMenuBar = new PCGenMenuBar(this, this.frameActionListener);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logging.errorPrint("jbInit", exception);
        }
        Globals.setRootFrame(this);
        GMBus.addToBus(this);
        GMBus.addToBus(PreferencesDialog.getPreferencesComponent());
        PluginLoader pluginLoader = PluginLoader.inst();
        pluginLoader.startSystemPlugins("PCGen");
    }

    public static JTabbedPane getBaseTabbedPane() {
        return baseTabbedPane;
    }

    public static CharacterInfo getCharacterPane() {
        return characterPane;
    }

    public static CharacterInfo getCurrentCharacterInfo() {
        int n = PCGen_Frame1.getBaseTabbedPane().getSelectedIndex();
        if (n >= FIRST_CHAR_TAB) {
            return characterPane;
        }
        return null;
    }

    public static Filterable getCurrentFilterable() {
        int n = PCGen_Frame1.getBaseTabbedPane().getSelectedIndex();
        if (n == 0) {
            Component component = PCGen_Frame1.getBaseTabbedPane().getComponentAt(n);
            if (component instanceof Filterable) {
                return (Filterable)((Object)component);
            }
        } else if (n >= FIRST_CHAR_TAB) {
            return characterPane.getSelectedFilterable();
        }
        return null;
    }

    public InfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public static PCGen_Frame1 getInst() {
        return inst;
    }

    public void setMainClass(pcGenGUI pcGenGUI2) {
        this.mainClass = pcGenGUI2;
    }

    public MainSource getMainSource() {
        return this.mainSource;
    }

    public static String getMessageAreaText() {
        return statusBar.getMessageAreaText();
    }

    public static void setMessageAreaText(String string) {
        statusBar.setMessageAreaText(string);
    }

    public static void setMessageAreaTextWithoutSaving(String string) {
        statusBar.setMessageAreaTextWithoutSaving(string);
    }

    public static void restoreMessageAreaText() {
        statusBar.restoreMessageAreaText();
    }

    public static void showMemoryArea(boolean bl) {
        statusBar.setShowMemoryArea(bl);
    }

    public void setGameModeTitle() {
        GameMode gameMode = SettingsHandler.getGame();
        String string = gameMode == null ? "???" : gameMode.getDisplayName();
        this.setTitle("PCGen v. " + PCGenProp.getVersionNumber() + " - " + string + " Campaign");
    }

    public static void enableDisableMenuItems() {
        if (!Globals.getUseGUI()) {
            return;
        }
        PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
        pCGen_Frame1.enableNew(true);
        pCGen_Frame1.enableOpen(false);
        pCGen_Frame1.enableClose(false);
        pCGen_Frame1.enableCloseAll(false);
        pCGen_Frame1.enableSave(false);
        pCGen_Frame1.enableSaveAs(false);
        pCGen_Frame1.enableSaveAll(false);
        pCGen_Frame1.enableRevertToSaved(false);
        pCGen_Frame1.enableSave(false);
        pCGen_Frame1.enablePrintPreview(false);
        pCGen_Frame1.enablePrint(false);
        pCGen_Frame1.enablePartySave(false);
        pCGen_Frame1.enablePartySaveAs(false);
        pCGen_Frame1.enableExport(false);
        pCGen_Frame1.enableKit(false);
        pCGen_Frame1.enableLstEditors(false);
        if (!Globals.checkListsHappy()) {
            if (SettingsHandler.isExpertGUI()) {
                pCGen_Frame1.enableNew(false);
            }
            if (SettingsHandler.isLoadCampaignsWithPC()) {
                pCGen_Frame1.enableOpen(true);
            }
            pCGen_Frame1.pcgenMenuBar.treasureItem.setEnabled(false);
            return;
        }
        pCGen_Frame1.enableOpen(true);
        pCGen_Frame1.enableLstEditors(true);
        pCGen_Frame1.pcgenMenuBar.treasureItem.setEnabled(true);
        int n = baseTabbedPane.getSelectedIndex();
        if (n < FIRST_CHAR_TAB && n > 0) {
            pCGen_Frame1.enableSave(true);
            return;
        }
        PlayerCharacter playerCharacter = pCGen_Frame1.getCurrentPC();
        if (playerCharacter == null) {
            return;
        }
        pCGen_Frame1.enableClose(true);
        pCGen_Frame1.enableSaveAs(true);
        pCGen_Frame1.enablePrintPreview(true);
        pCGen_Frame1.enablePrint(true);
        pCGen_Frame1.enablePartySave(true);
        pCGen_Frame1.enablePartySaveAs(true);
        pCGen_Frame1.enableExport(true);
        pCGen_Frame1.enableKit(true);
        List<PlayerCharacter> list = Globals.getPCList();
        int n2 = list.size();
        if (n2 > 1) {
            pCGen_Frame1.enableCloseAll(true);
        }
        for (int i = 0; i < n2; ++i) {
            if (!list.get(i).isDirty()) continue;
            pCGen_Frame1.enableSaveAll(true);
            break;
        }
        if (!playerCharacter.isDirty()) {
            return;
        }
        pCGen_Frame1.enableSave(true);
        if (!playerCharacter.wasEverSaved()) {
            return;
        }
        pCGen_Frame1.enableRevertToSaved(true);
    }

    public void setOpenRecentPCs(String[] stringArray) {
        this.pcgenMenuBar.openRecentPCMenu.setEntriesAsStrings(stringArray);
    }

    public String[] getOpenRecentPCs() {
        return this.pcgenMenuBar.openRecentPCMenu.getEntriesAsStrings();
    }

    public void setOpenRecentParties(String[] stringArray) {
        this.pcgenMenuBar.openRecentPartyMenu.setEntriesAsStrings(stringArray);
    }

    public String[] getOpenRecentParties() {
        return this.pcgenMenuBar.openRecentPartyMenu.getEntriesAsStrings();
    }

    public static PCGen_Frame1 getRealParentFrame(JPanel jPanel) {
        return (PCGen_Frame1)jPanel.getTopLevelAncestor();
    }

    public static void addMonsterHD(int n) {
        if (characterPane != null) {
            characterPane.infoSummary().addMonsterHD(n);
        }
    }

    public void closeAllPCs() {
        int n = baseTabbedPane.getTabCount();
        while (n > FIRST_CHAR_TAB) {
            if (this.closePCTabAt(n - 1, true)) {
                n = baseTabbedPane.getTabCount();
                continue;
            }
            return;
        }
        this.enableClose(false);
        this.enableCloseAll(false);
        this.enableSave(false);
        this.enableSaveAs(false);
        this.enableRevertToSaved(false);
        this.enablePartySave(false);
        this.enablePartySaveAs(false);
        this.enablePartyClose(false);
        this.enablePrintPreview(false);
        this.enablePrint(false);
        this.enableExport(false);
        this.enableKit(false);
        this.newPCNameCount = 0;
    }

    public void enableLstEditors(boolean bl) {
        this.pcgenMenuBar.listEditor.setEnabled(bl);
    }

    public void enableNew(boolean bl) {
        this.pcgenMenuBar.newItem.setEnabled(bl);
        this.toolBar.newItem.setEnabled(bl);
        this.mainPopupMenu.newItem.setEnabled(bl);
        this.pcPopupMenu.getNewItem().setEnabled(bl);
        this.pcgenMenuBar.newNPCItem.setEnabled(bl);
        this.toolBar.newNPCItem.setEnabled(bl);
        this.mainPopupMenu.newNPCItem.setEnabled(bl);
        this.pcPopupMenu.getNewNPCItem().setEnabled(bl);
    }

    public void enableOpen(boolean bl) {
        this.pcgenMenuBar.openItem.setEnabled(bl);
        this.toolBar.openItem.setEnabled(bl);
    }

    public void eqList_Changed(Equipment equipment, boolean bl) {
        if (characterPane != null) {
            characterPane.infoInventory().getInfoGear().refreshAvailableList(equipment, bl, true);
        }
    }

    public void exportToPDFItem_actionPerformed() {
        if (!this.pcgenMenuBar.enablePDF) {
            this.warnAboutMissingResource();
            return;
        }
        if (this.pcgenMenuBar.exportPDFPopup == null) {
            this.pcgenMenuBar.exportPDFPopup = new ExportPDFPopup(baseTabbedPane);
        }
        this.pcgenMenuBar.exportPDFPopup.setCurrentPCSelectionByTab();
    }

    public void exportToStandardItem_actionPerformed() {
        if (this.pcgenMenuBar.exportPopup == null) {
            this.pcgenMenuBar.exportPopup = new ExportPopup(baseTabbedPane);
        }
        this.pcgenMenuBar.exportPopup.setCurrentPCSelectionByTab();
    }

    public void exportToTextItem_actionPerformed() {
        if (this.pcgenMenuBar.exportTextPopup == null) {
            this.pcgenMenuBar.exportTextPopup = new ExportTextPopup(baseTabbedPane);
        }
        this.pcgenMenuBar.exportTextPopup.setCurrentPCSelectionByTab();
    }

    public PlayerCharacter loadPCFromFile(File file) {
        return this.loadPCFromFile(file, false, false);
    }

    public void setPC(PlayerCharacter playerCharacter) {
        if (this.mainClass == null || playerCharacter == null) {
            return;
        }
        this.addPCTab(playerCharacter);
        if (playerCharacter.getLoadCompanion() && !playerCharacter.getFollowerList().isEmpty()) {
            for (Follower follower : playerCharacter.getFollowerList()) {
                boolean bl = false;
                for (PlayerCharacter playerCharacter2 : Globals.getPCList()) {
                    if (!follower.getFileName().equals(playerCharacter2.getFileName())) continue;
                    bl = true;
                }
                if (bl) continue;
                File file = new File(follower.getFileName());
                Party party = Party.makeSingleCharacterParty(file);
                PlayerCharacter playerCharacter3 = party.load(null);
                if (this.mainClass != null && playerCharacter3 != null) {
                    this.addPCTab(playerCharacter3);
                    continue;
                }
                ShowMessageDelegate.showMessageDialog("Unrecoverable problems occurred while loading a companion or follower.", "Error", MessageType.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerCharacter loadPCFromFile(File file, boolean bl, boolean bl2) {
        PlayerCharacter playerCharacter;
        if (!bl2) {
            for (PlayerCharacter playerCharacter2 : Globals.getPCList()) {
                if (!file.getAbsolutePath().equals(playerCharacter2.getFileName())) continue;
                ShowMessageDelegate.showMessageDialog("This character has already been loaded from: " + file.getAbsolutePath(), "Error", MessageType.ERROR);
                Logging.errorPrint("The character was already loaded");
                return null;
            }
        }
        Party party = Party.makeSingleCharacterParty(file);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File does not exist", "Error", 0);
            return null;
        }
        try {
            GMBus.send(new PauseRefreshMessage(this));
            playerCharacter = party.load(null);
            if (this.mainClass == null || playerCharacter == null) {
                PlayerCharacter playerCharacter2;
                ShowMessageDelegate.showMessageDialog("Unrecoverable problems occurred while loading the character.", "Error", MessageType.ERROR);
                Logging.errorPrint("Error in loadPCFromFile");
                playerCharacter2 = null;
                return playerCharacter2;
            }
            this.pcgenMenuBar.openRecentPCMenu.add(playerCharacter.getDisplayName(), file);
            this.setPC(playerCharacter);
            if (!bl) {
                GMBus.send(new PCLoadedMessage(this, playerCharacter));
            }
        }
        finally {
            GMBus.send(new ResumeRefreshMessage(this));
        }
        return playerCharacter;
    }

    public static void restoreFilterSettings(String string) {
        if (characterPane != null) {
            characterPane.restoreFilterSettings(string);
        } else {
            FilterFactory.clearFilterCache();
        }
    }

    public void featList_Changed() {
        if (characterPane != null) {
            characterPane.setPaneForUpdate(characterPane.infoAbilities());
            characterPane.refresh();
        }
    }

    public static void forceUpdate_PlayerTabs() {
        boolean bl = SettingsHandler.isToolTipTextShown();
        int n = baseTabbedPane.getTabCount();
        for (int i = FIRST_CHAR_TAB; i < n; ++i) {
            PlayerCharacter playerCharacter = PCGen_Frame1.getPCForTabAt(i);
            PCGen_Frame1.setTabName(i, playerCharacter.getDisplayName());
            baseTabbedPane.setToolTipTextAt(i, bl ? playerCharacter.getFullDisplayName() : null);
        }
    }

    public void hpTotal_Changed() {
        if (characterPane != null) {
            characterPane.setPaneForUpdate(characterPane.infoClasses());
            characterPane.setPaneForUpdate(characterPane.infoSummary());
            characterPane.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertToSavedItem_actionPerformed(ActionEvent actionEvent) {
        PlayerCharacter playerCharacter = this.getCurrentPC();
        if (playerCharacter == null) {
            return;
        }
        if (!playerCharacter.isDirty()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, playerCharacter.getDisplayName() + " changed.\t Discard changes?", "Revert " + playerCharacter.getDisplayName() + "?", 0);
        if (n != 0) {
            return;
        }
        PCGen_Frame1.setMessageAreaText("Reverting character to saved...");
        try {
            this.pcgenMenuBar.revertToSavedItem.requestFocus();
            String string = playerCharacter.getFileName();
            if (string.equals("")) {
                return;
            }
            this.closeItem_actionPerformed(actionEvent);
            File file = new File(string);
            if (file.exists()) {
                this.loadPCFromFile(file);
            }
        }
        finally {
            PCGen_Frame1.restoreMessageAreaText();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean savePC(PlayerCharacter playerCharacter, boolean bl) {
        File file;
        File file2;
        boolean bl2 = false;
        String string = playerCharacter.getFileName();
        GMBus.send(new SavePCGNotificationMessage(this, playerCharacter));
        if (string.equals("")) {
            file2 = new File(SettingsHandler.getPcgPath(), playerCharacter.getDisplayName() + ".pcg");
            string = file2.getAbsolutePath();
            bl2 = true;
        } else {
            file2 = new File(string);
        }
        if (bl || bl2) {
            int n;
            JFileChooser jFileChooser = SettingsHandler.isShowImagePreview() ? ImagePreview.decorateWithImagePreview(new JFileChooser()) : new JFileChooser();
            jFileChooser.setFileFilter(this.filter);
            jFileChooser.setSelectedFile(file2);
            FilenameChangeListener filenameChangeListener = new FilenameChangeListener(string, jFileChooser);
            jFileChooser.addPropertyChangeListener(filenameChangeListener);
            int n2 = jFileChooser.showSaveDialog(this);
            jFileChooser.removePropertyChangeListener(filenameChangeListener);
            if (n2 != 0) return false;
            file = jFileChooser.getSelectedFile();
            if (!PCGFile.isPCGenCharacterFile(file)) {
                file = new File(file.getParent(), file.getName() + ".pcg");
            }
            if (file.isDirectory()) {
                ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a character.", "PCGen", MessageType.ERROR);
                return false;
            }
            if (file.exists() && (bl2 || !file.getName().equals(file2.getName())) && (n = JOptionPane.showConfirmDialog(this, "The file " + file.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + file.getName(), 0)) != 0) {
                return false;
            }
            playerCharacter.setFileName(file.getAbsolutePath());
        } else {
            file = file2;
        }
        try {
            new PCGIOHandler().write(playerCharacter, file.getAbsolutePath());
            SettingsHandler.setLastUsedPcgPath(file.getParentFile());
        }
        catch (Exception exception) {
            Logging.errorPrint("Could not save " + playerCharacter.getDisplayName(), exception);
            ShowMessageDelegate.showMessageDialog("Could not save " + playerCharacter.getDisplayName(), "PCGen", MessageType.ERROR);
            return false;
        }
        this.pcgenMenuBar.openRecentPCMenu.add(playerCharacter.getDisplayName(), file);
        return true;
    }

    public static void useWaitCursor(boolean bl) {
        if (bl) {
            if (!usingWaitCursor) {
                usingWaitCursor = true;
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(waitQueue);
            }
        } else if (usingWaitCursor) {
            try {
                waitQueue.doPop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            usingWaitCursor = false;
        }
    }

    public void setPcgenMenuBar(PCGenMenuBar pCGenMenuBar) {
        this.pcgenMenuBar = pCGenMenuBar;
    }

    public PCGenMenuBar getPcgenMenuBar() {
        return this.pcgenMenuBar;
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof OpenPCGRequestMessage) {
            this.handleOpenPCGRequestMessage((OpenPCGRequestMessage)gMBMessage);
        } else if (gMBMessage instanceof OpenMessage) {
            this.handleOpenMessage((OpenMessage)gMBMessage);
        } else if (gMBMessage instanceof SaveMessage) {
            this.handleSaveMessage((SaveMessage)gMBMessage);
        } else if (gMBMessage instanceof NewMessage) {
            this.handleNewMessage();
        } else if (gMBMessage instanceof FetchOpenPCGRequestMessage) {
            this.handleFetchOpenPCGRequestMessage();
        } else if (gMBMessage instanceof SavePCGRequestMessage) {
            SavePCGRequestMessage savePCGRequestMessage = (SavePCGRequestMessage)gMBMessage;
            this.savePC(savePCGRequestMessage.getPC(), false);
        } else if (gMBMessage instanceof InitHolderListSendMessage) {
            this.handleInitHolderListSendMessage((InitHolderListSendMessage)gMBMessage);
        } else if (gMBMessage instanceof StateChangedMessage) {
            this.handleStateChangedMessage();
        } else if (gMBMessage instanceof TabAddMessage) {
            this.handleTabAddMessage((TabAddMessage)gMBMessage);
        } else if (gMBMessage instanceof PauseRefreshMessage) {
            this.handlePauseRefreshMessage();
        } else if (gMBMessage instanceof ResumeRefreshMessage) {
            this.handleResumeRefreshMessage();
        }
    }

    private void handleOpenMessage(OpenMessage openMessage) {
        File[] fileArray = openMessage.getFile();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!this.filter.accept(fileArray[i])) continue;
            SettingsHandler.setLastUsedPcgPath(fileArray[i].getParentFile());
            this.loadPCFromFile(fileArray[i]);
        }
        openMessage.veto();
    }

    private void handleSaveMessage(SaveMessage saveMessage) {
        int n = baseTabbedPane.getSelectedIndex();
        if (this.isFocused() && n >= FIRST_CHAR_TAB) {
            this.pcgenMenuBar.saveItem.requestFocus();
            PlayerCharacter playerCharacter = this.getCurrentPC();
            if (playerCharacter == null) {
                return;
            }
            this.savePC(playerCharacter, false);
            saveMessage.veto();
        }
    }

    private void handleNewMessage() {
        int n = baseTabbedPane.getSelectedIndex();
        if (n < 0 || n >= FIRST_CHAR_TAB || baseTabbedPane.getSelectedComponent() == this.mainSource || baseTabbedPane.getSelectedComponent() instanceof InfoPanel) {
            this.toolBar.newItem.requestFocus();
            this.pcgenMenuBar.newItem.requestFocus();
            this.doNewItem();
        }
    }

    public void stateUpdate(EventObject eventObject) {
        GMBus.send(new StateChangedMessage(this, null));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.handleQuit();
        }
    }

    public void addKit_actionPerformed() {
        this.toolBar.addKit.requestFocus();
        this.pcgenMenuBar.addKit.requestFocus();
        PlayerCharacter playerCharacter = this.getCurrentPC();
        if (playerCharacter == null) {
            return;
        }
        int n = baseTabbedPane.getSelectedIndex();
        if (n >= FIRST_CHAR_TAB) {
            if (this.kitSelector == null) {
                this.kitSelector = new KitSelector(playerCharacter);
            }
            this.kitSelector.setVisible(true);
            this.kitSelector = null;
        }
    }

    void closeAllItem_actionPerformed() {
        this.pcgenMenuBar.closeAllItem.requestFocus();
        this.closeAllPCs();
    }

    void closeItem_actionPerformed(ActionEvent actionEvent) {
        this.pcgenMenuBar.closeItem.requestFocus();
        int n = baseTabbedPane.getSelectedIndex();
        if (n >= FIRST_CHAR_TAB) {
            String string = actionEvent.getActionCommand();
            if (!this.closePCTabAt(n, string.equals("file.close"))) {
                return;
            }
            if (baseTabbedPane.getTabCount() <= FIRST_CHAR_TAB) {
                this.newPCNameCount = 0;
            }
        }
    }

    void closePopupItem_actionPerformed() {
        int n = this.popupListener.getTabIndex();
        this.closePCTabAt(n, true);
        baseTabbedPane.setSelectedIndex(n < baseTabbedPane.getTabCount() ? n : n - 1);
    }

    boolean loadPartyFromFile(File file) {
        Party party = Party.makePartyFromFile(file);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File does not exist", "Error", 0);
            return false;
        }
        PlayerCharacter playerCharacter = party.load(this);
        if (this.mainClass == null || playerCharacter == null) {
            ShowMessageDelegate.showMessageDialog("Problems occurred while loading the party.", "Error", MessageType.ERROR);
            Logging.errorPrint("PCGen_Frame1: Error in loadPartyFromFile");
            return false;
        }
        this.partyFileName = file.getAbsolutePath();
        String string = party.getDisplayName();
        this.pcgenMenuBar.openRecentPartyMenu.add(string, file);
        this.enablePartyClose(true);
        return true;
    }

    void newItem_actionPerformed() {
        GMBus.send(new NewMessage(this));
    }

    void doNewNPC() {
        if (!Globals.displayListsHappy()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_newCharNoSources"), "PCGen", MessageType.ERROR);
            return;
        }
        PlayerCharacter playerCharacter = new PlayerCharacter();
        NPCGeneratorDlg nPCGeneratorDlg = new NPCGeneratorDlg();
        nPCGeneratorDlg.pack();
        nPCGeneratorDlg.setVisible(true);
        if (nPCGeneratorDlg.getValue() == 1) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            NPCGenerator nPCGenerator = NPCGenerator.getInst();
            nPCGenerator.generate(playerCharacter, nPCGeneratorDlg.getAlignment(), nPCGeneratorDlg.getRace(), nPCGeneratorDlg.getGender(), nPCGeneratorDlg.getClassList(), nPCGeneratorDlg.getLevels(), nPCGeneratorDlg.getRollMethod(), nPCGeneratorDlg.getNameChoice());
            Globals.getPCList().add(playerCharacter);
            Globals.setCurrentPC(playerCharacter);
            playerCharacter.setDirty(true);
            this.setPC(playerCharacter);
            this.setCursor(cursor);
        }
    }

    void newNPCItem_actionPerformed() {
        this.doNewNPC();
    }

    void newPopupItem_actionPerformed() {
        this.doNewItem();
    }

    void newNPCPopupItem_actionPerformed() {
        this.doNewNPC();
    }

    void openGMGen_actionPerformed() {
        if (GMGenSystem.inst == null) {
            new GMGenSystem();
        } else {
            GMGenSystem.inst.setVisible(true);
        }
    }

    void openItem_actionPerformed() {
        int n;
        this.toolBar.openItem.requestFocus();
        this.pcgenMenuBar.openItem.requestFocus();
        PCGen_Frame1.setMessageAreaText("Opening file.  Please wait...");
        this.pcgenMenuBar.openItem.requestFocus();
        JFileChooser jFileChooser = SettingsHandler.isShowImagePreview() ? ImagePreview.decorateWithImagePreview(new JFileChooser()) : new JFileChooser();
        jFileChooser.setCurrentDirectory(SettingsHandler.getLastUsedPcgPath());
        FileTypeMessage fileTypeMessage = new FileTypeMessage(this);
        GMBus.send(fileTypeMessage);
        FileFilter[] fileFilterArray = fileTypeMessage.getFileypes();
        for (n = 0; n < fileFilterArray.length; ++n) {
            jFileChooser.addChoosableFileFilter(fileFilterArray[n]);
        }
        jFileChooser.setFileFilter(this.filter);
        jFileChooser.setMultiSelectionEnabled(true);
        n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            GMBus.send(new OpenMessage(this, jFileChooser.getSelectedFiles()));
        }
        PCGen_Frame1.restoreMessageAreaText();
    }

    void partyCloseItem_actionPerformed() {
        PCGen_Frame1.setMessageAreaText("Closing party...");
        this.closeAllPCs();
        int n = baseTabbedPane.getTabCount();
        if (n == FIRST_CHAR_TAB) {
            this.pcgenMenuBar.partyCloseItem.requestFocus();
            this.enablePartyClose(false);
        }
        PCGen_Frame1.restoreMessageAreaText();
    }

    void partyOpenItem_actionPerformed() {
        PCGen_Frame1.setMessageAreaText("Opening party...");
        this.pcgenMenuBar.partyOpenItem.requestFocus();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(SettingsHandler.getPcgPath());
        jFileChooser.setFileFilter(this.partyFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            SettingsHandler.setLastUsedPcgPath(file.getParentFile());
            this.loadPartyFromFile(file);
        }
        PCGen_Frame1.restoreMessageAreaText();
    }

    void partySaveAsItem_actionPerformed() {
        this.pcgenMenuBar.partySaveAsItem.requestFocus();
        this.saveAllPCs();
        this.partySaveItem(true);
    }

    void partySaveItem_actionPerformed() {
        this.pcgenMenuBar.partySaveItem.requestFocus();
        this.saveAllPCs();
        this.partySaveItem(false);
    }

    public void preferencesItem_actionPerformed() {
        PCGen_Frame1.setMessageAreaText("Preferences...");
        statusBar.revalidate();
        PreferencesDialog.show(this);
        PCGen_Frame1.restoreMessageAreaText();
    }

    void printItem_actionPerformed() {
        if (!this.pcgenMenuBar.enablePDF) {
            this.warnAboutMissingResource();
            return;
        }
        this.pcgenMenuBar.checkPrintFrame();
        this.pcgenMenuBar.printFrame.setCurrentPCSelectionByTab();
        this.pcgenMenuBar.printFrame.pack();
        this.pcgenMenuBar.printFrame.setVisible(true);
    }

    void printPreviewItem_actionPerformed() {
        Utility.previewInBrowser(this.getCurrentPC());
    }

    void saveAllItem_actionPerformed() {
        this.pcgenMenuBar.saveAllItem.requestFocus();
        this.saveAllPCs();
    }

    void saveAsItem_actionPerformed() {
        this.pcgenMenuBar.saveAsItem.requestFocus();
        PlayerCharacter playerCharacter = this.getCurrentPC();
        if (playerCharacter == null) {
            return;
        }
        this.savePC(playerCharacter, true);
    }

    void saveAsPopupItem_actionPerformed() {
        this.savePC(PCGen_Frame1.getPCForTabAt(this.popupListener.getTabIndex()), true);
    }

    void saveItem_actionPerformed() {
        GMBus.send(new SaveMessage(this));
    }

    void savePopupItem_actionPerformed() {
        this.savePC(PCGen_Frame1.getPCForTabAt(this.popupListener.getTabIndex()), false);
    }

    void shiftLeftPopupItem_actionPerformed() {
        int n;
        this.moveTab(n, (n = this.popupListener.getTabIndex()) == FIRST_CHAR_TAB ? baseTabbedPane.getTabCount() - 1 : n - 1);
    }

    void shiftRightPopupItem_actionPerformed() {
        int n;
        this.moveTab(n, (n = this.popupListener.getTabIndex()) == baseTabbedPane.getTabCount() - 1 ? FIRST_CHAR_TAB : n + 1);
    }

    void updateByKludge() {
        KitSelector kitSelector = this.kitSelector;
        this.kitSelector = null;
        int n = baseTabbedPane.getSelectedIndex();
        baseTabbedPane.setSelectedIndex(0);
        baseTabbedPane.setSelectedIndex(n);
        this.kitSelector = kitSelector;
    }

    private static PlayerCharacter getPCForTabAt(int n) {
        int n2 = n - FIRST_CHAR_TAB;
        if (n2 >= 0 && n2 < Globals.getPCList().size()) {
            return Globals.getPCList().get(n2);
        }
        return null;
    }

    PlayerCharacter getCurrentPC() {
        int n = baseTabbedPane.getSelectedIndex();
        if (n < FIRST_CHAR_TAB) {
            return null;
        }
        return PCGen_Frame1.getPCForTabAt(n);
    }

    private static void setTabName(int n, String string) {
        PCGen_Frame1.getBaseTabbedPane().setTitleAt(n, string);
    }

    private boolean getUserChoice() {
        try {
            AskUserPopup askUserPopup = new AskUserPopup(this, "Remove temporary files?", true);
            askUserPopup.setVisible(true);
            return askUserPopup.getDelete();
        }
        catch (Exception exception) {
            Logging.errorPrint("Error in PCGen_Frame1::getUserChoice", exception);
            return false;
        }
    }

    private void addPCTab(PlayerCharacter playerCharacter) {
        playerCharacter.addObserver(this);
        if (characterPane == null) {
            characterPane = new CharacterInfo(playerCharacter, this.tempTabList);
        } else {
            this.resetCharacterTabs();
        }
        characterPane.resetToSummaryTab();
        baseTabbedPane.addTab(playerCharacter.getDisplayName(), null, characterPane, SettingsHandler.isToolTipTextShown() ? playerCharacter.getFullDisplayName() : null);
        baseTabbedPane.setSelectedIndex(baseTabbedPane.getTabCount() - 1);
    }

    private void baseTabbedPane_changePanel() {
        baseTabbedPane.requestFocus();
        PCGen_Frame1.enableDisableMenuItems();
        this.killKitSelector();
        int n = baseTabbedPane.getSelectedIndex();
        if (n < FIRST_CHAR_TAB) {
            PToolBar.displayHelpPanel(false);
        } else {
            Globals.setCurrentPC(this.getCurrentPC());
            characterPane.setPc(this.getCurrentPC());
            if (Globals.getPCList().size() > 1) {
                this.resetCharacterTabs();
            }
            Component component = baseTabbedPane.getComponent(n);
            FocusListener[] focusListenerArray = component.getFocusListeners();
            for (int i = 0; i < focusListenerArray.length; ++i) {
                component.removeFocusListener(focusListenerArray[i]);
            }
            baseTabbedPane.setComponentAt(n, characterPane);
            this.featList_Changed();
            JTabbedPane jTabbedPane = (JTabbedPane)characterPane.getComponent(0);
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 >= 0) {
                jTabbedPane.getComponent(n2).requestFocus();
                ComponentEvent componentEvent = new ComponentEvent(jTabbedPane.getComponent(n2), 102);
                jTabbedPane.getComponent(n2).dispatchEvent(componentEvent);
            }
        }
        baseTabbedPane.requestFocus();
    }

    void checkResources() {
        if (JEPResourceChecker.getMissingResourceCount() != 0) {
            new LinkableHtmlMessage((Frame)this, JEPResourceChecker.getMissingResourceMessage(), "PCGen").setVisible(true);
        }
    }

    private boolean closePCTabAt(int n, boolean bl) {
        boolean bl2 = true;
        PlayerCharacter playerCharacter = PCGen_Frame1.getPCForTabAt(n);
        Globals.setCurrentPC(playerCharacter);
        if (playerCharacter != null && playerCharacter.isDirty()) {
            int n2 = 0;
            if (bl) {
                n2 = JOptionPane.showConfirmDialog(this, playerCharacter.getDisplayName() + " changed.  Save changes before closing?", "Save " + playerCharacter.getDisplayName() + " before closing?", 1);
            } else {
                bl2 = false;
            }
            if (n2 == 2 || n2 == -1) {
                return false;
            }
            if (n2 == 1) {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        characterPane.setPaneForUpdate(characterPane.infoSpells());
        characterPane.refresh();
        if (n >= FIRST_CHAR_TAB) {
            String string;
            characterPane.storeFilterSettings();
            if (bl2 && playerCharacter != null && !this.savePC(playerCharacter, (string = playerCharacter.getFileName()).equals(""))) {
                return false;
            }
        }
        GMBus.send(new PCClosedMessage(this, playerCharacter));
        this.disposePCTabAt(n);
        return true;
    }

    private void disposePCTabAt(int n) {
        int n2;
        PlayerCharacter playerCharacter = PCGen_Frame1.getPCForTabAt(n);
        Globals.setCurrentPC(playerCharacter);
        int n3 = n == baseTabbedPane.getTabCount() - 1 ? n - 1 : n;
        ChangeListener[] changeListenerArray = baseTabbedPane.getChangeListeners();
        for (n2 = 0; n2 < changeListenerArray.length; ++n2) {
            baseTabbedPane.removeChangeListener(changeListenerArray[n2]);
        }
        baseTabbedPane.removeTabAt(n);
        for (n2 = changeListenerArray.length - 1; n2 >= 0; --n2) {
            baseTabbedPane.addChangeListener(changeListenerArray[n2]);
        }
        Globals.getPCList().remove(n - FIRST_CHAR_TAB);
        baseTabbedPane.setSelectedIndex(n3 == FIRST_CHAR_TAB - 1 ? 0 : n3);
        this.baseTabbedPane_changePanel();
        this.killKitSelector();
        PlayerCharacter playerCharacter2 = PCGen_Frame1.getPCForTabAt(n3);
        Globals.setCurrentPC(playerCharacter2);
    }

    private void doNewItem() {
        if (!Globals.displayListsHappy()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_newCharNoSources"), "PCGen", MessageType.ERROR);
            return;
        }
        if (Globals.getGameModeHasPointPool() && !SettingsHandler.getGame().isPurchaseStatMode()) {
            ShowMessageDelegate.showMessageDialog("In order for this game mode to work properly you need to select a Purchase Mode in Settings->Preferences.\nThere should be a selection for user-rolled abilities as well.", "PCGen", MessageType.ERROR);
            return;
        }
        PlayerCharacter playerCharacter = new PlayerCharacter();
        Globals.getPCList().add(playerCharacter);
        ++this.newPCNameCount;
        playerCharacter.setName("New" + this.newPCNameCount);
        playerCharacter.setDirty(true);
        this.addPCTab(playerCharacter);
        GMBus.send(new PCLoadedMessage(this, playerCharacter));
    }

    private void enableClose(boolean bl) {
        this.pcgenMenuBar.closeItem.setEnabled(bl);
        this.toolBar.closeItem.setEnabled(bl);
        this.pcPopupMenu.getCloseItem().setEnabled(bl);
    }

    private void enableCloseAll(boolean bl) {
        this.pcgenMenuBar.closeAllItem.setEnabled(bl);
    }

    private void enableExport(boolean bl) {
        this.pcgenMenuBar.exportMenu.setEnabled(bl);
    }

    private void enableKit(boolean bl) {
        this.pcgenMenuBar.addKit.setEnabled(bl);
        this.toolBar.addKit.setEnabled(bl);
    }

    private void enablePartyClose(boolean bl) {
        this.pcgenMenuBar.partyCloseItem.setEnabled(bl);
    }

    private void enablePartySave(boolean bl) {
        this.pcgenMenuBar.partySaveItem.setEnabled(bl);
    }

    private void enablePartySaveAs(boolean bl) {
        this.pcgenMenuBar.partySaveAsItem.setEnabled(bl);
    }

    private void enablePrint(boolean bl) {
        this.pcgenMenuBar.printItem.setEnabled(bl);
        this.toolBar.printItem.setEnabled(bl);
    }

    private void enablePrintPreview(boolean bl) {
        this.pcgenMenuBar.printPreviewItem.setEnabled(bl);
        this.toolBar.printPreviewItem.setEnabled(bl);
    }

    private void enableRevertToSaved(boolean bl) {
        this.pcgenMenuBar.revertToSavedItem.setEnabled(bl);
        this.pcPopupMenu.getRevertToSavedItem().setEnabled(bl);
    }

    private void enableSave(boolean bl) {
        this.pcgenMenuBar.saveItem.setEnabled(bl);
        this.toolBar.saveItem.setEnabled(bl);
        this.pcPopupMenu.getSaveItem().setEnabled(bl);
    }

    private void enableSaveAll(boolean bl) {
        this.pcgenMenuBar.saveAllItem.setEnabled(bl);
    }

    private void enableSaveAs(boolean bl) {
        this.pcgenMenuBar.saveAsItem.setEnabled(bl);
        this.pcPopupMenu.getSaveAsItem().setEnabled(bl);
    }

    public void exitItem_actionPerformed() {
        this.pcgenMenuBar.exitItem.requestFocus();
        this.handleQuit();
    }

    private void handleInitHolderListSendMessage(InitHolderListSendMessage initHolderListSendMessage) {
        InitHolderList initHolderList = initHolderListSendMessage.getInitHolderList();
        for (int i = 0; i < initHolderList.size(); ++i) {
            InitHolder initHolder = (InitHolder)initHolderList.get(i);
            if (!(initHolder instanceof PcgCombatant)) continue;
            PcgCombatant pcgCombatant = (PcgCombatant)initHolder;
            PlayerCharacter playerCharacter = pcgCombatant.getPC();
            Globals.getPCList().add(playerCharacter);
            playerCharacter.setDirty(true);
            this.addPCTab(playerCharacter);
        }
    }

    private void handleOpenPCGRequestMessage(OpenPCGRequestMessage openPCGRequestMessage) {
        File file = openPCGRequestMessage.getFile();
        if (PCGFile.isPCGenCharacterFile(file)) {
            openPCGRequestMessage.setPlayerCharacter(this.loadPCFromFile(file, openPCGRequestMessage.blockLoadedMessage(), false));
        } else if (PCGFile.isPCGenPartyFile(file)) {
            this.loadPartyFromFile(file);
        }
    }

    private void handleFetchOpenPCGRequestMessage() {
        for (int i = 0; i < Globals.getPCList().size(); ++i) {
            GMBus.send(new PCLoadedMessage(this, Globals.getPCList().get(i)));
        }
    }

    private void handleQuit() {
        if (SettingsHandler.getLeftUpperCorner() == null) {
            SettingsHandler.setLeftUpperCorner(new Point(0, 0));
        }
        if (this.getState() != 1) {
            SettingsHandler.getLeftUpperCorner().setLocation(this.getLocationOnScreen().getX(), this.getLocationOnScreen().getY());
        }
        if ((this.getExtendedState() & 6) != 0) {
            SettingsHandler.setWindowState(6);
        } else if ((this.getExtendedState() & 2) != 0) {
            SettingsHandler.setWindowState(2);
        } else if ((this.getExtendedState() & 4) != 0) {
            SettingsHandler.setWindowState(4);
        } else {
            SettingsHandler.setWindowState(0);
        }
        int n = baseTabbedPane.getTabCount();
        while (n > FIRST_CHAR_TAB) {
            if (this.closePCTabAt(n - 1, true)) {
                n = baseTabbedPane.getTabCount();
                continue;
            }
            return;
        }
        GMBus.send(new WindowClosedMessage(this));
        SettingsHandler.storeFilterSettings(this.mainSource);
        if (SettingsHandler.getSaveCustomEquipment()) {
            CustomData.writeCustomItems();
        }
        this.removeTemporaryFiles();
        SettingsHandler.writeOptionsProperties(this.getCurrentPC());
        this.dispose();
        System.exit(0);
    }

    private void handleStateChangedMessage() {
        if (this.isFocused() && characterPane != null) {
            PlayerCharacter playerCharacter = PCGen_Frame1.getPCForTabAt(baseTabbedPane.getSelectedIndex());
            Globals.setCurrentPC(playerCharacter);
            characterPane.setPaneForUpdate(characterPane.infoSpecialAbilities());
            characterPane.setPaneForUpdate(characterPane.infoSummary());
            characterPane.setPaneForUpdate(characterPane.infoRace());
            characterPane.setPaneForUpdate(characterPane.infoClasses());
            characterPane.setPaneForUpdate(characterPane.infoDomain());
            characterPane.setPaneForUpdate(characterPane.infoAbilities());
            characterPane.setPaneForUpdate(characterPane.infoSkills());
            characterPane.setPaneForUpdate(characterPane.infoSpells());
            characterPane.setPaneForUpdate(characterPane.infoInventory());
            characterPane.setPaneForUpdate(characterPane.infoDesc());
            characterPane.refresh();
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    private void handleTabAddMessage(TabAddMessage tabAddMessage) {
        if (tabAddMessage.getSystem().equals("PCGen")) {
            if (tabAddMessage.getPane() instanceof CharacterInfoTab) {
                if (characterPane == null) {
                    this.tempTabList.add(tabAddMessage.getPane());
                } else {
                    characterPane.addTab((CharacterInfoTab)((Object)tabAddMessage.getPane()));
                }
            } else {
                ++FIRST_CHAR_TAB;
                baseTabbedPane.addTab(tabAddMessage.getName(), tabAddMessage.getPane());
            }
        }
    }

    private void handlePauseRefreshMessage() {
        if (characterPane != null) {
            characterPane.setRefresh(false);
        }
    }

    private void handleResumeRefreshMessage() {
        if (characterPane != null) {
            characterPane.setRefresh(true);
            characterPane.refresh();
        }
    }

    private void jbInit() throws Exception {
        IconUtilitities.maybeSetIcon(this, "PCGenApp.png");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.panelMain.setLayout(this.borderLayout1);
        this.setSize(new Dimension(700, 600));
        this.setGameModeTitle();
        this.setJMenuBar(this.pcgenMenuBar);
        this.panelMain.add((Component)this.toolBar, "North");
        this.showToolBar();
        baseTabbedPane.setTabPlacement(SettingsHandler.getTabPlacement());
        baseTabbedPane.setDoubleBuffered(true);
        baseTabbedPane.setMinimumSize(new Dimension(620, 350));
        baseTabbedPane.setPreferredSize(new Dimension(620, 350));
        baseTabbedPane.addMouseListener(this.popupListener);
        this.panelSouth.setLayout(this.borderLayout2);
        this.panelSouthEast.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.panelSouthCenter.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.panelMain.add((Component)baseTabbedPane, "Center");
        GameMode gameMode = SettingsHandler.getGame();
        this.mainSource = new MainSource(false);
        if (gameMode != null && gameMode.getTabShown(Tab.SOURCES) && SettingsHandler.useAdvancedSourceSelect()) {
            baseTabbedPane.addTab(gameMode.getTabName(Tab.SOURCES), this.mainSource);
            baseTabbedPane.setToolTipTextAt(0, SettingsHandler.isToolTipTextShown() ? "Select and load source materials" : null);
        } else {
            this.infoPanel = new InfoPanel();
            baseTabbedPane.addTab(gameMode.getTabName(Tab.INFO), this.infoPanel);
            baseTabbedPane.setToolTipTextAt(0, SettingsHandler.isToolTipTextShown() ? "Select and load source materials" : null);
        }
        this.getContentPane().add((Component)this.panelSouth, "South");
        this.panelSouth.add((Component)statusBar, "South");
        baseTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PCGen_Frame1.this.baseTabbedPane_changePanel();
            }
        });
        this.mainSource.addComponentListener(this.toolBar.getComponentListener());
        if (!UIFactory.isWindowsUI() || !System.getProperty("java.version").startsWith("1.4.0")) {
            this.addWindowFocusListener(new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                    PCGen_Frame1.this.stateUpdate(windowEvent);
                }

                public void windowLostFocus(WindowEvent windowEvent) {
                }
            });
        }
    }

    private void killKitSelector() {
        if (this.kitSelector != null) {
            if (this.kitSelector.isVisible()) {
                this.kitSelector.closeDialog();
            }
            this.kitSelector = null;
        }
    }

    private void moveTab(int n, int n2) {
        List<PlayerCharacter> list = Globals.getPCList();
        PlayerCharacter playerCharacter = list.get(n - FIRST_CHAR_TAB);
        list.remove(n - FIRST_CHAR_TAB);
        list.add(n2 - FIRST_CHAR_TAB, playerCharacter);
        Globals.setPCList(list);
        PCGen_Frame1.forceUpdate_PlayerTabs();
        baseTabbedPane.setSelectedIndex(n2);
    }

    private void partySaveItem(boolean bl) {
        Object object;
        File file;
        boolean bl2 = false;
        if (this.partyFileName.length() == 0) {
            file = new File(SettingsHandler.getPcgPath(), "Party.pcp");
            this.partyFileName = file.getAbsolutePath();
            bl2 = true;
        } else {
            file = new File(this.partyFileName);
        }
        File file2 = file;
        if (bl || bl2) {
            object = new JFileChooser();
            ((JFileChooser)object).setFileFilter(this.partyFilter);
            ((JFileChooser)object).setSelectedFile(file);
            FilenameChangeListener filenameChangeListener = new FilenameChangeListener(this.partyFileName, (JFileChooser)object);
            ((Container)object).addPropertyChangeListener(filenameChangeListener);
            int n = ((JFileChooser)object).showSaveDialog(this);
            ((Component)object).removePropertyChangeListener(filenameChangeListener);
            if (n == 0) {
                int n2;
                file2 = ((JFileChooser)object).getSelectedFile();
                if (!PCGFile.isPCGenPartyFile(file2)) {
                    file2 = new File(file2.getParent(), file2.getName() + ".pcp");
                }
                if (file2.isDirectory()) {
                    ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a party.", "PCGen", MessageType.ERROR);
                    return;
                }
                if (file2.exists() && (bl2 || !file2.getName().equals(file.getName())) && (n2 = JOptionPane.showConfirmDialog(this, "The file " + file2.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + file2.getName(), 0)) != 0) {
                    return;
                }
            } else {
                return;
            }
        }
        try {
            this.partyFileName = file2.getAbsolutePath();
            object = Party.makePartyFromFile(file2);
            ((Party)object).addAllOpenCharacters();
            ((Party)object).save();
            this.enablePartyClose(true);
        }
        catch (IOException iOException) {
            ShowMessageDelegate.showMessageDialog("Could not save " + this.partyFileName, "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not save" + this.partyFileName, iOException);
            return;
        }
        this.pcgenMenuBar.openRecentPartyMenu.add(this.partyFileName, file2);
    }

    protected void resetUI() {
        this.mainSource.resetUI();
    }

    private void removeTemporaryFiles() {
        final boolean bl = SettingsHandler.getCleanupTempFiles();
        if (!bl) {
            return;
        }
        String string = SettingsHandler.getTempPath() + File.separator;
        new File(string).list(new FilenameFilter(){
            boolean myCleanUp;
            {
                this.myCleanUp = bl;
            }

            public boolean accept(File file, String string) {
                try {
                    if (string.startsWith("currentPC")) {
                        if (!this.myCleanUp) {
                            this.myCleanUp = PCGen_Frame1.this.getUserChoice();
                        }
                        if (this.myCleanUp) {
                            File file2 = new File(file, string);
                            file2.delete();
                        }
                    }
                }
                catch (Exception exception) {
                    Logging.errorPrint("removeTemporaryFiles", exception);
                }
                return false;
            }
        });
    }

    private void resetCharacterTabs() {
        if (characterPane == null) {
            return;
        }
        for (int i = FIRST_CHAR_TAB; i < baseTabbedPane.getTabCount(); ++i) {
            baseTabbedPane.setComponentAt(i, new JPanel());
        }
    }

    private void saveAllPCs() {
        int n = Globals.getPCList().size();
        for (int i = 0; i < n; ++i) {
            PlayerCharacter playerCharacter = Globals.getPCList().get(i);
            if (!playerCharacter.isDirty()) continue;
            this.savePC(playerCharacter, false);
        }
    }

    private void showToolBar() {
        this.toolBar.setVisible(SettingsHandler.isToolBarShown());
    }

    void warnAboutMissingResource() {
        new LinkableHtmlMessage((Frame)this, FOPResourceChecker.getMissingResourceMessage(), "PCGen").setVisible(true);
    }

    public void update(Observable observable, Object object) {
        if (object != null && "TabName".equals(object.toString())) {
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
        PCGen_Frame1.enableDisableMenuItems();
    }

    public static void setCharacterPane(CharacterInfo characterInfo) {
        characterPane = characterInfo;
    }

    public void aboutItem_actionPerformed() {
        this.pcgenMenuBar.handleAbout();
    }

    public void refreshCharInfoTabs() {
        if (characterPane != null) {
            characterPane.refreshCharInfoTabs();
        }
    }

    public void switchSourceSelectMeans(boolean bl) {
        GameMode gameMode = SettingsHandler.getGame();
        if (bl) {
            baseTabbedPane.setComponentAt(0, this.mainSource);
            baseTabbedPane.setTitleAt(0, gameMode.getTabName(Tab.SOURCES));
            baseTabbedPane.setToolTipTextAt(0, SettingsHandler.isToolTipTextShown() ? "Select and load source materials" : null);
        } else {
            if (this.infoPanel == null) {
                this.infoPanel = new InfoPanel();
            }
            baseTabbedPane.setComponentAt(0, this.infoPanel);
            baseTabbedPane.setTitleAt(0, gameMode.getTabName(Tab.INFO));
            baseTabbedPane.setToolTipTextAt(0, SettingsHandler.isToolTipTextShown() ? "Select and load source materials" : null);
            PCGen_Frame1.setMessageAreaText(PropertyFactory.getString("in_qsrc_messageText"));
            SourceSelectionDialog sourceSelectionDialog = new SourceSelectionDialog((Frame)PCGen_Frame1.getInst(), true);
            sourceSelectionDialog.setVisible(true);
            PCGen_Frame1.restoreMessageAreaText();
        }
        SettingsHandler.setUseAdvancedSourceSelect(bl);
    }

    static {
        waitQueue = new WaitCursorEventQueue(750);
        usingWaitCursor = false;
        characterPane = null;
        statusBar = new StatusBar();
        baseTabbedPane = new JTabbedPane();
    }

    private static final class WaitCursorEventQueue
    extends EventQueue {
        private WaitCursorTimer waitTimer;
        private int delay;

        public WaitCursorEventQueue(int n) {
            this.delay = n;
            this.waitTimer = new WaitCursorTimer();
            this.waitTimer.setDaemon(true);
            this.waitTimer.start();
        }

        public void doPop() {
            this.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchEvent(AWTEvent aWTEvent) {
            this.waitTimer.startTimer(aWTEvent.getSource());
            try {
                super.dispatchEvent(aWTEvent);
            }
            catch (Exception exception) {
                Logging.errorPrint("Uncaught error - ignoring", exception);
            }
            finally {
                this.waitTimer.stopTimer();
            }
        }

        private final class WaitCursorTimer
        extends Thread {
            private Component parent;
            private Object source;

            private WaitCursorTimer() {
            }

            public synchronized void run() {
                while (true) {
                    try {
                        while (true) {
                            MenuContainer menuContainer;
                            this.wait();
                            this.wait(WaitCursorEventQueue.this.delay);
                            if (this.source instanceof Component) {
                                this.parent = SwingUtilities.getRoot((Component)this.source);
                            } else if (this.source instanceof MenuComponent && (menuContainer = ((MenuComponent)this.source).getParent()) instanceof Component) {
                                this.parent = SwingUtilities.getRoot((Component)menuContainer);
                            }
                            if (this.parent == null || !this.parent.isShowing()) continue;
                            this.parent.setCursor(Cursor.getPredefinedCursor(3));
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }

            synchronized void startTimer(Object object) {
                this.source = object;
                this.notify();
            }

            synchronized void stopTimer() {
                if (this.parent == null) {
                    this.interrupt();
                } else {
                    this.parent.setCursor(null);
                    this.parent = null;
                }
            }
        }
    }

    private class AskUserPopup
    extends JDialog {
        static final long serialVersionUID = 1042236188732008819L;
        private boolean doDelete;

        public AskUserPopup(JFrame jFrame, String string, boolean bl) {
            super(jFrame, string, bl);
            this.doDelete = false;
            this.initComponents();
            this.setLocationRelativeTo(jFrame);
        }

        public boolean getDelete() {
            return this.doDelete;
        }

        private void setDelete(boolean bl) {
            this.doDelete = bl;
        }

        private void initComponents() {
            JButton jButton = new JButton("Yes");
            JButton jButton2 = new JButton("No");
            JPanel jPanel = new JPanel();
            final JCheckBox jCheckBox = new JCheckBox("Don't ask again");
            jPanel.add(jCheckBox);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCheckBox.isSelected()) {
                        SettingsHandler.setCleanupTempFiles(true);
                    }
                    AskUserPopup.this.setDelete(true);
                    AskUserPopup.this.dispose();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCheckBox.isSelected()) {
                        SettingsHandler.setCleanupTempFiles(false);
                    }
                    AskUserPopup.this.dispose();
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
        }
    }

    static final class PopupListener
    extends MouseAdapter {
        JTabbedPane tabbedPane;
        MainPopupMenu mainPopupMenu;
        PCPopupMenu pcPopupMenu;
        int index;

        PopupListener(JTabbedPane jTabbedPane, MainPopupMenu mainPopupMenu, PCPopupMenu pCPopupMenu) {
            this.tabbedPane = jTabbedPane;
            this.mainPopupMenu = mainPopupMenu;
            this.pcPopupMenu = pCPopupMenu;
        }

        public int getTabIndex() {
            return this.index;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && !SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            this.index = this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (this.index < 0) {
                return;
            }
            PCGen_Frame1.enableDisableMenuItems();
            if (this.index < FIRST_CHAR_TAB) {
                this.mainPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            int n = this.tabbedPane.getTabCount();
            if (n == FIRST_CHAR_TAB + 1) {
                this.pcPopupMenu.setShiftType(0);
            } else if (n == FIRST_CHAR_TAB + 2) {
                this.pcPopupMenu.setShiftType(this.index == 1 ? 2 : 1);
            } else if (this.index == FIRST_CHAR_TAB) {
                this.pcPopupMenu.setShiftType(5);
            } else if (this.index == n - 1) {
                this.pcPopupMenu.setShiftType(4);
            } else {
                this.pcPopupMenu.setShiftType(3);
            }
            this.pcPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private int indexAtLocation(int n, int n2) {
            TabbedPaneUI tabbedPaneUI = this.tabbedPane.getUI();
            if (tabbedPaneUI != null) {
                return tabbedPaneUI.tabForCoordinate(this.tabbedPane, n, n2);
            }
            return -1;
        }
    }

    static final class FilenameChangeListener
    implements PropertyChangeListener {
        private JFileChooser fileChooser;
        private String lastSelName;

        FilenameChangeListener(String string, JFileChooser jFileChooser) {
            this.lastSelName = string;
            this.fileChooser = jFileChooser;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("SelectedFileChangedProperty")) {
                this.onSelectedFileChange(propertyChangeEvent);
            } else if (string.equals("directoryChanged")) {
                this.onDirectoryChange();
            }
        }

        private void onDirectoryChange() {
            this.fileChooser.setSelectedFile(new File(this.fileChooser.getCurrentDirectory(), this.lastSelName));
        }

        private void onSelectedFileChange(PropertyChangeEvent propertyChangeEvent) {
            File file = (File)propertyChangeEvent.getNewValue();
            if (file != null && !file.isDirectory()) {
                this.lastSelName = file.getName();
            }
        }
    }
}

