/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.DataInstaller;
import pcgen.gui.ExportPDFPopup;
import pcgen.gui.ExportPopup;
import pcgen.gui.ExportTextPopup;
import pcgen.gui.FrameActionListener;
import pcgen.gui.GameModes;
import pcgen.gui.LoggingLevelMenu;
import pcgen.gui.LstEditorMain;
import pcgen.gui.MainAbout;
import pcgen.gui.MainDebug;
import pcgen.gui.MainPrint;
import pcgen.gui.Options;
import pcgen.gui.PCGenPopup;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PToolBar;
import pcgen.gui.TreasureGeneratorDlg;
import pcgen.gui.UIFactory;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.pcGenGUI;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.JOpenRecentMenu;
import pcgen.gui.utils.Utility;
import pcgen.util.FOPResourceChecker;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class PCGenMenuBar
extends JMenuBar {
    private final PCGen_Frame1 mainFrame;
    static final long serialVersionUID = 1042236188732008819L;
    public ExportPopup exportPopup = null;
    AboutFrame aboutFrame = null;
    DebugFrame debugFrame = null;
    ExportPDFPopup exportPDFPopup = null;
    ExportTextPopup exportTextPopup = null;
    private JCheckBoxMenuItem debugMode;
    JMenu exportMenu;
    private JMenu filtersMenu;
    private JMenu helpMenu;
    JMenuItem addKit;
    JMenuItem closeAllItem;
    JMenuItem closeItem;
    JMenuItem exitItem;
    JMenuItem exportItem;
    private JMenuItem exportPDFItem;
    private JMenuItem installDataItem;
    JMenuItem listEditor;
    JMenuItem newItem;
    JMenuItem newNPCItem;
    JMenuItem openItem;
    JMenuItem partyCloseItem;
    JMenuItem partyOpenItem;
    JMenuItem partySaveAsItem;
    JMenuItem partySaveItem;
    JMenuItem printItem;
    JMenuItem printPreviewItem;
    JMenuItem revertToSavedItem;
    JMenuItem saveAllItem;
    JMenuItem saveAsItem;
    JMenuItem saveItem;
    JMenuItem treasureItem;
    JOpenRecentMenu openRecentPCMenu;
    JOpenRecentMenu openRecentPartyMenu;
    private LoggingLevelMenu loggingMenu;
    PrintFrame printFrame = null;
    boolean enablePDF;
    private GameModes gameModeMenu;

    public PCGenMenuBar(PCGen_Frame1 pCGen_Frame1, FrameActionListener frameActionListener) {
        this.mainFrame = pCGen_Frame1;
        this.enablePDF = FOPResourceChecker.getMissingResourceCount() == 0;
        this.mainFrame.checkResources();
        JMenu jMenu = this.createFileMenu(frameActionListener);
        this.add(jMenu);
        Options options = new Options();
        this.add(options);
        this.gameModeMenu = options.getGameModeMenu();
        JMenu jMenu2 = this.createToolsMenu();
        this.add(jMenu2);
        JMenu jMenu3 = this.createDebugMenu();
        this.add(jMenu3);
        this.helpMenu = this.createHelpMenu();
        this.add(this.helpMenu);
        this.separateHelpMenu(!UIFactory.isWindowsUI());
    }

    private JMenu createFileMenu(FrameActionListener frameActionListener) {
        JMenu jMenu = Utility.createMenu("mnuFile", null, true);
        this.newItem = Utility.createMenuItem("mnuFileNew", frameActionListener.newActionListener, "file.new", "shortcut N", "New16.gif", false);
        jMenu.add(this.newItem);
        this.newNPCItem = Utility.createMenuItem("mnuFileNewNPC", frameActionListener.newNPCActionListener, "file.newNPC", null, "NewNPC16.gif", false);
        jMenu.add(this.newNPCItem);
        this.openItem = Utility.createMenuItem("mnuFileOpen", frameActionListener.openActionListener, "file.open", "shortcut O", "Open16.gif", true);
        jMenu.add(this.openItem);
        this.openRecentPCMenu = new JOpenRecentMenu(new JOpenRecentMenu.OpenRecentCallback(){

            public void openRecentPerformed(ActionEvent actionEvent, File file) {
                PCGenMenuBar.this.mainFrame.loadPCFromFile(file);
            }
        });
        jMenu.add(this.openRecentPCMenu);
        jMenu.addSeparator();
        this.closeItem = Utility.createMenuItem("mnuFileClose", frameActionListener.closeActionListener, "file.close", "shortcut W", "Close16.gif", false);
        jMenu.add(this.closeItem);
        this.closeAllItem = Utility.createMenuItem("mnuFileCloseAll", frameActionListener.closeAllActionListener, "file.closeall", null, "CloseAll16.gif", false);
        jMenu.add(this.closeAllItem);
        this.saveItem = Utility.createMenuItem("mnuFileSave", frameActionListener.saveActionListener, "file.save", "shortcut S", "Save16.gif", false);
        jMenu.add(this.saveItem);
        this.saveAsItem = Utility.createMenuItem("mnuFileSaveAs", frameActionListener.saveAsActionListener, "file.saveas", "shift-shortcut S", "SaveAs16.gif", false);
        jMenu.add(this.saveAsItem);
        this.saveAllItem = Utility.createMenuItem("mnuFileSaveAll", frameActionListener.saveAllActionListener, "file.saveall", null, "SaveAll16.gif", false);
        jMenu.add(this.saveAllItem);
        this.revertToSavedItem = Utility.createMenuItem("mnuFileRevertToSaved", frameActionListener.revertToSavedActionListener, "file.reverttosaved", "shortcut R", null, false);
        jMenu.add(this.revertToSavedItem);
        jMenu.addSeparator();
        JMenu jMenu2 = Utility.createMenu("mnuFileParty", null, true);
        jMenu.add(jMenu2);
        this.partyOpenItem = Utility.createMenuItem("mnuFilePartyOpen", frameActionListener.partyOpenActionListener, "file.party.open", null, "Open16.gif", true);
        jMenu2.add(this.partyOpenItem);
        this.openRecentPartyMenu = new JOpenRecentMenu(new JOpenRecentMenu.OpenRecentCallback(){

            public void openRecentPerformed(ActionEvent actionEvent, File file) {
                PCGenMenuBar.this.mainFrame.loadPartyFromFile(file);
            }
        });
        jMenu2.add(this.openRecentPartyMenu);
        this.partyCloseItem = Utility.createMenuItem("mnuFilePartyClose", frameActionListener.partyCloseActionListener, "file.party.close", null, "Close16.gif", false);
        jMenu2.addSeparator();
        jMenu2.add(this.partyCloseItem);
        this.partySaveItem = Utility.createMenuItem("mnuFilePartySave", frameActionListener.partySaveActionListener, "file.party.save", null, "Save16.gif", false);
        jMenu2.add(this.partySaveItem);
        this.partySaveAsItem = Utility.createMenuItem("mnuFilePartySaveAs", frameActionListener.partySaveAsActionListener, "file.party.saveas", null, "SaveAs16.gif", false);
        jMenu2.add(this.partySaveAsItem);
        jMenu.addSeparator();
        this.printPreviewItem = Utility.createMenuItem("mnuFilePrintPreview", frameActionListener.printPreviewActionListener, "file.printpreview", null, "PrintPreview16.gif", false);
        jMenu.add(this.printPreviewItem);
        this.printItem = Utility.createMenuItem("mnuFilePrint", frameActionListener.printActionListener, "file.print", "shortcut P", "Print16.gif", false);
        jMenu.add(this.printItem);
        jMenu.addSeparator();
        this.exportMenu = Utility.createMenu("mnuFileExport", "Export16.gif", false);
        jMenu.add(this.exportMenu);
        this.exportItem = Utility.createMenuItem("mnuFileExportStandard", frameActionListener.exportToStandardActionListener, "file.export.standard", null, null, true);
        this.exportMenu.add(this.exportItem);
        this.exportPDFItem = Utility.createMenuItem("mnuFileExportPDF", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PCGenMenuBar.this.enablePDF) {
                    if (PCGenMenuBar.this.exportPDFPopup == null) {
                        PCGenMenuBar.this.exportPDFPopup = new ExportPDFPopup(PCGen_Frame1.baseTabbedPane);
                    }
                    PCGenMenuBar.this.exportPDFPopup.setCurrentPCSelectionByTab();
                } else {
                    PCGenMenuBar.this.mainFrame.warnAboutMissingResource();
                }
            }
        }, "file.export.pdf", null, null, true);
        this.exportMenu.add(this.exportPDFItem);
        this.exportItem = Utility.createMenuItem("mnuFileExportText", frameActionListener.exportToTextActionListener, "file.export.text", null, null, true);
        this.exportMenu.add(this.exportItem);
        jMenu.addSeparator();
        this.addKit = Utility.createMenuItem("mnuFileAddKit", frameActionListener.addKitActionListener, "assign.kit", "shortcut K", "Information16.gif", false);
        jMenu.add(this.addKit);
        jMenu.addSeparator();
        this.exitItem = Utility.createMenuItem("mnuFileExit", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PCGenMenuBar.this.mainFrame.exitItem_actionPerformed();
            }
        }, "file.exit", "shortcut Q", null, true);
        jMenu.add(this.exitItem);
        return jMenu;
    }

    private JMenu createToolsMenu() {
        JMenu jMenu = Utility.createMenu("mnuTools", "wrench.gif", true);
        this.treasureItem = Utility.createMenuItem("mnuToolsTreasure", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new TreasureGeneratorDlg(PCGenMenuBar.this.mainFrame);
            }
        }, "tools.teasure", "shortcut T", null, true);
        jMenu.add(this.treasureItem);
        this.filtersMenu = Utility.createMenu("mnuToolsFilters", "Zoom16.gif", true);
        jMenu.add(this.filtersMenu);
        JMenuItem jMenuItem = Utility.createMenuItem("mnuToolsFiltersOpen", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.showHideFilterSelectDialog();
            }
        }, "tools.filters.open", null, "Zoom16.gif", true);
        this.filtersMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = Utility.createMenuItem("mnuToolsFiltersClear", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.clearSelectedFiltersForSelectedFilterable();
            }
        }, "tools.filters.clear", null, "RemoveZoom16.gif", true);
        this.filtersMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = Utility.createMenuItem("mnuToolsFiltersCustom", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.showHideFilterCustomDialog();
            }
        }, "tools.filters.custom", null, "CustomZoom16.gif", true);
        this.filtersMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = Utility.createMenuItem("mnuToolsFiltersEdit", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.showHideFilterEditorDialog();
            }
        }, "tools.filters.edit", null, "EditZoom16.gif", true);
        this.filtersMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = Utility.createMenuItem("mnuToolsGMGen", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PCGenMenuBar.this.mainFrame.openGMGen_actionPerformed();
            }
        }, "tools.gmgen", null, "gmgen_icon.png", true);
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        this.installDataItem = Utility.createMenuItem("mnuToolsInstallData", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataInstaller dataInstaller = new DataInstaller((Component)PCGenMenuBar.this.mainFrame);
                dataInstaller.setVisible(true);
            }
        }, "tools.installdata", null, null, true);
        jMenu.add(this.installDataItem);
        jMenu.addSeparator();
        this.listEditor = Utility.createMenuItem("mnuToolsListEditors", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new LstEditorMain().setVisible(true);
            }
        }, "tools.editors", null, null, true);
        jMenu.add(this.listEditor);
        return jMenu;
    }

    private JMenu createDebugMenu() {
        JMenu jMenu = Utility.createMenu("mnuDebug", null, true);
        this.loggingMenu = new LoggingLevelMenu();
        this.debugMode = new JCheckBoxMenuItem();
        this.debugMode.setText(PropertyFactory.getString("in_mnuDebugMode"));
        this.debugMode.setMnemonic(PropertyFactory.getMnemonic("in_mn_mnuDebugMode"));
        Utility.setDescription(this.debugMode, PropertyFactory.getString("in_mnuDebugModeTip"));
        this.debugMode.setSelected(Logging.isDebugMode());
        this.debugMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Logging.setDebugMode(PCGenMenuBar.this.debugMode.isSelected());
                PCGenMenuBar.this.loggingMenu.updateMenu();
                if (PCGenMenuBar.this.exportPopup != null) {
                    PCGenMenuBar.this.exportPopup.refreshTemplates();
                }
            }
        });
        jMenu.add(this.debugMode);
        jMenu.add(this.loggingMenu);
        JMenuItem jMenuItem = Utility.createMenuItem("mnuDebugConsole", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PCGenMenuBar.this.debugFrame == null) {
                    PCGenMenuBar.this.debugFrame = new DebugFrame();
                }
                PCGenMenuBar.this.debugFrame.setVisible(true);
            }
        }, "debug.console", null, null, true);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu createHelpMenu() {
        JMenu jMenu = Utility.createMenu("mnuHelp", "Help16.gif", true);
        JMenuItem jMenuItem = Utility.createMenuItem("mnuHelpContext", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PToolBar.displayHelpPanel(true);
            }
        }, "help.context", null, "ContextualHelp16.gif", true);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = Utility.createMenuItem("mnuHelpDocumentation", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new DocsFrame();
            }
        }, "help.docs", "F1", "Help16.gif", true);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = Utility.createMenuItem("mnuHelpOGL", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pcGenGUI.showLicense();
            }
        }, "help.ogl", null, null, true);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = Utility.createMenuItem("mnuHelpSponsors", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pcGenGUI.showSponsors();
            }
        }, "help.sponsors", null, null, true);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = Utility.createMenuItem("mnuHelpTipOfTheDay", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                pcGenGUI.showTipOfTheDay();
            }
        }, "help.tod", null, "TipOfTheDay16.gif", true);
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = Utility.createMenuItem("mnuHelpAbout", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PCGenMenuBar.this.mainFrame.aboutItem_actionPerformed();
            }
        }, "help.about", null, "About16.gif", true);
        jMenu.add(jMenuItem6);
        return jMenu;
    }

    public void separateHelpMenu(boolean bl) {
        boolean bl2;
        if (this.helpMenu == null) {
            throw new IllegalStateException();
        }
        int n = this.getComponentIndex(this.helpMenu);
        if (n == -1) {
            throw new IllegalStateException();
        }
        Component component = this.getComponent(n - 1);
        boolean bl3 = bl2 = !(component instanceof JMenu);
        if (bl && bl2) {
            return;
        }
        if (!bl && !bl2) {
            return;
        }
        if (bl) {
            this.add(Box.createHorizontalGlue(), n);
        } else {
            this.remove(n - 1);
        }
    }

    void checkPrintFrame() {
        if (this.printFrame == null) {
            this.printFrame = new PrintFrame();
        }
    }

    void handleAbout() {
        if (this.aboutFrame == null) {
            this.aboutFrame = new AboutFrame();
            this.aboutFrame.pack();
        }
        this.aboutFrame.setVisible(true);
    }

    JMenu getFiltersMenu() {
        return this.filtersMenu;
    }

    public GameModes getGameModeMenu() {
        return this.gameModeMenu;
    }

    private final class DocsFrame
    extends JFrame {
        public DocsFrame() {
            try {
                BrowserLauncher.openURL(SettingsHandler.getPcgenDocsDir().getAbsolutePath() + File.separator + "index.html");
            }
            catch (IOException iOException) {
                ShowMessageDelegate.showMessageDialog("Could not open docs in external browser. Have you set your default browser in the Preference menu? Sorry...", "PCGen", MessageType.ERROR);
                Logging.errorPrint("Could not open docs in external browser", iOException);
            }
        }
    }

    final class PrintFrame
    extends PCGenPopup {
        MainPrint mainPrint;

        public PrintFrame() {
            super("Print a PC or Party");
            this.mainPrint = null;
            this.mainPrint = new MainPrint(this, 1);
            this.setPanel(this.mainPrint);
            PCGenMenuBar.this.mainFrame.pack();
            PCGenMenuBar.this.mainFrame.setVisible(true);
        }

        public void setCurrentPCSelectionByTab() {
            if (this.mainPrint != null) {
                this.mainPrint.setCurrentPCSelection(PCGen_Frame1.baseTabbedPane.getSelectedIndex());
            }
        }
    }

    final class DebugFrame
    extends PCGenPopup {
        public DebugFrame() {
            super("Debug Console", new MainDebug());
        }
    }

    final class AboutFrame
    extends PCGenPopup {
        public AboutFrame() {
            super("About PCGen", new MainAbout());
        }
    }
}

