/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CsheetFilter;
import pcgen.gui.PFileChooser;
import pcgen.gui.TemplateListModel;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainExport
extends JPanel {
    static final long serialVersionUID = 6401354046356862511L;
    private static final CsheetFilter csheetFilter = new CsheetFilter();
    private static final CsheetFilter psheetFilter = new CsheetFilter(1);
    private JButton closeButton = new JButton();
    private JButton exportButton = new JButton();
    private JButton templatePathButton = new JButton();
    private JCheckBox cboxParty = new JCheckBox();
    private JLabel lblPCs = new JLabel();
    private JLabel lblTemplates = new JLabel();
    private JList pcList;
    private JList templateList;
    private JPanel buttonPanel = new JPanel();
    private JScrollPane pcScroll;
    private JScrollPane templateScroll;
    private TemplateListModel templateModel;
    private boolean partyMode = false;

    public MainExport(String string) {
        try {
            this.jbInit(string);
        }
        catch (Exception exception) {
            Logging.errorPrint("Error while initing form", exception);
        }
    }

    public void setCurrentPCSelection(int n) {
        this.pcList.updateUI();
        if (n > 0 && n - 1 < this.pcList.getModel().getSize()) {
            this.setPartyMode(false);
            this.pcList.setSelectedIndex(n - 1);
        } else {
            this.setPartyMode(true);
            this.pcList.setSelectedIndex(this.pcList.getModel().getSize() - 1);
        }
        this.setDefaultTemplateSelection();
    }

    void refreshTemplates() {
        ((TemplateListModel)this.templateList.getModel()).updateTemplateList();
    }

    private void setDefaultTemplateSelection() {
        int n;
        String string = this.partyMode ? SettingsHandler.getSelectedPartyHTMLOutputSheet() : SettingsHandler.getSelectedCharacterHTMLOutputSheet(null);
        File file = SettingsHandler.getPcgenOutputSheetDir();
        if (file != null && (n = file.getAbsolutePath().length() + 1) > 1 && n < string.length()) {
            string = string.substring(n);
        }
        this.templateList.setSelectedIndex(Math.max(0, this.templateModel.indexOf(string)));
    }

    private void setPartyMode(boolean bl) {
        if (this.partyMode != bl) {
            this.partyMode = bl;
            TemplateListModel templateListModel = (TemplateListModel)this.templateList.getModel();
            templateListModel.setPartyMode(bl);
            templateListModel.updateTemplateList();
            this.templateList.revalidate();
            this.templateList.updateUI();
            this.cboxParty.setSelected(bl);
        }
    }

    private void getTemplatePath() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(SettingsHandler.getHTMLOutputSheetPath()));
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            SettingsHandler.setPcgenOutputSheetDir(file.getParentFile());
            TemplateListModel templateListModel = (TemplateListModel)this.templateList.getModel();
            templateListModel.updateTemplateList();
            this.templateList.revalidate();
            this.setDefaultTemplateSelection();
        }
    }

    private void export() {
        String string = (String)this.templateList.getSelectedValue();
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        PFileChooser pFileChooser = new PFileChooser();
        pFileChooser.setFileSelectionMode(0);
        pFileChooser.setCurrentDirectory(new File(SettingsHandler.getHTMLOutputSheetPath()));
        pFileChooser.addChoosableFileFilter(null, "All Files (*.*)");
        if ("htm".equalsIgnoreCase(string2) || "html".equalsIgnoreCase(string2)) {
            pFileChooser.addChoosableFileFilter(null, "HTML Documents (*.htm, *.html)");
        } else if ("xml".equalsIgnoreCase(string2)) {
            pFileChooser.addChoosableFileFilter(null, "XML Documents (*.xml)");
        } else {
            String string3 = string2 + " Files";
            pFileChooser.addChoosableFileFilter(string2, string3 + " (*." + string2 + ")");
        }
        int[] nArray = !this.partyMode ? this.pcList.getSelectedIndices() : new int[]{-2};
        for (int i = 0; i < nArray.length; ++i) {
            String string4 = this.partyMode ? "Entire Party" : (String)this.pcList.getModel().getElementAt(nArray[i]);
            String string5 = this.partyMode ? null : Globals.getPCList().get(nArray[i]).getFileName();
            string5 = string5 != null && string5.length() > 0 ? new File(string5).getParent().toString() : SettingsHandler.getLastUsedPcgPath().toString();
            pFileChooser.setSelectedFile(new File(string5 + File.separator + string4 + "." + string2));
            pFileChooser.setDialogTitle("Export " + string4);
            if (pFileChooser.showSaveDialog(this) != 0) continue;
            String string6 = pFileChooser.getSelectedFile().getAbsolutePath();
            if (string6.length() < 1) {
                ShowMessageDelegate.showMessageDialog("You must set a filename.", "PCGen", MessageType.ERROR);
                continue;
            }
            try {
                int n2;
                File file = new File(string6);
                if (file.isDirectory()) {
                    ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a file.", "PCGen", MessageType.ERROR);
                    continue;
                }
                if (file.exists() && !SettingsHandler.getAlwaysOverwrite() && (n2 = JOptionPane.showConfirmDialog(this, "The file " + file.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + file.getName(), 0)) != 0) continue;
                this.printToFile(file, nArray[i]);
                Globals.executePostExportCommandStandard(string6);
                continue;
            }
            catch (IOException iOException) {
                ShowMessageDelegate.showMessageDialog("Could not export " + string4 + ". Try another filename.", "PCGen", MessageType.ERROR);
                Logging.errorPrint("Could not export " + string4, iOException);
            }
        }
    }

    private void jbInit(String string) throws Exception {
        this.lblPCs.setText("Select a Character:");
        this.pcList = new JList(new PCListModel());
        this.pcList.setSelectionMode(2);
        this.pcScroll = new JScrollPane();
        this.pcScroll.getViewport().setView(this.pcList);
        this.lblTemplates.setText("Select a Template:");
        if (string.equals("HTML_XML")) {
            this.templateModel = new TemplateListModel(csheetFilter, psheetFilter, this.partyMode, "htmlxml");
            this.templateList = new JList(this.templateModel);
        } else {
            this.templateModel = new TemplateListModel(csheetFilter, psheetFilter, this.partyMode, "text");
            this.templateList = new JList(this.templateModel);
        }
        this.templateList.setSelectionMode(0);
        this.templateScroll = new JScrollPane();
        this.templateScroll.getViewport().setView(this.templateList);
        this.templatePathButton.setText("Find Templates...");
        this.templatePathButton.setMnemonic(70);
        this.templatePathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainExport.this.getTemplatePath();
            }
        });
        this.exportButton.setText("Export");
        this.exportButton.setMnemonic(69);
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MainExport.this.templateList.getSelectedValue() == null) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_exportNoTemplate"), "PCGen", MessageType.ERROR);
                } else {
                    MainExport.this.export();
                }
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = (JFrame)MainExport.this.getParent().getParent().getParent().getParent();
                jFrame.dispose();
            }
        });
        this.buttonPanel.add(this.exportButton);
        this.buttonPanel.add(this.closeButton);
        this.cboxParty.setText("Entire Party");
        this.cboxParty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainExport.this.setPartyMode(MainExport.this.cboxParty.isSelected());
                MainExport.this.pcList.setEnabled(!MainExport.this.cboxParty.isSelected());
                MainExport.this.templateList.updateUI();
                boolean bl = ((TemplateListModel)MainExport.this.templateList.getModel()).getNumFiles() > 0;
                MainExport.this.exportButton.setEnabled(bl);
                MainExport.this.setDefaultTemplateSelection();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.buttonPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel2.add((Component)this.lblPCs, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.lblTemplates, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)this.pcScroll, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.8;
        jPanel2.add((Component)this.templateScroll, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)this.cboxParty, gridBagConstraints);
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "South");
        this.setSize(new Dimension(500, 400));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private void printToFile(File file, int n) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        File file2 = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
        if (this.partyMode) {
            SettingsHandler.setSelectedPartyHTMLOutputSheet(file2.getAbsolutePath());
            new ExportHandler(file2).write(Globals.getPCList(), bufferedWriter);
            bufferedWriter.close();
        } else {
            PlayerCharacter playerCharacter = Globals.getPCList().get(n);
            SettingsHandler.setSelectedCharacterHTMLOutputSheet(file2.getAbsolutePath(), playerCharacter);
            new ExportHandler(file2).write(playerCharacter, bufferedWriter);
        }
        bufferedWriter.close();
    }

    private static class PCListModel
    extends AbstractListModel {
        private PCListModel() {
        }

        public Object getElementAt(int n) {
            if (n < Globals.getPCList().size()) {
                PlayerCharacter playerCharacter = Globals.getPCList().get(n);
                return playerCharacter.getDisplayName();
            }
            return null;
        }

        public int getSize() {
            return Globals.getPCList().size();
        }
    }
}

