/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import gmgen.gui.GridBoxLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import pcgen.core.Globals;
import pcgen.gui.PCGenProp;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.JLabelPane;
import pcgen.persistence.lst.SponsorLoader;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainAbout
extends JPanel {
    static final long serialVersionUID = -423796320641536943L;
    private JButton mailingList;
    private JButton wwwSite;
    private JLabel dateLabel;
    private JLabel emailLabel;
    private JLabel helperLabel;
    private JLabel leaderLabel;
    private JLabel versionLabel;
    private JLabel javaVersionLabel;
    private JLabel wwwLink;
    private JScrollPane license;
    private JTabbedPane mainPane;
    private JTabbedPane monkeyTabPane;
    private JTextArea LGPLArea;
    private JTextArea otherLibrariesField;
    private JTextField projectLead;
    private JTextField releaseDate;
    private JTextField version;
    private JTextField javaVersion;

    MainAbout() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainPane = new JTabbedPane();
        this.mainPane.add(PropertyFactory.getString("in_abt_credits"), this.buildCreditsPanel());
        this.mainPane.add(PropertyFactory.getString("in_abt_libraries"), this.buildIncludesPanel());
        this.mainPane.add(PropertyFactory.getString("in_abt_license"), this.buildLicensePanel());
        this.mainPane.add(PropertyFactory.getString("in_abt_awards"), this.buildAwardsPanel());
        this.mainPane.add(PropertyFactory.getString("in_abt_sponsors"), this.buildSponsorsPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPane, "Center");
        this.mainPane.setPreferredSize(new Dimension(640, 480));
    }

    private JPanel buildCreditsPanel() {
        JPanel jPanel = new JPanel();
        this.versionLabel = new JLabel();
        this.dateLabel = new JLabel();
        this.javaVersionLabel = new JLabel();
        this.leaderLabel = new JLabel();
        this.helperLabel = new JLabel();
        this.wwwLink = new JLabel();
        this.emailLabel = new JLabel();
        this.version = new JTextField();
        this.releaseDate = new JTextField();
        this.javaVersion = new JTextField();
        this.projectLead = new JTextField();
        this.wwwSite = new JButton();
        this.mailingList = new JButton();
        this.monkeyTabPane = new JTabbedPane();
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.versionLabel.setText(PropertyFactory.getString("in_abt_version"));
        GridBagConstraints gridBagConstraints = this.buildConstraints(0, 0, 17);
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)this.versionLabel, gridBagConstraints);
        this.dateLabel.setText(PropertyFactory.getString("in_abt_release_date"));
        gridBagConstraints = this.buildConstraints(0, 1, 17);
        jPanel.add((Component)this.dateLabel, gridBagConstraints);
        this.javaVersionLabel.setText(PropertyFactory.getString("in_abt_java_version"));
        gridBagConstraints = this.buildConstraints(0, 2, 17);
        jPanel.add((Component)this.javaVersionLabel, gridBagConstraints);
        this.leaderLabel.setText(PropertyFactory.getString("in_abt_BD"));
        gridBagConstraints = this.buildConstraints(0, 3, 17);
        jPanel.add((Component)this.leaderLabel, gridBagConstraints);
        this.wwwLink.setText(PropertyFactory.getString("in_abt_web"));
        gridBagConstraints = this.buildConstraints(0, 4, 17);
        jPanel.add((Component)this.wwwLink, gridBagConstraints);
        this.emailLabel.setText(PropertyFactory.getString("in_abt_email"));
        gridBagConstraints = this.buildConstraints(0, 5, 17);
        jPanel.add((Component)this.emailLabel, gridBagConstraints);
        this.helperLabel.setText(PropertyFactory.getString("in_abt_monkeys"));
        gridBagConstraints = this.buildConstraints(0, 6, 18);
        jPanel.add((Component)this.helperLabel, gridBagConstraints);
        this.version.setEditable(false);
        this.version.setText(PCGenProp.getVersionNumber());
        this.version.setBorder(null);
        this.version.setOpaque(false);
        gridBagConstraints = this.buildConstraints(1, 0, 17);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.version, gridBagConstraints);
        this.releaseDate.setEditable(false);
        this.releaseDate.setText(PCGenProp.getReleaseDate());
        this.releaseDate.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.releaseDate.setOpaque(false);
        gridBagConstraints = this.buildConstraints(1, 1, 17);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.releaseDate, gridBagConstraints);
        this.javaVersion.setEditable(false);
        this.javaVersion.setText(System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        this.javaVersion.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.javaVersion.setOpaque(false);
        gridBagConstraints = this.buildConstraints(1, 2, 17);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.javaVersion, gridBagConstraints);
        this.projectLead.setEditable(false);
        this.projectLead.setText(PCGenProp.getHeadCodeMonkey());
        this.projectLead.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.projectLead.setOpaque(false);
        gridBagConstraints = this.buildConstraints(1, 3, 17);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.projectLead, gridBagConstraints);
        this.wwwSite.setText(PCGenProp.getWWWHome());
        this.wwwSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserLauncher.openURL(MainAbout.this.wwwSite.getText());
                }
                catch (IOException iOException) {
                    Logging.errorPrint(PropertyFactory.getString("in_abt_browser_err"), iOException);
                }
            }
        });
        gridBagConstraints = this.buildConstraints(1, 4, 17);
        jPanel.add((Component)this.wwwSite, gridBagConstraints);
        this.mailingList.setText(PCGenProp.getMailingList());
        this.mailingList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserLauncher.openURL(MainAbout.this.mailingList.getText());
                }
                catch (IOException iOException) {
                    Logging.errorPrint(PropertyFactory.getString("in_abt_browser_err"), iOException);
                }
            }
        });
        gridBagConstraints = this.buildConstraints(1, 5, 17);
        jPanel.add((Component)this.mailingList, gridBagConstraints);
        gridBagConstraints = this.buildConstraints(1, 6, 17);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.monkeyTabPane, gridBagConstraints);
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_code_mky"), this.buildMonkeyList(PCGenProp.getCodeMonkeys()));
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_list_mky"), this.buildMonkeyList(PCGenProp.getListMonkeys()));
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_test_mky"), this.buildMonkeyList(PCGenProp.getTestMonkeys()));
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_eng_mky"), this.buildMonkeyList(PCGenProp.getEngineeringMonkeys()));
        this.monkeyTabPane.setToolTipTextAt(2, PropertyFactory.getString("in_abt_easter_egg"));
        return jPanel;
    }

    private JScrollPane buildMonkeyList(String string) {
        JTextArea jTextArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane();
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setText(string);
        jScrollPane.setViewportView(jTextArea);
        jTextArea.setCaretPosition(0);
        return jScrollPane;
    }

    private GridBagConstraints buildConstraints(int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = n3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        return gridBagConstraints;
    }

    private JPanel buildIncludesPanel() {
        JPanel jPanel = new JPanel();
        this.otherLibrariesField = new JTextArea();
        jPanel.setLayout(new BorderLayout());
        String string = PropertyFactory.getString("in_abt_lib_apache");
        string = string + PropertyFactory.getString("in_abt_lib_jdom");
        string = string + PropertyFactory.getString("in_abt_lib_l2f");
        this.otherLibrariesField.setText(string);
        this.otherLibrariesField.setWrapStyleWord(true);
        this.otherLibrariesField.setLineWrap(true);
        this.otherLibrariesField.setEditable(false);
        this.otherLibrariesField.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add((Component)this.otherLibrariesField, "Center");
        return jPanel;
    }

    private JPanel buildAwardsPanel() {
        JTextArea jTextArea;
        JLabel jLabel;
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBoxLayout(2, 2));
        jPanel2.setBackground(Color.WHITE);
        URL uRL = this.getClass().getResource("/pcgen/gui/resource/gold200x200-2005.gif");
        if (uRL != null) {
            jLabel = new JLabel(new ImageIcon(uRL));
            jPanel2.add(jLabel);
            jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setText(PropertyFactory.getString("in_abt_awards_2005_ennie"));
            jPanel2.add(jTextArea);
        }
        if ((uRL = this.getClass().getResource("/pcgen/gui/resource/bronze200x200-2003.gif")) != null) {
            jLabel = new JLabel(new ImageIcon(uRL));
            jPanel2.add(jLabel);
            jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setText(PropertyFactory.getString("in_abt_awards_2003_ennie"));
            jPanel2.add(jTextArea);
        }
        jScrollPane.setViewportView(jPanel2);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel buildSponsorsPanel() {
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Sponsor Info");
        titledBorder.setTitleJustification(2);
        JLabelPane jLabelPane = new JLabelPane();
        JScrollPane jScrollPane = new JScrollPane(jLabelPane);
        jScrollPane.setBorder(titledBorder);
        JPanel jPanel = new JPanel(new BorderLayout());
        jLabelPane.setBackground(jPanel.getBackground());
        jPanel.add((Component)jScrollPane, "Center");
        List<Map<String, String>> list = Globals.getSponsors();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><b>Our Sponsors</b><br>");
        for (int i = 0; i < list.size(); ++i) {
            Map<String, String> map = list.get(i);
            if (map.get("SPONSOR").equals("PCGEN")) continue;
            stringBuffer.append("<img src='").append(SponsorLoader.getConvertedSponsorPath(map.get("IMAGEBANNER"))).append("'><br>");
        }
        stringBuffer.append("</html>");
        jLabelPane.setText(stringBuffer.toString());
        return jPanel;
    }

    private JPanel buildLicensePanel() {
        JPanel jPanel = new JPanel();
        this.license = new JScrollPane();
        this.LGPLArea = new JTextArea();
        jPanel.setLayout(new BorderLayout());
        this.LGPLArea.setEditable(false);
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("LICENSE");
        if (inputStream != null) {
            try {
                this.LGPLArea.read(new InputStreamReader(inputStream), "LICENSE");
            }
            catch (IOException iOException) {
                this.LGPLArea.setText(PropertyFactory.getString("in_abt_license_read_err1"));
            }
        } else {
            this.LGPLArea.setText(PropertyFactory.getString("in_abt_license_read_err2"));
        }
        this.license.setViewportView(this.LGPLArea);
        jPanel.add((Component)this.license, "Center");
        return jPanel;
    }
}

