/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class LoggingLevelMenu
extends JMenu {
    static final long serialVersionUID = -6751569845505079621L;
    private ButtonGroup levelGroup = null;
    private CheckBoxListener checkBoxHandler = new CheckBoxListener();
    private JRadioButtonMenuItem[] levelMenuItems = null;
    private List<Level> levelList = new ArrayList<Level>();

    LoggingLevelMenu() {
        try {
            this.buildMenu();
            this.setText(PropertyFactory.getString("in_mnuLoggingLevel"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_mnuLoggingLevel"));
            Utility.setDescription(this, PropertyFactory.getString("in_mnuLoggingLevelTip"));
            this.updateMenu();
        }
        catch (Exception exception) {
            Logging.errorPrint("Exception while initing the form", exception);
        }
    }

    private void buildMenu() {
        int n;
        this.levelList = Logging.getLoggingLevels();
        int n2 = this.levelList.size();
        if (this.levelList.size() == 0) {
            return;
        }
        this.levelMenuItems = new JRadioButtonMenuItem[n2];
        this.levelGroup = new ButtonGroup();
        for (n = 0; n < n2; ++n) {
            LoggingLevelMenu loggingLevelMenu = this;
            Level level = this.levelList.get(n);
            this.levelMenuItems[n] = new JRadioButtonMenuItem(PropertyFactory.getString("in_loglvl" + level.getName()), false);
            this.levelGroup.add(loggingLevelMenu.add(this.levelMenuItems[n]));
            Utility.setDescription(this.levelMenuItems[n], PropertyFactory.getString("in_loglvl" + level.getName() + "Tip"));
            this.levelMenuItems[n].addActionListener(this.checkBoxHandler);
            this.add(this.levelMenuItems[n]);
        }
        for (n = 0; n < this.levelMenuItems.length; ++n) {
            Utility.setTextAndMnemonic(this.levelMenuItems[n], this.levelMenuItems[n].getText());
        }
    }

    public void updateMenu() {
        if (this.levelMenuItems != null) {
            for (int i = 0; i < this.levelMenuItems.length; ++i) {
                if (Logging.getCurrentLoggingLevel() != this.levelList.get(i)) continue;
                this.levelMenuItems[i].setSelected(true);
                break;
            }
        }
    }

    private final class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == null) {
                return;
            }
            for (int i = 0; i < LoggingLevelMenu.this.levelMenuItems.length; ++i) {
                if (object != LoggingLevelMenu.this.levelMenuItems[i]) continue;
                Logging.setCurrentLoggingLevel((Level)LoggingLevelMenu.this.levelList.get(i));
            }
        }
    }
}

