/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.utils;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import pcgen.core.Equipment;
import pcgen.gui.PCGenProp;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoreUtility {
    public static Comparator<Equipment> equipmentComparator = new Comparator<Equipment>(){

        private int compareInts(int n, int n2) {
            if (n > n2) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compare(Equipment equipment, Equipment equipment2) {
            int n = equipment.getOutputIndex();
            int n2 = equipment2.getOutputIndex();
            int n3 = this.compareInts(n = n == 0 ? 999 : n, n2 = n2 == 0 ? 999 : n2);
            if (n3 != 0) {
                return n3;
            }
            int n4 = this.compareInts(equipment.getOutputSubindex(), equipment2.getOutputSubindex());
            if (n4 != 0) {
                return n4;
            }
            int n5 = equipment.getName().compareToIgnoreCase(equipment2.getName());
            if (n5 != 0) {
                return n5;
            }
            return equipment.getParentName().compareToIgnoreCase(equipment2.getParentName());
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }

        public int hashCode() {
            return 0;
        }
    };

    private CoreUtility() {
    }

    public static boolean isNetURL(URL uRL) {
        return "http".equalsIgnoreCase(uRL.getProtocol()) || "ftp".equalsIgnoreCase(uRL.getProtocol());
    }

    public static String capitalizeFirstLetter(String string) {
        boolean bl = true;
        char[] cArray = string.toLowerCase().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                bl = true;
                continue;
            }
            if (bl && Character.isLowerCase(cArray[i])) {
                cArray[i] = Character.toUpperCase(cArray[i]);
            }
            bl = false;
        }
        return new String(cArray);
    }

    public static boolean compareDouble(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static boolean doublesEqual(double d, double d2) {
        return CoreUtility.compareDouble(d, d2, 1.0E-4);
    }

    public static String fixFilenamePath(String string) {
        return string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static int innerMostStringEnd(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                if (++n3 <= n2) continue;
                n2 = n3;
                continue;
            }
            if (string.charAt(i) != ')') continue;
            if (n3 == n2) {
                n = i;
            }
            --n3;
        }
        return n;
    }

    public static int innerMostStringStart(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                if (++n3 < n2) continue;
                n2 = n3;
                n = i;
                continue;
            }
            if (string.charAt(i) != ')') continue;
            --n3;
        }
        return n;
    }

    public static String ordinal(int n) {
        String string = "th";
        if (n < 4 || n > 20) {
            switch (n % 10) {
                case 1: {
                    string = "st";
                    break;
                }
                case 2: {
                    string = "nd";
                    break;
                }
                case 3: {
                    string = "rd";
                    break;
                }
            }
        }
        return Integer.toString(n) + string;
    }

    public static List<String> split(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Pattern.quote(String.valueOf(c));
        if (string.trim().length() == 0) {
            return arrayList;
        }
        for (String string3 : Arrays.asList(string.split(string2))) {
            arrayList.add(string3.trim());
        }
        return arrayList;
    }

    public static String unEscapeColons2(String string) {
        return string.replaceAll(Pattern.quote("&#59;"), ":");
    }

    public static List<Equipment> cloneEquipmentInList(Iterable<Equipment> iterable) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (Equipment equipment : iterable) {
            arrayList.add(equipment.clone());
        }
        return arrayList;
    }

    public static List<Equipment> mergeEquipmentList(List<Equipment> list, int n) {
        Collections.sort(list, equipmentComparator);
        if (n == 1) {
            return list;
        }
        List<Equipment> list2 = CoreUtility.cloneEquipmentInList(list);
        int n2 = list2.size();
        for (int i = 0; i < n2; ++i) {
            Equipment equipment = list2.get(i);
            double d = equipment.qty();
            for (int j = i + 1; j < n2; ++j) {
                Equipment equipment2 = list2.get(j);
                if (equipment.isContainer() || equipment.isType("TEMPORARY") || equipment2.isType("TEMPORARY") || !equipment.getName().equals(equipment2.getName()) || n != 0 && (n != 2 || equipment.getLocation() != equipment2.getLocation() || !equipment.getParentName().equals(equipment2.getParentName()))) continue;
                list2.remove(equipment2);
                d += equipment2.qty();
                --n2;
            }
            equipment.setQty(d);
        }
        return list2;
    }

    public static int compareVersions(int[] nArray, int[] nArray2) {
        if (nArray[0] != nArray2[0]) {
            return new Integer(nArray[0]).compareTo(nArray2[0]);
        }
        if (nArray[1] != nArray2[1]) {
            return new Integer(nArray[1]).compareTo(nArray2[1]);
        }
        return new Integer(nArray[2]).compareTo(nArray2[2]);
    }

    public static int compareVersions(String string, String string2) {
        if (!string.equals(string2)) {
            return CoreUtility.compareVersions(CoreUtility.convertVersionToNumber(string), CoreUtility.convertVersionToNumber(string2));
        }
        return 0;
    }

    public static boolean isPriorToCurrent(String string) {
        return CoreUtility.compareVersions(string, PCGenProp.getVersionNumber()) <= 0;
    }

    public static int[] convertVersionToNumber(String string) {
        int[] nArray = new int[]{0, 0, 0};
        String[] stringArray = string.split(" |\\.|\\-", 4);
        for (int i = 0; i < 3 && i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (i == 2 && stringArray[i].startsWith("RC")) continue;
                Logging.errorPrint("Invalid PCGen version: " + string);
            }
        }
        return nArray;
    }

    public static boolean isCurrMinorVer(String string) {
        int[] nArray;
        if (string.equals(PCGenProp.getVersionNumber())) {
            return true;
        }
        int[] nArray2 = CoreUtility.convertVersionToNumber(string);
        return nArray2[0] == (nArray = CoreUtility.convertVersionToNumber(PCGenProp.getVersionNumber()))[0] && nArray2[1] == nArray[1];
    }
}

