/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.math.BigDecimal;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.term.BaseEQTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class EQWeightTermEvaluator
extends BaseEQTermEvaluator
implements TermEvaluator {
    public EQWeightTermEvaluator(String string) {
        this.originalText = string;
    }

    public Float resolve(Equipment equipment, boolean bl, PlayerCharacter playerCharacter) {
        return this.convertToFloat(this.originalText, this.evaluate(equipment, bl, playerCharacter));
    }

    public String evaluate(Equipment equipment, boolean bl, PlayerCharacter playerCharacter) {
        if (equipment.isCalculatingCost() && equipment.isWeightAlreadyUsed()) {
            return "0";
        }
        BigDecimal bigDecimal = equipment.getWeightInPounds();
        if (equipment.isCalculatingCost() && equipment.isAmmunition()) {
            Float f = Float.valueOf(bigDecimal.floatValue());
            f = Float.valueOf(f.floatValue() / (float)equipment.getSafe(IntegerKey.BASE_QUANTITY));
            equipment.setWeightAlreadyUsed(true);
            return String.valueOf(f);
        }
        equipment.setWeightAlreadyUsed(true);
        return String.valueOf(bigDecimal);
    }

    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

