/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.spell;

import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.list.SpellList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.analysis.SpellPoint;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

public final class Spell
extends PObject {
    public static final CDOMReference<SpellList> SPELLS;
    static boolean hasSpellPointCost;

    public String getCastingTime() {
        return StringUtil.join(this.getListFor(ListKey.CASTTIME), ", ");
    }

    public String getComponentList() {
        return StringUtil.join(this.getListFor(ListKey.COMPONENTS), ", ");
    }

    public String getDuration() {
        return StringUtil.join(this.getListFor(ListKey.DURATION), ", ");
    }

    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append("\t");
        stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(Globals.getContext().unparse(this), "\t"));
        if (Spell.hasSpellPointCost()) {
            stringBuffer.append(SpellPoint.getSpellPointCostActual(this));
        }
        stringBuffer.append(super.getPCCText(false));
        return stringBuffer.toString();
    }

    public String getRange() {
        return StringUtil.join(this.getListFor(ListKey.RANGE), ", ");
    }

    public String getSaveInfo() {
        return StringUtil.join(this.getListFor(ListKey.SAVE_INFO), ", ");
    }

    public String getSchool() {
        return StringUtil.join(this.getListFor(ListKey.SPELL_SCHOOL), ", ");
    }

    public String getSpellResistance() {
        return StringUtil.join(this.getListFor(ListKey.SPELL_RESISTANCE), ", ");
    }

    public String getSubschool() {
        return StringUtil.join(this.getListFor(ListKey.SPELL_SUBSCHOOL), ", ");
    }

    public Spell clone() {
        Spell spell = null;
        try {
            spell = (Spell)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return spell;
    }

    public String descriptor() {
        return StringUtil.join(this.getListFor(ListKey.SPELL_DESCRIPTOR), ", ");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Spell)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Spell spell = (Spell)object;
        if (this.getKeyName().equals(spell.getKeyName())) {
            return this.isCDOMEqual(spell);
        }
        return false;
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    public static boolean hasSpellPointCost() {
        return hasSpellPointCost;
    }

    public boolean isAllowed(String string) {
        for (String string2 : this.getSafeListFor(ListKey.ITEM)) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        if ("potion".equalsIgnoreCase(string)) {
            return false;
        }
        for (String string2 : this.getSafeListFor(ListKey.PROHIBITED_ITEM)) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    static {
        SpellList spellList = new SpellList();
        spellList.setName("*Spells");
        SPELLS = CDOMDirectSingleRef.getRef(spellList);
        hasSpellPointCost = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Component {
        VERBAL("V", "Spell.Components.Verbal"),
        SOMATIC("S", "Spell.Components.Somatic"),
        MATERIAL("M", "Spell.Components.Material"),
        DIVINEFOCUS("DF", "Spell.Components.DivineFocus"),
        FOCUS("F", "Spell.Components.Focus"),
        EXPERIENCE("XP", "Spell.Components.Experience"),
        OTHER("See text", "Spell.Components.SeeText");

        private String theKey;
        private String theName;

        private Component(String string2, String string3) {
            this.theKey = string2;
            this.theName = string3;
        }

        public String getKey() {
            return this.theKey;
        }

        public static Component getComponentFromKey(String string) {
            for (Component component : Component.values()) {
                if (!component.getKey().equalsIgnoreCase(string)) continue;
                return component;
            }
            return OTHER;
        }

        public String toString() {
            return this.theName;
        }
    }
}

