/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.party;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.party.PCLoader;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.PCGIOHandler;
import pcgen.util.FileHelper;
import pcgen.util.Logging;

public class Party {
    private File partyFile;
    private List<File> characterFiles = new ArrayList<File>();

    private Party() {
    }

    private Party(File file) {
        this.partyFile = file;
    }

    public static Party makePartyFromFile(File file) {
        return new Party(file);
    }

    public static Party makeSingleCharacterParty(File file) {
        Party party = new Party();
        party.characterFiles.add(file);
        return party;
    }

    public String getDisplayName() {
        String string = this.partyFile.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void addAllOpenCharacters() {
        for (PlayerCharacter playerCharacter : Globals.getPCList()) {
            this.characterFiles.add(new File(playerCharacter.getFileName()));
        }
    }

    public PlayerCharacter load(PCLoader pCLoader) {
        PlayerCharacter playerCharacter;
        block7: {
            playerCharacter = null;
            try {
                if (this.partyFile == null) {
                    return this.loadCharacterFiles();
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.partyFile), "UTF-8"));
                bufferedReader.readLine();
                String string = bufferedReader.readLine();
                bufferedReader.close();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    PlayerCharacter playerCharacter2;
                    String string2 = stringTokenizer.nextToken();
                    File file = this.buildCharacterFile(string2);
                    if (!file.exists()) {
                        file = new File(SettingsHandler.getPcgPath(), string2);
                    }
                    if (file.exists()) {
                        this.characterFiles.add(file);
                        playerCharacter2 = pCLoader != null ? pCLoader.loadPCFromFile(file) : Party.loadPCFromFile(file);
                    } else {
                        Logging.errorPrint("Character file does not exist: " + string2);
                        playerCharacter2 = null;
                    }
                    if (playerCharacter2 == null) continue;
                    playerCharacter = playerCharacter2;
                }
            }
            catch (Exception exception) {
                Logging.errorPrint("Error loading party partyFile.", exception);
                if (!Globals.getUseGUI()) break block7;
                ShowMessageDelegate.showMessageDialog("Could not load party partyFile.", "PCGen", MessageType.ERROR);
            }
        }
        return playerCharacter;
    }

    public void save() throws IOException {
        if (this.partyFile == null) {
            throw new FileNotFoundException("The file to save this party to is null");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.partyFile), "UTF-8"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
        bufferedWriter.write("VERSION:");
        bufferedWriter.write(resourceBundle.getString("VersionNumber"));
        bufferedWriter.newLine();
        for (File file : this.characterFiles) {
            bufferedWriter.write(FileHelper.findRelativePath(this.partyFile, file) + ",");
        }
        bufferedWriter.newLine();
        bufferedWriter.close();
    }

    private File buildCharacterFile(String string) {
        return new File(this.partyFile.getParentFile().getAbsolutePath() + string);
    }

    private PlayerCharacter loadCharacterFiles() {
        PlayerCharacter playerCharacter = null;
        for (File file : this.characterFiles) {
            playerCharacter = Party.loadPCFromFile(file);
        }
        return playerCharacter;
    }

    private static PlayerCharacter loadPCFromFile(File file) {
        PlayerCharacter playerCharacter = new PlayerCharacter();
        PCGIOHandler pCGIOHandler = new PCGIOHandler();
        pCGIOHandler.read(playerCharacter, file.getAbsolutePath());
        if (Globals.getUseGUI()) {
            for (String string : pCGIOHandler.getErrors()) {
                ShowMessageDelegate.showMessageDialog("Error: " + string, "PCGen", MessageType.ERROR);
            }
            for (String string : pCGIOHandler.getWarnings()) {
                ShowMessageDelegate.showMessageDialog("Warning: " + string, "PCGen", MessageType.ERROR);
            }
        } else {
            for (String string : pCGIOHandler.getMessages()) {
                Logging.errorPrint(string);
            }
        }
        if (pCGIOHandler.getErrors().size() <= 0) {
            playerCharacter.setFileName(file.getAbsolutePath());
            Globals.getPCList().add(playerCharacter);
            Globals.setCurrentPC(playerCharacter);
            return playerCharacter;
        }
        return null;
    }
}

