/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitKit
extends BaseKit {
    private List<CDOMSingleRef<Kit>> availableKits = new ArrayList<CDOMSingleRef<Kit>>();
    private transient Map<Kit, List<BaseKit>> appliedKits = new HashMap<Kit, List<BaseKit>>();

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (Map.Entry<Kit, List<BaseKit>> entry : this.appliedKits.entrySet()) {
            entry.getKey().processKit(playerCharacter, entry.getValue());
        }
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        for (CDOMSingleRef<Kit> cDOMSingleRef : this.availableKits) {
            Kit kit2 = cDOMSingleRef.resolvesTo();
            ArrayList<BaseKit> arrayList = new ArrayList<BaseKit>();
            kit2.testApplyKit(playerCharacter, arrayList, list);
            this.appliedKits.put(kit2, arrayList);
        }
        return true;
    }

    @Override
    public String getObjectName() {
        return "Kit";
    }

    public String toString() {
        return ReferenceUtilities.joinLstFormat(this.availableKits, "|");
    }

    public void addKit(CDOMSingleRef<Kit> cDOMSingleRef) {
        this.availableKits.add(cDOMSingleRef);
    }

    public List<CDOMSingleRef<Kit>> getKits() {
        return this.availableKits;
    }
}

