/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.ParsingSeparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bonus {
    static final int BONUS_UNDEFINED = -1;
    private static int bonusTagMapNum = 0;
    private static final HashMap<String, BonusMapEntry> BONUS_TAG_MAP = new HashMap();

    private Bonus() {
    }

    public static int getBonusTypeFromName(String string) {
        BonusMapEntry bonusMapEntry = BONUS_TAG_MAP.get(string);
        if (bonusMapEntry == null) {
            int n = string.indexOf(61);
            if (n >= 0) {
                bonusMapEntry = BONUS_TAG_MAP.get(string.substring(0, n + 1));
            }
            if (bonusMapEntry == null) {
                return -1;
            }
        }
        return bonusMapEntry.getBonusType();
    }

    public static String getBonusNameFromType(int n) {
        for (String string : BONUS_TAG_MAP.keySet()) {
            BonusMapEntry bonusMapEntry = BONUS_TAG_MAP.get(string);
            if (bonusMapEntry.getBonusType() != n) continue;
            return string;
        }
        return "";
    }

    public static List<BonusObj> sortBonusList(List<BonusObj> list) {
        BonusObj bonusObj;
        int n;
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj2 : list) {
            int n2 = 0;
            for (n = 0; n < arrayList.size(); ++n) {
                bonusObj = (BonusObj)arrayList.get(n);
                if (!bonusObj.getDependsOn(bonusObj2.getBonusInfo())) continue;
                n2 = n;
            }
            arrayList.add(n2, bonusObj2);
        }
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            BonusObj bonusObj3 = (BonusObj)arrayList.get(n4);
            if (bonusObj3.getDependsOn("JEPFORMULA")) {
                arrayList.remove(n4);
                arrayList.add(bonusObj3);
                --n3;
                continue;
            }
            ++n4;
        }
        list = arrayList;
        ArrayList<BonusObj> arrayList2 = new ArrayList<BonusObj>();
        int n5 = list.size();
        for (n = 0; n < n5; ++n) {
            bonusObj = list.get(n);
            if (bonusObj.isValueStatic()) {
                arrayList2.add(0, bonusObj);
                continue;
            }
            arrayList2.add(bonusObj);
        }
        return arrayList2;
    }

    public static BonusObj newBonus(String string) {
        int n = -1;
        ParsingSeparator parsingSeparator = new ParsingSeparator(string, '|');
        if (string.indexOf("|") == string.lastIndexOf("|") && string.indexOf(37) < 0) {
            Logging.errorPrint("Illegal bonus format: " + string);
            return null;
        }
        String string2 = parsingSeparator.next();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string2 = n >= 0 ? parsingSeparator.next().toUpperCase() : string2.toUpperCase();
        int n2 = -1;
        BonusMapEntry bonusMapEntry = BONUS_TAG_MAP.get(string2);
        if (bonusMapEntry == null) {
            n2 = string2.indexOf(61);
            if (n2 >= 0) {
                bonusMapEntry = BONUS_TAG_MAP.get(string2.substring(0, n2 + 1));
            }
            if (bonusMapEntry == null) {
                Logging.errorPrint("Unrecognized bonus: " + string);
                return null;
            }
        }
        int n3 = bonusMapEntry.getBonusType();
        String string3 = parsingSeparator.next().toUpperCase();
        String string4 = "0";
        if (parsingSeparator.hasNext()) {
            string4 = parsingSeparator.next();
        }
        if (string4.startsWith("PRE") || string4.startsWith("!PRE")) {
            Logging.errorPrint("Invalid BONUS has no value: " + string);
            return null;
        }
        string4 = string4.toUpperCase();
        BonusObj bonusObj = null;
        try {
            bonusObj = (BonusObj)bonusMapEntry.getBonusClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bonusObj != null) {
            int n4;
            Object object;
            Object object2;
            bonusObj.putOriginalString(string);
            bonusObj.setBonusName(string2);
            bonusObj.setTypeOfBonus(n3);
            bonusObj.setValue(string4);
            while (parsingSeparator.hasNext()) {
                boolean bl;
                object2 = parsingSeparator.next().toUpperCase();
                if (PreParserFactory.isPreReqString((String)object2)) {
                    try {
                        object = PreParserFactory.getInstance();
                        bonusObj.addPrerequisite(((PreParserFactory)object).parse((String)object2));
                    }
                    catch (PersistenceLayerException persistenceLayerException) {
                        Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                    }
                    continue;
                }
                if (!((String)object2).startsWith("TYPE=") && !((String)object2).startsWith("TYPE.")) continue;
                object = ((String)object2).substring(5);
                n4 = ((String)object).indexOf(46);
                if (n4 != -1) {
                    String string5 = ((String)object).substring(n4 + 1);
                    if (string5.startsWith("REPLACE")) {
                        bonusObj.setStackingFlag(BonusObj.StackType.REPLACE);
                    } else if (string5.startsWith("STACK")) {
                        bonusObj.setStackingFlag(BonusObj.StackType.STACK);
                    }
                }
                if (bl = bonusObj.addType((String)object)) continue;
                Logging.debugPrint(new StringBuffer().append("Could not add type ").append(((String)object2).substring(5)).append(" to bonusType ").append(n3).append(" in Bonus.newBonus").toString());
            }
            if (n2 >= 0) {
                bonusObj.setVariable(string2.substring(n2 + 1));
            }
            object2 = new StringTokenizer(string3, ",");
            LstUtils.deprecationCheck(bonusObj, string2, string);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                n4 = bonusObj.parseToken((String)object) ? 1 : 0;
                if (n4 != 0) continue;
                Logging.debugPrint(new StringBuffer().append("Could not parse token ").append((String)object).append(" from bonusInfo ").append(string3).append(" in BonusObj.newBonus.").toString());
            }
            if (n >= 0) {
                bonusObj.setPCLevel(n);
            }
        } else {
            Logging.errorPrint("Could not create bonusObj for:" + string);
        }
        return bonusObj;
    }

    public static boolean addBonusClass(Class clazz, String string) throws InstantiationException, IllegalAccessException {
        BonusObj bonusObj;
        String[] stringArray;
        boolean bl = false;
        if (BonusObj.class.isAssignableFrom(clazz) && (stringArray = (bonusObj = (BonusObj)clazz.newInstance()).getBonusesHandled()) != null) {
            bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                BONUS_TAG_MAP.put(stringArray[i], new BonusMapEntry(string, bonusTagMapNum++, clazz));
            }
        }
        return bl;
    }

    private static class BonusMapEntry {
        private int bonusType = -1;
        private String bonusObjectName = "";
        private Class bonusClass;

        public BonusMapEntry(String string, int n, Class clazz) {
            this.bonusObjectName = string;
            this.bonusType = n;
            this.bonusClass = clazz;
        }

        public final String getBonusObjectName() {
            return this.bonusObjectName;
        }

        public final int getBonusType() {
            return this.bonusType;
        }

        public final Class getBonusClass() {
            return this.bonusClass;
        }

        public String toString() {
            return this.bonusObjectName + ':' + Integer.toString(this.bonusType);
        }
    }
}

