/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SubstitutionClass;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.persistence.lst.utils.DeferredLine;
import pcgen.util.Logging;

public class SubstitutionLevelSupport {
    public static boolean levelArrayQualifies(int n, PlayerCharacter playerCharacter, String string, CampaignSourceEntry campaignSourceEntry) {
        PCClassLoader pCClassLoader = new PCClassLoader();
        PCClass pCClass = new PCClass();
        try {
            pCClassLoader.parseLine(Globals.getContext(), pCClass, string, campaignSourceEntry);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Unable to parse line from levelArray: " + string);
        }
        return pCClass.getClassLevel(n).qualifies(playerCharacter);
    }

    public static void applyLevelArrayModsToLevel(SubstitutionClass substitutionClass, PCClass pCClass, int n, PlayerCharacter playerCharacter) {
        List<DeferredLine> list = substitutionClass.getListFor(ListKey.SUB_CLASS_LEVEL);
        if (list == null) {
            return;
        }
        ArrayList<DeferredLine> arrayList = new ArrayList<DeferredLine>();
        for (DeferredLine deferredLine : list) {
            String string = deferredLine.lstLine;
            int n2 = Integer.parseInt(string.substring(0, string.indexOf("\t")));
            if (n != n2 || !SubstitutionLevelSupport.levelArrayQualifies(n, playerCharacter, string, deferredLine.source)) continue;
            arrayList.add(deferredLine);
        }
        if (!arrayList.isEmpty()) {
            pCClass.stealClassLevel(substitutionClass, n);
        }
    }

    public static boolean qualifiesForSubstitutionLevel(SubstitutionClass substitutionClass, PlayerCharacter playerCharacter, int n) {
        List<DeferredLine> list = substitutionClass.getListFor(ListKey.SUB_CLASS_LEVEL);
        if (list == null) {
            return false;
        }
        for (DeferredLine deferredLine : list) {
            String string = deferredLine.lstLine;
            int n2 = Integer.parseInt(string.substring(0, string.indexOf("\t")));
            if (n != n2 || SubstitutionLevelSupport.levelArrayQualifies(n, playerCharacter, string, deferredLine.source)) continue;
            return false;
        }
        return true;
    }
}

