/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SkillLanguage {
    public static boolean chooseLanguageForSkill(PlayerCharacter playerCharacter) {
        Skill skill = null;
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        for (Skill skill2 : arrayList) {
            if (!SkillLanguage.isLanguage(skill2)) continue;
            skill = skill2;
        }
        return SkillLanguage.chooseLanguageForSkill(playerCharacter, skill);
    }

    public static boolean isLanguage(Skill skill) {
        return skill.getSafe(StringKey.CHOICE_STRING).toLowerCase().indexOf("language") >= 0;
    }

    public static boolean chooseLanguageForSkill(PlayerCharacter playerCharacter, Skill skill) {
        if (playerCharacter != null) {
            if (skill == null) {
                ShowMessageDelegate.showMessageDialog("You do not have enough ranks in Speak Language", "PCGen", MessageType.ERROR);
                return false;
            }
            int n = SkillRankControl.getTotalRank(playerCharacter, skill).intValue();
            ArrayList<Language> arrayList = new ArrayList<Language>();
            ArrayList<Language> arrayList2 = new ArrayList<Language>();
            ArrayList<Language> arrayList3 = new ArrayList<Language>();
            SkillLanguage.buildLanguageListsForSkill(playerCharacter, skill, arrayList, arrayList2, arrayList3);
            Globals.sortChooserLists(arrayList2, arrayList);
            ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
            chooserInterface.setVisible(false);
            chooserInterface.setAvailableList(arrayList2);
            chooserInterface.setSelectedList(arrayList);
            chooserInterface.setTotalChoicesAvail(n);
            chooserInterface.setPoolFlag(false);
            chooserInterface.setVisible(true);
            playerCharacter.clearLanguages();
            playerCharacter.addLanguages(arrayList);
            playerCharacter.addLanguages(arrayList3);
            playerCharacter.removeAllAssociations(skill);
            Iterator iterator = chooserInterface.getSelectedList().iterator();
            while (iterator.hasNext()) {
                playerCharacter.addAssociation((CDOMObject)skill, ((Language)iterator.next()).getKeyName());
            }
            playerCharacter.setDirty(true);
            return true;
        }
        return false;
    }

    public static void buildLanguageListsForSkill(PlayerCharacter playerCharacter, Skill skill, List<Language> list, List<Language> list2, List<Language> list3) {
        String[][] stringArray;
        String[] stringArray2 = null;
        if (skill.getSafe(StringKey.CHOICE_STRING).toLowerCase().indexOf("language(") >= 0 && (stringArray = skill.getSafe(StringKey.CHOICE_STRING).split("[\\(\\)]")).length >= 2) {
            stringArray2 = stringArray[1];
        }
        if (stringArray2 == null) {
            stringArray = null;
        } else {
            String[] stringArray3 = stringArray2.split(",");
            stringArray = new String[stringArray3.length][];
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray[i] = ((String)stringArray3[i]).split("\\.");
            }
        }
        for (String string : playerCharacter.getAssociationList(skill)) {
            String[][] stringArray4 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Language.class, string);
            if (stringArray4 == null) continue;
            if (stringArray == null) {
                list.add((Language)stringArray4);
                continue;
            }
            String[][] stringArray5 = stringArray;
            int n = stringArray5.length;
            block2: for (int i = 0; i < n; ++i) {
                String[] stringArray6;
                String[] stringArray7 = stringArray6 = stringArray5[i];
                int n2 = stringArray7.length;
                for (int j = 0; j < n2; ++j) {
                    String string2 = stringArray7[j];
                    if (!stringArray4.isType(string2)) continue block2;
                }
                list.add((Language)stringArray4);
            }
        }
        for (Language language : Globals.getContext().ref.getConstructedCDOMObjects(Language.class)) {
            if (!PrereqHandler.passesAll(language.getPrerequisiteList(), playerCharacter, language)) continue;
            if (stringArray == null) {
                list2.add(language);
                continue;
            }
            block5: for (String[] stringArray8 : stringArray) {
                for (String string : stringArray8) {
                    if (!language.isType(string)) continue block5;
                }
                list2.add(language);
            }
        }
        for (Language language : playerCharacter.getAutoLanguages()) {
            list2.remove(language);
            list3.add(language);
        }
        for (Language language : playerCharacter.getLanguagesList()) {
            if (list.contains(language)) continue;
            if (stringArray2 == null || language.isType((String)stringArray2)) {
                list2.remove(language);
            }
            list3.add(language);
        }
    }

    public static List<Language> getLanguageList(List<String> list, Skill skill, PlayerCharacter playerCharacter, int n) {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        ArrayList<Language> arrayList2 = new ArrayList<Language>();
        ArrayList<Language> arrayList3 = new ArrayList<Language>();
        SkillLanguage.buildLanguageListsForSkill(playerCharacter, skill, arrayList, arrayList2, arrayList3);
        ArrayList<Language> arrayList4 = new ArrayList<Language>(n);
        for (String string : list) {
            Language language = SkillLanguage.findLanguageInListByKey(arrayList2, string);
            if (language == null) continue;
            arrayList4.add(language);
            if (arrayList4.size() < n) continue;
            break;
        }
        return arrayList4;
    }

    private static Language findLanguageInListByKey(List<Language> list, String string) {
        for (Language language : list) {
            if (!string.equalsIgnoreCase(language.getKeyName())) continue;
            return language;
        }
        return null;
    }
}

