/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.character.CharacterSpell;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;

public class DomainApplication {
    public static void applyDomain(PlayerCharacter playerCharacter, Domain domain) {
        Object object3;
        String string = domain.getKeyName();
        CharacterDomain characterDomain = playerCharacter.getCharacterDomainForDomain(string);
        PCClass pCClass = null;
        if (characterDomain != null && characterDomain.isFromPCClass() && (pCClass = playerCharacter.getClassKeyed(characterDomain.getObjectName())) != null) {
            int n;
            for (n = 0; n < 10 && pCClass.getCastForLevel(n, playerCharacter) != 0; ++n) {
            }
            if (n > 0) {
                DomainApplication.addSpellsToClassForLevels(playerCharacter, domain, pCClass, 0, n - 1);
            }
            if (n > 1 && pCClass.getSafe(IntegerKey.KNOWN_SPELLS_FROM_SPECIALTY) == 0) {
                object3 = domain.get(ObjectKey.DOMAIN_SPELLLIST);
                List<Spell> object4 = Globals.getSpellsIn(-1, Collections.singletonList(object3), playerCharacter);
                for (Object object : object4) {
                    if (SpellLevel.getFirstLvlForKey((Spell)object, (CDOMList<Spell>)object3, playerCharacter) >= n) continue;
                    playerCharacter.setAssoc(pCClass, AssociationKey.DOMAIN_SPELL_COUNT, 1);
                    break;
                }
            }
        }
        Collection collection = domain.getSafeListMods(Spell.SPELLS);
        for (CDOMReference cDOMReference : collection) {
            Object object;
            Collection collection2 = cDOMReference.getContainedObjects();
            object = domain.getListAssociations(Spell.SPELLS, cDOMReference);
            Iterator<AssociatedPrereqObject> iterator = object.iterator();
            while (iterator.hasNext()) {
                AssociatedPrereqObject associatedPrereqObject = iterator.next();
                if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, domain)) continue;
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    String string2;
                    Spell spell = (Spell)iterator2.next();
                    List<CharacterSpell> list = playerCharacter.getCharacterSpells(pCClass, spell, string2 = associatedPrereqObject.getAssociation(AssociationKey.SPELLBOOK), -1);
                    if (!list.isEmpty()) continue;
                    Formula formula = associatedPrereqObject.getAssociation(AssociationKey.TIMES_PER_UNIT);
                    CharacterSpell characterSpell = new CharacterSpell(domain, spell);
                    int n = formula.resolve(playerCharacter, domain.getQualifiedKey()).intValue();
                    characterSpell.addInfo(1, n, string2);
                    playerCharacter.addAssoc(pCClass, AssociationListKey.CHARACTER_SPELLS, characterSpell);
                }
            }
        }
        object3 = domain.getSafe(StringKey.CHOICE_STRING);
        if (((String)object3).length() > 0 && !playerCharacter.isImporting() && !((String)object3).startsWith("FEAT|")) {
            ChooserUtilities.modChoices(domain, new ArrayList(), new ArrayList(), true, playerCharacter, true, null);
        }
        if (!playerCharacter.isImporting()) {
            domain.globalChecks(playerCharacter);
            domain.activateBonuses(playerCharacter);
        }
    }

    public static void addSpellsToClassForLevels(PlayerCharacter playerCharacter, Domain domain, PCClass pCClass, int n, int n2) {
        if (pCClass == null) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            List<Spell> list = Globals.getSpellsIn(i, Collections.singletonList(domain.get(ObjectKey.DOMAIN_SPELLLIST)), playerCharacter);
            for (Spell spell : list) {
                CharacterSpell characterSpell;
                List<CharacterSpell> list2 = playerCharacter.getCharacterSpells(pCClass, spell, Globals.getDefaultSpellBook(), i);
                boolean bl = true;
                Object object = list2.iterator();
                while (object.hasNext() && (bl = !(characterSpell = object.next()).getOwner().equals(domain))) {
                }
                if (!bl) continue;
                object = new CharacterSpell(domain, spell);
                ((CharacterSpell)object).addInfo(i, 1, Globals.getDefaultSpellBook());
                playerCharacter.addAssoc(pCClass, AssociationListKey.CHARACTER_SPELLS, object);
            }
        }
    }
}

