/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CachedVariable;
import pcgen.core.character.CharacterSpell;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;

public abstract class VariableProcessor {
    protected String jepIndent = "";
    protected PlayerCharacter pc;
    private int cachePaused;
    private int serial;
    private Map<String, CachedVariable<String>> sVariableCache = new HashMap<String, CachedVariable<String>>();
    private Map<String, CachedVariable<Float>> fVariableCache = new HashMap<String, CachedVariable<Float>>();

    protected Float convertToFloat(String string, String string2) {
        Float f = null;
        try {
            f = new Float(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Float f2 = null;
        if (f != null && !f.isNaN()) {
            f2 = f;
            Logging.debugPrint(this.jepIndent + "export variable for: '" + string + "' = " + f);
        }
        return f2;
    }

    public VariableProcessor(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    public Float getVariableValue(CharacterSpell characterSpell, String string, String string2, int n) {
        Float f = this.getJepOnlyVariableValue(characterSpell, string, string2, n);
        if (null == f) {
            f = this.processBrokenParser(characterSpell, string, string2, n);
            String string3 = this.makeCacheString(characterSpell == null ? null : characterSpell.getSpell(), string, string2, n);
            this.addCachedVariable(string3, f);
        }
        return f;
    }

    public Float getJepOnlyVariableValue(CharacterSpell characterSpell, String string, String string2, int n) {
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = this.makeCacheString(characterSpell == null ? null : characterSpell.getSpell(), string, string2, n);
            Float f = this.getCachedVariable(string3);
            if (f != null) {
                return f;
            }
            CachableResult cachableResult = this.processJepFormula(characterSpell, string, string2);
            if (cachableResult != null) {
                if (cachableResult.cachable) {
                    this.addCachedVariable(string3, cachableResult.result);
                }
                return cachableResult.result;
            }
            return null;
        }
    }

    private String makeCacheString(Spell spell, String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder(string).append("#").append(string2);
        if (spell != null) {
            stringBuilder.append(spell.getKeyName());
        }
        if (n > 0) {
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    private Float processBrokenParser(CharacterSpell characterSpell, String string, String string2, int n) {
        Object object;
        Float f = new Float(0.0);
        Float f2 = null;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        while (string.lastIndexOf(40) >= 0) {
            int n2 = CoreUtility.innerMostStringStart(string);
            int n3 = CoreUtility.innerMostStringEnd(string);
            if (n3 < n2) {
                Logging.errorPrint("Missing closing parenthesis: " + string);
                return f;
            }
            String string3 = string.substring(n2 + 1, n3);
            string = string.substring(0, n2) + this.getVariableValue(characterSpell, string3, string2, n) + string.substring(n3 + 1);
        }
        String string4 = "";
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (string.startsWith(".IF.")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(4), ".", true);
            object = "";
            Float f3 = null;
            Float f4 = null;
            Float f5 = null;
            int n7 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if ("GT".equals(string5) || "GTEQ".equals(string5) || "EQ".equals(string5) || "LTEQ".equals(string5) || "LT".equals(string5)) {
                    f3 = this.getVariableValue(characterSpell, ((String)object).substring(0, ((String)object).length() - 1), string2, n);
                    stringTokenizer.nextToken();
                    object = "";
                    if ("LT".equals(string5)) {
                        n7 = 1;
                        continue;
                    }
                    if ("LTEQ".equals(string5)) {
                        n7 = 2;
                        continue;
                    }
                    if ("EQ".equals(string5)) {
                        n7 = 3;
                        continue;
                    }
                    if ("GT".equals(string5)) {
                        n7 = 4;
                        continue;
                    }
                    if (!"GTEQ".equals(string5)) continue;
                    n7 = 5;
                    continue;
                }
                if ("THEN".equals(string5)) {
                    f4 = this.getVariableValue(characterSpell, ((String)object).substring(0, ((String)object).length() - 1), string2, n);
                    stringTokenizer.nextToken();
                    object = "";
                    continue;
                }
                if ("ELSE".equals(string5)) {
                    f5 = this.getVariableValue(characterSpell, ((String)object).substring(0, ((String)object).length() - 1), string2, n);
                    stringTokenizer.nextToken();
                    object = "";
                    continue;
                }
                object = (String)object + string5;
            }
            if (f3 != null && f4 != null && f5 != null) {
                Float f6 = this.getVariableValue(characterSpell, (String)object, string2, n);
                f = f5;
                switch (n7) {
                    case 1: {
                        if (!(f3.doubleValue() >= f4.doubleValue())) break;
                        f = f6;
                        break;
                    }
                    case 2: {
                        if (!(f3.doubleValue() > f4.doubleValue())) break;
                        f = f6;
                        break;
                    }
                    case 3: {
                        if (CoreUtility.doublesEqual(f3.doubleValue(), f4.doubleValue())) break;
                        f = f6;
                        break;
                    }
                    case 4: {
                        if (!(f3.doubleValue() <= f4.doubleValue())) break;
                        f = f6;
                        break;
                    }
                    case 5: {
                        if (!(f3.doubleValue() < f4.doubleValue())) break;
                        f = f6;
                        break;
                    }
                    default: {
                        Logging.errorPrint("ERROR - badly formed statement:" + string + ":" + f3.toString() + ":" + f4.toString() + ":" + n7);
                        return new Float(0.0);
                    }
                }
                return f;
            }
        }
        for (int i = 0; i < string.length(); ++i) {
            string4 = string4 + string.substring(i, i + 1);
            if (i != string.length() - 1 && "+-/*".lastIndexOf(string.charAt(i)) <= -1 && (string4.length() <= 3 || !string4.endsWith("MIN") && (string4.startsWith("MODEQUIP") || !string4.endsWith("MAX")) && !string4.endsWith("REQ")) || string4.length() == 1 && "+-/*".lastIndexOf(string.charAt(i)) > -1) continue;
            if ("+-/*".lastIndexOf(string.charAt(i)) > -1) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            if ((object = this.lookupVariable(string4, string2, characterSpell)) != null) {
                string4 = ((Float)object).toString();
            }
            if (i < string.length()) {
                if (string4.endsWith(".TRUNC")) {
                    string4 = String.valueOf(this.getVariableValue(characterSpell, string4.substring(0, string4.length() - 6), "", n).intValue());
                }
                if (string4.endsWith(".INTVAL")) {
                    string4 = this.getVariableValue(characterSpell, string4.substring(0, string4.length() - 7), "", n).toString();
                    n6 += 10;
                }
                if (string4.endsWith("MIN")) {
                    string4 = this.getVariableValue(characterSpell, string4.substring(0, string4.length() - 3), "", n).toString();
                    n5 = 0;
                    ++n6;
                } else if (string4.endsWith("MAX")) {
                    string4 = this.getVariableValue(characterSpell, string4.substring(0, string4.length() - 3), "", n).toString();
                    n5 = 0;
                    n6 += 2;
                } else if (string4.endsWith("REQ")) {
                    string4 = this.getVariableValue(characterSpell, string4.substring(0, string4.length() - 3), "", n).toString();
                    n5 = 0;
                    n6 += 3;
                } else if (string.length() > 0 && string.charAt(i) == '+') {
                    n5 = 0;
                } else if (string.length() > 0 && string.charAt(i) == '-') {
                    n5 = 1;
                } else if (string.length() > 0 && string.charAt(i) == '*') {
                    n5 = 2;
                } else if (string.length() > 0 && string.charAt(i) == '/') {
                    n5 = 3;
                }
            }
            if (string4.length() > 0) {
                float f7 = 0.0f;
                try {
                    f7 = Float.parseFloat(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                switch (n4) {
                    case 0: {
                        f = Float.valueOf(f.floatValue() + f7);
                        break;
                    }
                    case 1: {
                        f = Float.valueOf(f.floatValue() - f7);
                        break;
                    }
                    case 2: {
                        f = Float.valueOf(f.floatValue() * f7);
                        break;
                    }
                    case 3: {
                        f = Float.valueOf(f.floatValue() / f7);
                        break;
                    }
                    default: {
                        Logging.errorPrint("In PlayerCharacter.getVariableValue the mode " + n4 + " is unsupported.");
                    }
                }
            }
            n4 = n5;
            n5 = 0;
            string4 = "";
            if (f2 != null || n6 % 10 == 0) continue;
            f2 = f;
            f = new Float(0.0);
        }
        if (f2 != null) {
            if (n6 % 10 == 1) {
                f = new Float(Math.min(f.doubleValue(), f2.doubleValue()));
            }
            if (n6 % 10 == 2) {
                f = new Float(Math.max(f.doubleValue(), f2.doubleValue()));
            }
            if (n6 % 10 == 3) {
                f = f2.doubleValue() < f.doubleValue() ? new Float(0.0) : f2;
            }
        }
        if (n6 / 10 > 0) {
            f = Float.valueOf(f.intValue());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CachableResult processJepFormula(CharacterSpell characterSpell, String string, String string2) {
        Logging.debugPrint(this.jepIndent + "getJepVariable: " + string);
        this.jepIndent = this.jepIndent + "    ";
        PJEP pJEP = null;
        try {
            Float f;
            Object object2222;
            pJEP = PjepPool.getInstance().aquire(this, string2);
            pJEP.parseExpression(string);
            if (pJEP.hasError()) {
                Logging.debugPrint(this.jepIndent + "not a JEP expression: " + string);
                CachableResult cachableResult = null;
                return cachableResult;
            }
            for (Object object2222 : pJEP.getSymbolTable().keySet()) {
                if ("e".equals(object2222) || "FALSE".equals(object2222) || "pi".equals(object2222) || "TRUE".equals(object2222)) continue;
                f = this.lookupVariable((String)object2222, string2, characterSpell);
                if (f == null) {
                    CachableResult cachableResult = null;
                    return cachableResult;
                }
                pJEP.addVariable((String)object2222, f.doubleValue());
            }
            Object object3 = pJEP.getValueAsObject();
            if (object3 != null) {
                Logging.debugPrint(this.jepIndent + "Result '" + string + "' = " + object3);
                try {
                    object2222 = new CachableResult(new Float(object3.toString()), pJEP.isResultCachable());
                    return object2222;
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.debugPrint(this.jepIndent + "Result '" + string + "' = " + object3 + " was not a number...");
                    f = null;
                    if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                        this.jepIndent = this.jepIndent.substring(4);
                    }
                    PjepPool.getInstance().release(pJEP);
                    return f;
                }
            }
            Logging.debugPrint(this.jepIndent + "Result '" + string + "' was null...");
            object2222 = null;
            return object2222;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                this.jepIndent = this.jepIndent.substring(4);
            }
            PjepPool.getInstance().release(pJEP);
        }
    }

    abstract Float getInternalVariable(CharacterSpell var1, String var2, String var3);

    public Float lookupVariable(String string, String string2, CharacterSpell characterSpell) {
        Object object;
        Float f = null;
        if (this.pc.hasVariable(string)) {
            object = this.pc.getVariable(string, true, string2, "");
            Logging.debugPrint(this.jepIndent + "variable for: '" + string + "' = " + object);
            f = new Float(((Float)object).doubleValue());
        }
        if (f == null) {
            f = this.getInternalVariable(characterSpell, string, string2);
        }
        if (f == null && (object = this.getExportVariable(string)) != null) {
            f = this.convertToFloat(string, (String)object);
        }
        return f;
    }

    public Float getCachedVariable(String string) {
        if (this.isCachePaused()) {
            return null;
        }
        CachedVariable<Float> cachedVariable = this.fVariableCache.get(string);
        if (cachedVariable != null) {
            if (cachedVariable.getSerial() >= this.getSerial()) {
                return cachedVariable.getValue();
            }
            this.fVariableCache.remove(string);
        }
        return null;
    }

    public void addCachedVariable(String string, Float f) {
        if (this.isCachePaused()) {
            return;
        }
        CachedVariable<Float> cachedVariable = new CachedVariable<Float>();
        cachedVariable.setSerial(this.getSerial());
        cachedVariable.setValue(f);
        this.fVariableCache.put(string, cachedVariable);
    }

    public void restartCache() {
        this.serial = this.cachePaused;
        this.cachePaused = 0;
    }

    public void pauseCache() {
        this.cachePaused = this.serial;
    }

    public boolean isCachePaused() {
        return this.cachePaused > 0;
    }

    public int getSerial() {
        return this.serial;
    }

    public void setSerial(int n) {
        this.serial = n;
    }

    String getCachedString(String string) {
        if (this.isCachePaused()) {
            return null;
        }
        CachedVariable<String> cachedVariable = this.sVariableCache.get(string);
        if (cachedVariable != null) {
            if (cachedVariable.getSerial() >= this.getSerial()) {
                return cachedVariable.getValue();
            }
            this.sVariableCache.remove(string);
        }
        return null;
    }

    public void addCachedString(String string, String string2) {
        if (this.isCachePaused()) {
            return;
        }
        CachedVariable<String> cachedVariable = new CachedVariable<String>();
        cachedVariable.setSerial(this.getSerial());
        cachedVariable.setValue(string2);
        this.sVariableCache.put(string, cachedVariable);
    }

    public String getExportVariable(String string) {
        String string2;
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        ExportHandler exportHandler = new ExportHandler(new File(""));
        exportHandler.replaceTokenSkipMath(this.pc, string, bufferedWriter);
        stringWriter.flush();
        try {
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Couldn't flush the StringWriter used in PlayerCharacter.getVariableValue.", iOException);
        }
        String string3 = stringWriter.toString();
        try {
            string2 = String.valueOf(Float.parseFloat(string3));
        }
        catch (NumberFormatException numberFormatException) {
            string2 = string3;
        }
        return string2;
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    private static class CachableResult {
        final Float result;
        final boolean cachable;

        CachableResult(Float f, boolean bl) {
            this.result = f;
            this.cachable = bl;
        }
    }
}

