/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.base.formula.Formula;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellProgressionCache
implements Cloneable {
    private Progression knownProgression = null;
    private Progression specialtyKnownProgression = null;
    private Progression castProgression = null;

    public List<Formula> setKnown(int n, List<Formula> list) {
        if (this.knownProgression == null) {
            this.knownProgression = new Progression();
        }
        return this.knownProgression.setProgression(n, list);
    }

    public boolean hasKnownProgression() {
        return this.knownProgression != null && this.knownProgression.hasProgression();
    }

    public Map<Integer, List<Formula>> getKnownProgression() {
        return this.knownProgression == null ? null : this.knownProgression.getProgression();
    }

    public List<Formula> getKnownForLevel(int n) {
        return this.knownProgression == null ? null : this.knownProgression.getProgressionForLevel(n);
    }

    public int getHighestKnownSpellLevel() {
        return this.knownProgression == null ? 0 : this.knownProgression.getHighestSpellLevel();
    }

    public List<Formula> setSpecialtyKnown(int n, List<Formula> list) {
        if (this.specialtyKnownProgression == null) {
            this.specialtyKnownProgression = new Progression();
        }
        return this.specialtyKnownProgression.setProgression(n, list);
    }

    public boolean hasSpecialtyKnownProgression() {
        return this.specialtyKnownProgression != null && this.specialtyKnownProgression.hasProgression();
    }

    public Map<Integer, List<Formula>> getSpecialtyKnownMap() {
        return this.specialtyKnownProgression == null ? null : this.specialtyKnownProgression.getProgression();
    }

    public List<Formula> getSpecialtyKnownForLevel(int n) {
        return this.specialtyKnownProgression == null ? null : this.specialtyKnownProgression.getProgressionForLevel(n);
    }

    public List<Formula> setCast(int n, List<Formula> list) {
        if (this.castProgression == null) {
            this.castProgression = new Progression();
        }
        return this.castProgression.setProgression(n, list);
    }

    public boolean hasCastProgression() {
        return this.castProgression != null && this.castProgression.hasProgression();
    }

    public Map<Integer, List<Formula>> getCastProgression() {
        return this.castProgression == null ? null : this.castProgression.getProgression();
    }

    public List<Formula> getCastForLevel(int n) {
        return this.castProgression == null ? null : this.castProgression.getProgressionForLevel(n);
    }

    public int getHighestCastSpellLevel() {
        return this.castProgression == null ? 0 : this.castProgression.getHighestSpellLevel();
    }

    public int getMinLevelForSpellLevel(int n, boolean bl) {
        int n2;
        if (this.castProgression != null && (n2 = this.castProgression.getMinLevelForSpellLevel(n, bl)) != -1) {
            return n2;
        }
        if (this.knownProgression != null && (n2 = this.knownProgression.getMinLevelForSpellLevel(n, bl)) != -1) {
            return n2;
        }
        return -1;
    }

    public int getMaxSpellLevelForClassLevel(int n) {
        List<Formula> list;
        if (this.castProgression != null && (list = this.castProgression.getProgressionForLevel(n)) != null) {
            return list.size() - 1;
        }
        if (this.knownProgression != null && (list = this.knownProgression.getProgressionForLevel(n)) != null) {
            return list.size() - 1;
        }
        return -1;
    }

    public SpellProgressionCache clone() throws CloneNotSupportedException {
        SpellProgressionCache spellProgressionCache = (SpellProgressionCache)super.clone();
        if (this.knownProgression != null) {
            spellProgressionCache.knownProgression = this.knownProgression.clone();
        }
        if (this.specialtyKnownProgression != null) {
            spellProgressionCache.specialtyKnownProgression = this.specialtyKnownProgression.clone();
        }
        if (this.castProgression != null) {
            spellProgressionCache.castProgression = this.castProgression.clone();
        }
        return spellProgressionCache;
    }

    public boolean isEmpty() {
        return this.knownProgression == null && this.castProgression == null && this.specialtyKnownProgression == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Progression
    implements Cloneable {
        private TreeMap<Integer, List<Formula>> progressionMap = null;

        private Progression() {
        }

        public List<Formula> setProgression(int n, List<Formula> list) {
            if (n < 1) {
                throw new IllegalArgumentException("Level must be >= 1 in spell progression");
            }
            if (list == null) {
                throw new IllegalArgumentException("Cannot add null spell progression list to level " + n);
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Cannot add empty spell progression list to level " + n);
            }
            if (list.contains(null)) {
                throw new IllegalArgumentException("Cannot have null value in spell progrssion list in level " + n);
            }
            if (this.progressionMap == null) {
                this.progressionMap = new TreeMap();
            }
            return this.progressionMap.put(n, new ArrayList<Formula>(list));
        }

        public int getMinLevelForSpellLevel(int n, boolean bl) {
            for (Map.Entry<Integer, List<Formula>> entry : this.progressionMap.entrySet()) {
                List<Formula> list = entry.getValue();
                for (int i = n; i < list.size(); ++i) {
                    if (!bl && Integer.parseInt(list.get(i).toString()) == 0) continue;
                    return entry.getKey();
                }
            }
            return -1;
        }

        public boolean hasProgression() {
            return this.progressionMap != null;
        }

        public Map<Integer, List<Formula>> getProgression() {
            if (this.progressionMap == null) {
                return null;
            }
            return this.progressionMap;
        }

        public List<Formula> getProgressionForLevel(int n) {
            ArrayList<Formula> arrayList = null;
            boolean bl = false;
            if (this.progressionMap != null) {
                Integer n2 = n;
                if (!this.progressionMap.containsKey(n2)) {
                    if (this.progressionMap.firstKey() < n) {
                        n2 = this.progressionMap.headMap(n2).lastKey();
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    List<Formula> list = this.progressionMap.get(n2);
                    arrayList = new ArrayList<Formula>(list);
                }
            }
            return arrayList;
        }

        public int getHighestSpellLevel() {
            if (this.progressionMap != null) {
                int n = -1;
                for (List<Formula> list : this.progressionMap.values()) {
                    n = Math.max(n, list.size() - 1);
                }
                return n;
            }
            return -1;
        }

        public Progression clone() throws CloneNotSupportedException {
            Progression progression = (Progression)super.clone();
            if (this.progressionMap != null) {
                progression.progressionMap = new TreeMap<Integer, List<Formula>>((SortedMap<Integer, List<Formula>>)this.progressionMap);
            }
            return progression;
        }
    }
}

