/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Constants;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Pantheon;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.list.CompanionList;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityInfo;
import pcgen.core.AbilityUtilities;
import pcgen.core.ArmorProf;
import pcgen.core.BioSet;
import pcgen.core.Campaign;
import pcgen.core.Categorisable;
import pcgen.core.CategorisableStore;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Kit;
import pcgen.core.LevelInfo;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PaperInfo;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.RollInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.core.WeaponProf;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.EquipSlot;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.persistence.PersistenceManager;
import pcgen.rules.context.LoadContext;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.Visibility;
import pcgen.util.enumeration.VisionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Globals {
    private static List<PlayerCharacter> pcList = new ArrayList<PlayerCharacter>();
    public static Race s_EMPTYRACE;
    public static final String javaVersion;
    public static final int javaVersionMajor;
    public static final int javaVersionMinor;
    private static final String defaultPath;
    private static final String defaultPcgPath;
    private static final String backupPcgPath = "";
    private static String language;
    private static String country;
    private static BioSet bioSet;
    private static final List<String> custColumnWidth;
    private static SourceFormat sourceDisplay;
    private static int selectedPaper;
    private static CategorisableStore abilityStore;
    private static Map<URI, Campaign> campaignMap;
    private static Map<String, Object> spellMap;
    private static Map<String, String> eqSlotMap;
    private static Map<CompanionList, List<CompanionMod>> companionModMap;
    private static List<Campaign> campaignList;
    private static SortedSet<SpecialAbility> saSet;
    private static Map<String, Map<String, String>> sponsors;
    private static List<Map<String, String>> sponsorList;
    private static final Random random;
    private static SortedSet<String> subschoolsSet;
    private static SortedSet<String> castingTimesSet;
    private static SortedSet<String> componentSet;
    private static SortedSet<String> descriptorSet;
    private static SortedSet<String> durationSet;
    private static SortedSet<String> typeForSpellsSet;
    private static SortedSet<String> rangesSet;
    private static SortedSet<String> saveInfoSet;
    private static SortedSet<String> srSet;
    private static SortedSet<String> targetSet;
    private static JFrame rootFrame;
    private static JFrame currentFrame;
    private static final StringBuffer section15;
    private static final String spellPoints = "0";
    private static boolean useGUI;
    public static final boolean isMacPlatform;
    public static final String defaultMacOptionsPath;
    private static final Comparator<PObject> pObjectComp;
    private static final Comparator<CDOMObject> pObjectNameComp;
    private static final Comparator<Object> pObjectStringComp;
    public static final Class[] EMPTY_CLASS_ARRAY;
    public static final Double[] EMPTY_DOUBLE_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final String INNATE_SPELL_BOOK_NAME = "Innate";
    private static boolean hasSpellPPCost;

    public static List<String> getAllowedGameModes() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getAllowedModes();
        }
        return new ArrayList<String>();
    }

    public static BioSet getBioSet() {
        return SettingsHandler.getGame().getBioSet();
    }

    public static Map<String, String> getBonusSpellMap() {
        return SettingsHandler.getGame().getBonusSpellMap();
    }

    public static Campaign getCampaignByURI(URI uRI) {
        return Globals.getCampaignByURI(uRI, true);
    }

    public static Campaign getCampaignByURI(URI uRI, boolean bl) {
        Campaign campaign = campaignMap.get(uRI);
        if (campaign == null && bl) {
            Logging.errorPrint("Could not find campaign by filename: " + uRI);
        }
        return campaign;
    }

    public static List<Campaign> getCampaignList() {
        return campaignList;
    }

    public static Campaign getCampaignKeyed(String string) {
        Campaign campaign = Globals.getCampaignKeyedSilently(string);
        if (campaign == null) {
            Logging.errorPrint("Could not find campaign: " + string);
        }
        return campaign;
    }

    public static Campaign getCampaignKeyedSilently(String string) {
        for (Campaign campaign : Globals.getCampaignList()) {
            if (!campaign.getKeyName().equalsIgnoreCase(string)) continue;
            return campaign;
        }
        return null;
    }

    public static SortedSet<String> getCastingTimesSet() {
        return castingTimesSet;
    }

    public static <T extends PObject> List<T> getPObjectsOfType(Collection<T> collection, String string) {
        ArrayList<PObject> arrayList = new ArrayList<PObject>(collection.size());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken());
        }
        for (PObject pObject : collection) {
            boolean bl = false;
            for (String string2 : arrayList2) {
                boolean bl2;
                boolean bl3 = bl2 = string2.charAt(0) != '!';
                if (pObject.isType(string2) == bl2) {
                    bl = true;
                    continue;
                }
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(pObject);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public static void addCompanionMod(CompanionMod companionMod) {
        String string = companionMod.getType();
        if (string == null || string.length() == 0) {
            Logging.log(Logging.LST_ERROR, "CompanionMod must have a TYPE:, " + companionMod.getKeyName() + " was not assigned a TYPE");
        } else {
            CompanionList companionList = Globals.getContext().ref.constructNowIfNecessary(CompanionList.class, string);
            List<CompanionMod> list = companionModMap.get(companionList);
            if (list == null) {
                list = new ArrayList<CompanionMod>();
                companionModMap.put(companionList, list);
            }
            list.add(companionMod);
        }
    }

    public static void removeCompanionMod(CompanionMod companionMod) {
        Collection<List<CompanionMod>> collection = companionModMap.values();
        Iterator<List<CompanionMod>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            List<CompanionMod> list = iterator.next();
            boolean bl = list.remove(companionMod);
            if (!bl || list.size() != 0) continue;
            iterator.remove();
            return;
        }
    }

    public static Collection<CompanionMod> getCompanionMods(CompanionList companionList) {
        List<CompanionMod> list = companionModMap.get(companionList);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(companionModMap.get(companionList));
    }

    public static Collection<CompanionMod> getAllCompanionMods() {
        ArrayList<CompanionMod> arrayList = new ArrayList<CompanionMod>();
        Collection<List<CompanionMod>> collection = companionModMap.values();
        for (List<CompanionMod> list : collection) {
            arrayList.addAll(list);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static SortedSet<String> getComponentSet() {
        return componentSet;
    }

    public static void setCountry(String string) {
        country = string;
    }

    public static String getCountry() {
        return country;
    }

    public static String getCurrencyDisplay() {
        return SettingsHandler.getGame().getCurrencyDisplay();
    }

    public static void setCurrentPC(PlayerCharacter playerCharacter) {
    }

    public static void setCustColumnWidth(String string, int n, int n2) {
        boolean bl = false;
        String string2 = string.concat(Integer.toString(n));
        String string3 = string2.concat("|").concat(Integer.toString(n2));
        if (Globals.getCustColumnWidth().isEmpty()) {
            Globals.getCustColumnWidth().add(string3);
        }
        int n3 = Globals.getCustColumnWidth().size();
        for (int i = 0; i < n3; ++i) {
            StringTokenizer stringTokenizer;
            String string4;
            String string5 = Globals.getCustColumnWidth().get(i);
            if (string5 == null || string5.length() == 0 || !string2.equals(string4 = (stringTokenizer = new StringTokenizer(string5, "|", false)).nextToken())) continue;
            Globals.getCustColumnWidth().set(i, string3);
            bl = true;
        }
        if (!bl) {
            Globals.getCustColumnWidth().add(string3);
        }
    }

    public static int getCustColumnWidth(String string, int n) {
        int n2 = 0;
        String string2 = string.concat(Integer.toString(n));
        int n3 = Globals.getCustColumnWidth().size();
        for (int i = 0; i < n3; ++i) {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(Globals.getCustColumnWidth().get(i), "|", false);
            if (!stringTokenizer.hasMoreTokens() || !(string3 = stringTokenizer.nextToken()).equals(string2)) continue;
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        return n2;
    }

    public static String getDefaultPath() {
        return Globals.expandRelativePath(defaultPath);
    }

    public static String getUserFilesPath() {
        return Globals.expandRelativePath(System.getProperty("user.home") + File.separator + ".pcgen");
    }

    public static String getBackupPcgPath() {
        return Globals.expandRelativePath(backupPcgPath);
    }

    public static String getDefaultSpellBook() {
        String string = null;
        if (SettingsHandler.getGame() != null) {
            string = SettingsHandler.getGame().getDefaultSpellBook();
        }
        return string;
    }

    public static SortedSet<String> getDescriptorSet() {
        return descriptorSet;
    }

    public static SortedSet<String> getDurationSet() {
        return durationSet;
    }

    public static EquipSlot getEquipSlotByName(String string) {
        for (EquipSlot equipSlot : SystemCollections.getUnmodifiableEquipSlotList()) {
            if (!equipSlot.getSlotName().equals(string)) continue;
            return equipSlot;
        }
        return null;
    }

    public static Map<String, String> getEquipSlotMap() {
        return eqSlotMap;
    }

    public static void setEquipSlotTypeCount(String string, String string2) {
        Globals.getEquipSlotMap().put(string, string2);
    }

    public static int getEquipSlotTypeCount(String string) {
        String string2 = Globals.getEquipSlotMap().get(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return 0;
    }

    public static boolean addAbility(Ability ability) {
        return abilityStore.addCategorisable(ability);
    }

    public static boolean removeAbilityKeyed(String string, String string2) {
        return abilityStore.removeKeyed(string, string2);
    }

    public static Ability getAbilityKeyed(AbilityCategory abilityCategory, String string) {
        return (Ability)abilityStore.getKeyed(abilityCategory.getAbilityCategory(), string);
    }

    public static Ability getAbilityKeyed(String string, String string2) {
        return (Ability)abilityStore.getKeyed(string, string2);
    }

    public static Iterator<Categorisable> getAbilityKeyIterator(String string) {
        AbilityCategory abilityCategory;
        String string2 = string;
        if (!string.equals("ALL") && (abilityCategory = AbilityUtilities.getAbilityCategory(string)) != null) {
            string2 = abilityCategory.getAbilityCategory();
        }
        return abilityStore.getKeyIterator(string2);
    }

    public static Iterator<? extends Categorisable> getAbilityNameIterator(String string) {
        AbilityCategory abilityCategory;
        String string2 = string;
        if (!string.equals("ALL") && (abilityCategory = AbilityUtilities.getAbilityCategory(string)) != null) {
            string2 = abilityCategory.getAbilityCategory();
        }
        return abilityStore.getNameIterator(string2);
    }

    public static List<Ability> getAbilityList(AbilityCategory abilityCategory) {
        List<Categorisable> list = abilityStore.getUnmodifiableList(abilityCategory.getAbilityCategory());
        ArrayList<Ability> arrayList = new ArrayList<Ability>(list.size());
        boolean bl = abilityCategory.getAbilityCategory().equalsIgnoreCase(abilityCategory.getKeyName()) || abilityCategory.isAllAbilityTypes();
        block0: for (Categorisable categorisable : list) {
            if (!(categorisable instanceof Ability)) continue;
            Ability ability = (Ability)categorisable;
            if (bl) {
                arrayList.add(ability);
                continue;
            }
            boolean bl2 = false;
            if (abilityCategory.getAbilityTypes().size() > 0) {
                for (String string : abilityCategory.getAbilityTypes()) {
                    if (!ability.isType(string)) continue;
                    arrayList.add(ability);
                    bl2 = true;
                    break;
                }
            }
            if (bl2 || abilityCategory.getAbilityKeys().size() <= 0) continue;
            for (String string : abilityCategory.getAbilityKeys()) {
                if (!ability.getKeyName().equals(string) && !ability.getKeyName().equals(AbilityUtilities.getUndecoratedName(string, new ArrayList<String>()))) continue;
                arrayList.add(ability);
                continue block0;
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<? extends Categorisable> getUnmodifiableAbilityList(String string) {
        AbilityCategory abilityCategory;
        String string2 = string;
        if (!string.equals("ALL") && (abilityCategory = AbilityUtilities.getAbilityCategory(string)) != null) {
            string2 = abilityCategory.getAbilityCategory();
        }
        return abilityStore.getUnmodifiableList(string2);
    }

    public static List<Ability> getAbilitiesByType(String string, String string2) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (Categorisable categorisable : Globals.getUnmodifiableAbilityList(string)) {
            if (categorisable instanceof Ability) {
                arrayList.add((Ability)categorisable);
                continue;
            }
            if (!(categorisable instanceof AbilityInfo)) continue;
            arrayList.add(((AbilityInfo)categorisable).getAbility());
        }
        return Globals.getPObjectsOfType(arrayList, string2);
    }

    public static String getGameModeACAbbrev() {
        return SettingsHandler.getGame().getACAbbrev();
    }

    public static String getGameModeACText() {
        return SettingsHandler.getGame().getACText();
    }

    public static String getGameModeAlignmentText() {
        return SettingsHandler.getGame().getAlignmentText();
    }

    public static String getGameModeAltHPAbbrev() {
        return SettingsHandler.getGame().getAltHPAbbrev();
    }

    public static String getGameModeAltHPText() {
        return SettingsHandler.getGame().getAltHPText();
    }

    public static String getGameModeBaseSpellDC() {
        return SettingsHandler.getGame().getSpellBaseDC();
    }

    public static String getGameModeDamageResistanceText() {
        return SettingsHandler.getGame().getDamageResistanceText();
    }

    public static int getGameModeNonProfPenalty() {
        return SettingsHandler.getGame().getNonProfPenalty();
    }

    public static String getGameModePointPoolName() {
        return SettingsHandler.getGame().getPointPoolName();
    }

    public static boolean getGameModeHasPointPool() {
        return Globals.getGameModePointPoolName().length() != 0;
    }

    public static String getGameModeHPAbbrev() {
        return SettingsHandler.getGame().getHPAbbrev();
    }

    public static String getGameModeHPFormula() {
        return SettingsHandler.getGame().getHPFormula();
    }

    public static String getGameModeHitPointText() {
        return SettingsHandler.getGame().getHPText();
    }

    public static String getGameModeRankModFormula() {
        return SettingsHandler.getGame().getRankModFormula();
    }

    public static boolean getGameModeShowClassDefense() {
        return SettingsHandler.getGame().getShowClassDefense();
    }

    public static boolean getGameModeShowSpellTab() {
        return SettingsHandler.getGame().getTabShown(Tab.SPELLS);
    }

    public static String getGameModeSpellRangeFormula(String string) {
        return SettingsHandler.getGame().getSpellRangeFormula(string);
    }

    public static UnitSet getGameModeUnitSet() {
        return SettingsHandler.getGame().getUnitSet();
    }

    public static String getGameModeVariableDisplay2Name() {
        return SettingsHandler.getGame().getVariableDisplay2Name();
    }

    public static String getGameModeVariableDisplay2Text() {
        return SettingsHandler.getGame().getVariableDisplay2Text();
    }

    public static String getGameModeVariableDisplay3Name() {
        return SettingsHandler.getGame().getVariableDisplay3Name();
    }

    public static String getGameModeVariableDisplay3Text() {
        return SettingsHandler.getGame().getVariableDisplay3Text();
    }

    public static String getGameModeVariableDisplayName() {
        return SettingsHandler.getGame().getVariableDisplayName();
    }

    public static String getGameModeVariableDisplayText() {
        return SettingsHandler.getGame().getVariableDisplayText();
    }

    public static List<String> getGlobalDeityList() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getDeityList();
        }
        return new ArrayList<String>();
    }

    public static double getGameModeSquareSize() {
        return SettingsHandler.getGame().getSquareSize();
    }

    public static boolean isInGameMode(String string) {
        return string.length() == 0 || SettingsHandler.getGame() != null && string.equalsIgnoreCase(SettingsHandler.getGame().getName());
    }

    public static void setLanguage(String string) {
        language = string;
    }

    public static String getLanguage() {
        return language;
    }

    public static Map<String, LevelInfo> getLevelInfo() {
        GameMode gameMode = SettingsHandler.getGame();
        Map<String, LevelInfo> map = gameMode.getLevelInfo(gameMode.getXpTableName());
        if (map == null) {
            map = new HashMap<String, LevelInfo>();
        }
        return map;
    }

    public static List<String> getLoadStrings() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getLoadStrings();
        }
        return new ArrayList<String>();
    }

    public static String getLongCurrencyDisplay() {
        return SettingsHandler.getGame().getLongCurrencyDisplay();
    }

    public static void setPCList(List<PlayerCharacter> list) {
        pcList = list;
    }

    public static List<PlayerCharacter> getPCList() {
        return pcList;
    }

    public static int getPaperCount() {
        return SystemCollections.getUnmodifiablePaperInfo().size();
    }

    public static String getPaperInfo(int n) {
        return Globals.getPaperInfo(Globals.getSelectedPaper(), n);
    }

    public static String getPaperInfo(int n, int n2) {
        if (n < 0 || n >= SystemCollections.getUnmodifiablePaperInfo().size()) {
            return null;
        }
        PaperInfo paperInfo = SystemCollections.getUnmodifiablePaperInfo().get(n);
        return paperInfo.getPaperInfo(n2);
    }

    public static int getRandomInt() {
        return Globals.getRandom().nextInt();
    }

    public static SortedSet<String> getRangesSet() {
        return rangesSet;
    }

    public static void setRootFrame(JFrame jFrame) {
        rootFrame = jFrame;
    }

    public static JFrame getRootFrame() {
        return rootFrame;
    }

    public static void setCurrentFrame(JFrame jFrame) {
        currentFrame = jFrame;
    }

    public static JFrame getCurrentFrame() {
        if (currentFrame == null) {
            return rootFrame;
        }
        return currentFrame;
    }

    public static SortedSet<SpecialAbility> getSASet() {
        return saSet;
    }

    public static SortedSet<String> getSaveInfoSet() {
        return saveInfoSet;
    }

    public static StringBuffer getSection15() {
        return section15;
    }

    public static int getSelectedPaper() {
        return selectedPaper;
    }

    public static boolean isSkillTypeHidden(String string) {
        return SettingsHandler.getGame().isTypeHidden(Skill.class, string);
    }

    public static void setSourceDisplay(SourceFormat sourceFormat) {
        sourceDisplay = sourceFormat;
    }

    public static SourceFormat getSourceDisplay() {
        return sourceDisplay;
    }

    public static Spell getSpellKeyed(String string) {
        Object obj = Globals.getSpellMap().get(string);
        if (obj != null) {
            if (obj instanceof Spell) {
                return (Spell)obj;
            }
            if (obj instanceof ArrayList) {
                return (Spell)((ArrayList)obj).get(0);
            }
        }
        return null;
    }

    public static Map<String, ?> getSpellMap() {
        return Collections.unmodifiableMap(spellMap);
    }

    public static void addToSpellMap(String string, Object object) {
        spellMap.put(string, object);
    }

    public static Object removeFromSpellMap(String string) {
        return spellMap.remove(string);
    }

    public static String getSpellPoints() {
        return spellPoints;
    }

    public static List<Spell> getSpellsIn(int n, List<? extends CDOMList<Spell>> list, PlayerCharacter playerCharacter) {
        Object object;
        MasterListInterface masterListInterface = Globals.getMasterLists();
        ArrayList<CDOMReference> arrayList = new ArrayList<CDOMReference>();
        block0: for (CDOMReference object22 : masterListInterface.getActiveLists()) {
            for (CDOMList<Spell> cDOMList : list) {
                if (!object22.contains(cDOMList)) continue;
                arrayList.add(object22);
                continue block0;
            }
        }
        boolean bl = n == -1;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (CDOMReference cDOMReference : arrayList) {
            block3: for (Object object2 : masterListInterface.getObjects(cDOMReference)) {
                Object object3 = masterListInterface.getAssociations(cDOMReference, object2);
                object = object3.iterator();
                while (object.hasNext()) {
                    AssociatedPrereqObject associatedPrereqObject = object.next();
                    if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), playerCharacter, null)) continue;
                    int n2 = associatedPrereqObject.getAssociation(AssociationKey.SPELL_LEVEL);
                    if (!bl && n != n2) continue;
                    hashSet.add(object2);
                    continue block3;
                }
            }
        }
        if (playerCharacter != null) {
            DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer> doubleKeyMapToList = playerCharacter.getPCBasedLevelInfo();
            block5: for (Object object4 : doubleKeyMapToList.getKeySet()) {
                for (Object object3 : doubleKeyMapToList.getSecondaryKeySet((Spell)object4)) {
                    if (!list.contains(object3) || (object = doubleKeyMapToList.getListFor((Spell)object4, (CDOMList<Spell>)object3)) == null || !bl && !object.contains(n)) continue;
                    hashSet.add(object4);
                    continue block5;
                }
            }
        }
        return new ArrayList<Spell>(hashSet);
    }

    public static SortedSet<String> getSrSet() {
        return srSet;
    }

    public static SortedSet<String> getSubschools() {
        return Globals.getSubschoolsSet();
    }

    public static SortedSet<String> getTargetSet() {
        return targetSet;
    }

    public static SortedSet<String> getTypeForSpells() {
        return typeForSpellsSet;
    }

    public static void addTypeForSpells(String string) {
        typeForSpellsSet.add(string);
    }

    public static void setUseGUI(boolean bl) {
        useGUI = bl;
    }

    public static boolean getUseGUI() {
        return Globals.isUseGUI();
    }

    public static String getWeaponReachForumla() {
        return SettingsHandler.getGame().getWeaponReachFormula();
    }

    public static void addCampaign(Campaign campaign) {
        campaignMap.put(campaign.getSourceURI(), campaign);
        campaignList.add(campaign);
    }

    public static void addDurationSet(String string) {
        durationSet.add(string);
    }

    public static void addSpellCastingTimesSet(String string) {
        castingTimesSet.add(string);
    }

    public static void addSpellComponentSet(String string) {
        componentSet.add(string);
    }

    public static void addSpellDescriptorSet(String string) {
        descriptorSet.add(string);
    }

    public static void addSpellRangesSet(String string) {
        rangesSet.add(string);
    }

    public static void addSpellSaveInfoSet(String string) {
        saveInfoSet.add(string);
    }

    public static void addSpellSrSet(String string) {
        srSet.add(string);
    }

    public static void addSpellTargetSet(String string) {
        targetSet.add(string);
    }

    public static void addToSASet(SpecialAbility specialAbility) {
        saSet.add(specialAbility);
    }

    public static String adjustDamage(String string, int n, int n2) {
        Object object;
        String string2 = string;
        int n3 = 1;
        int n4 = 0;
        String string3 = backupPcgPath;
        if (n < n2) {
            string3 = Globals.getDamageUpKey(string);
            n4 = 1;
        } else if (n > n2) {
            string3 = Globals.getDamageDownKey(string);
            n4 = -1;
        }
        if (n4 != 0 && string3 != null) {
            object = new StringTokenizer(string3, "|");
            n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            string3 = ((StringTokenizer)object).nextToken();
            object = new StringTokenizer(string3, ",");
            while (n != n2 && ((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                n += n4;
            }
        }
        if (n3 > 1) {
            object = new RollInfo(string2);
            ((RollInfo)object).times *= n3;
            string2 = ((RollInfo)object).toString();
        }
        return string2;
    }

    public static boolean canResizeHaveEffect(PlayerCharacter playerCharacter, Equipment equipment, List<String> list) {
        if (list == null) {
            list = equipment.typeList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String object2 : list) {
            arrayList.add(object2.toUpperCase());
        }
        List<String> list2 = SettingsHandler.getGame().getResizableTypeList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!arrayList.contains(string.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRule(String string) {
        boolean bl = false;
        GameMode gameMode = SettingsHandler.getGame();
        if (gameMode.hasRuleCheck(string)) {
            bl = gameMode.getRuleCheck(string);
            if (SettingsHandler.hasRuleCheck(string)) {
                bl = SettingsHandler.getRuleCheck(string);
            }
        }
        return bl;
    }

    public static void clearCampaignsForRefresh() {
        Globals.emptyLists();
        campaignMap.clear();
        campaignList.clear();
        hasSpellPPCost = false;
    }

    public static void clearSASet() {
        saSet.clear();
    }

    public static boolean displayListsHappy() {
        boolean bl = Globals.checkListsHappy();
        Level level = bl ? Logging.DEBUG : Logging.WARNING;
        Logging.log(level, "Number of objects loaded. The following should all be greater than 0:");
        Logging.log(level, "Races=" + Globals.getContext().ref.getConstructedCDOMObjects(Race.class).size());
        Logging.log(level, "Classes=" + Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class).size());
        Logging.log(level, "Skills=" + Globals.getContext().ref.getConstructedCDOMObjects(Skill.class).size());
        Logging.log(level, "Feats=" + Globals.getUnmodifiableAbilityList("FEAT").size());
        Logging.log(level, "Equipment=" + Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class).size());
        Logging.log(level, "ArmorProfs=" + Globals.getContext().ref.getConstructedCDOMObjects(ArmorProf.class).size());
        Logging.log(level, "ShieldProfs=" + Globals.getContext().ref.getConstructedCDOMObjects(ShieldProf.class).size());
        Logging.log(level, "WeaponProfs=" + Globals.getContext().ref.getConstructedCDOMObjects(WeaponProf.class).size());
        Logging.log(level, "Kits=" + Globals.getContext().ref.getConstructedCDOMObjects(Kit.class).size());
        Logging.log(level, "Templates=" + Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class).size());
        return bl;
    }

    public static boolean checkListsHappy() {
        boolean bl = Globals.getContext().ref.getConstructedCDOMObjects(Race.class).size() != 0 && Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class).size() != 0 && Globals.getContext().ref.getConstructedCDOMObjects(Skill.class).size() != 0 && Globals.getUnmodifiableAbilityList("FEAT").size() != 0 && Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class).size() != 0 && Globals.getContext().ref.getConstructedCDOMObjects(WeaponProf.class).size() != 0;
        return bl;
    }

    public static void emptyLists() {
        abilityStore = new CategorisableStore();
        companionModMap = new TreeMap<CDOMObject, List<CompanionMod>>(CDOMObjectUtilities.CDOM_SORTER);
        saSet = new TreeSet<SpecialAbility>();
        spellMap = new HashMap<String, Object>();
        VisionType.clearConstants();
        Globals.clearSpellSets();
        subschoolsSet = new TreeSet<String>();
        Equipment.clearEquipmentTypes();
        PersistenceManager.getInstance().emptyLists();
        SettingsHandler.getGame().clearLstAbilityCategories();
        SettingsHandler.getGame().clearLoadContext();
        Pantheon.clearConstants();
        RaceType.clearConstants();
        Globals.createEmptyRace();
    }

    public static void executePostExportCommandStandard(String string) {
        String string2 = SettingsHandler.getPostExportCommandStandard();
        Globals.executePostExportCommand(string, string2);
    }

    public static void executePostExportCommandPDF(String string) {
        String string2 = SettingsHandler.getPostExportCommandPDF();
        Globals.executePostExportCommand(string, string2);
    }

    public static void executePostExportCommand(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.indexOf("%") > -1) {
                String string4 = string3.substring(0, string3.indexOf("%"));
                String string5 = string3.substring(string3.indexOf("%") + 1);
                stringArray[i] = string4 + string + string5;
                continue;
            }
            stringArray[i] = string3;
        }
        if (stringArray.length > 0) {
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                Logging.errorPrint("Could not execute " + string2 + " after exporting " + string, iOException);
            }
        }
    }

    public static Load loadTypeForLoadScore(int n, Float f, PlayerCharacter playerCharacter) {
        double d = f.doubleValue() / Globals.maxLoadForLoadScore(n, playerCharacter).doubleValue();
        if (SystemCollections.getLoadInfo().getLoadMultiplier("LIGHT") != null && d <= SystemCollections.getLoadInfo().getLoadMultiplier("LIGHT").doubleValue()) {
            return Load.LIGHT;
        }
        if (SystemCollections.getLoadInfo().getLoadMultiplier("MEDIUM") != null && d <= SystemCollections.getLoadInfo().getLoadMultiplier("MEDIUM").doubleValue()) {
            return Load.MEDIUM;
        }
        if (SystemCollections.getLoadInfo().getLoadMultiplier("HEAVY") != null && d <= SystemCollections.getLoadInfo().getLoadMultiplier("HEAVY").doubleValue()) {
            return Load.HEAVY;
        }
        return Load.OVERLOAD;
    }

    public static Float maxLoadForLoadScore(int n, PlayerCharacter playerCharacter) {
        return Globals.maxLoadForLoadScore(n, playerCharacter, new Float(1.0));
    }

    public static Float maxLoadForLoadScore(int n, PlayerCharacter playerCharacter, Float f) {
        Float f2 = SystemCollections.getLoadInfo().getLoadScoreValue(n);
        String string = SystemCollections.getLoadInfo().getLoadModifierFormula();
        if (string.length() != 0) {
            string = string.replaceAll(Pattern.quote("$$SCORE$$"), Double.toString(f2.doubleValue() * f.doubleValue() * Globals.getLoadMultForSize(playerCharacter)));
            return Float.valueOf(playerCharacter.getVariableValue(string, backupPcgPath).intValue());
        }
        return new Float(f2.doubleValue() * f.doubleValue() * Globals.getLoadMultForSize(playerCharacter));
    }

    public static int rollHP(int n, int n2, String string, int n3) {
        int n4;
        switch (SettingsHandler.getHPRollMethod()) {
            case 4: {
                n4 = -1;
                break;
            }
            case 2: {
                n4 = n2 - n;
                if ((n3 & 1) == 0 && (n4 & 1) != 0) {
                    ++n4;
                }
                n4 = n + n4 / 2;
                break;
            }
            case 1: {
                n4 = n2;
                break;
            }
            case 3: {
                n4 = n - 1 + (int)((double)(SettingsHandler.getHPPct() * (n2 - n + 1)) / 100.0);
                break;
            }
            case 5: {
                n4 = (int)Math.ceil((double)(n + n2) / 2.0);
                break;
            }
            default: {
                n4 = Math.abs(Globals.getRandomInt(n2 - n + 1)) + n;
            }
        }
        if (SettingsHandler.getShowHPDialogAtLevelUp()) {
            Object[] objectArray = new Object[n2 - n + 2];
            objectArray[0] = "<none selected>";
            for (int i = n; i <= n2; ++i) {
                objectArray[i - n + 1] = i;
            }
            while (n <= n2) {
                InputInterface inputInterface = InputFactory.getInputInstance();
                Object object = inputInterface.showInputDialog(Globals.getRootFrame(), "Randomly generate a number between " + n + " and " + n2 + "." + Constants.s_LINE_SEP + "Select it from the box below.", Globals.getGameModeHitPointText() + " for " + CoreUtility.ordinal(n3) + " level of " + string, MessageType.INFORMATION, objectArray, n4);
                if (object == null || !(object instanceof Integer)) continue;
                n4 = (Integer)object;
                break;
            }
        }
        return n4;
    }

    public static boolean selectPaper(String string) {
        for (int i = 0; i < SystemCollections.getUnmodifiablePaperInfo().size(); ++i) {
            PaperInfo paperInfo = SystemCollections.getUnmodifiablePaperInfo().get(i);
            if (!paperInfo.getName().equals(string)) continue;
            Globals.setSelectedPaper(i);
            return true;
        }
        Globals.setSelectedPaper(-1);
        return false;
    }

    public static int sizeInt(String string) {
        return Globals.sizeInt(string, 0);
    }

    public static int sizeInt(String string, int n) {
        for (int i = 0; i <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1; ++i) {
            if (!string.startsWith(SettingsHandler.getGame().getSizeAdjustmentAtIndex(i).getAbbreviation())) continue;
            return i;
        }
        return n;
    }

    public static int sizeInt(SizeAdjustment sizeAdjustment) {
        return SettingsHandler.getGame().sizeIndex(sizeAdjustment);
    }

    public static void sortChooserLists(List list, List list2) {
        boolean bl = list.size() > 0 ? list.get(0) instanceof String : (list2.size() > 0 ? list2.get(0) instanceof String : false);
        if (bl) {
            Collections.sort(list);
            if (list2.size() > 0 && list2.get(0) != null) {
                Collections.sort(list2);
            }
        } else {
            Globals.sortPObjectListByName(list);
            Globals.sortPObjectListByName(list2);
        }
    }

    public static List<? extends PObject> sortPObjectList(List<? extends PObject> list) {
        Collections.sort(list, pObjectComp);
        return list;
    }

    public static <T extends CDOMObject> List<T> sortPObjectListByName(List<T> list) {
        Collections.sort(list, pObjectNameComp);
        return list;
    }

    static String getBonusFeatString() {
        return SettingsHandler.getGame().getBonusFeatLevels().get(0);
    }

    static int getBonusStatsForLevel(int n, PlayerCharacter playerCharacter) {
        int n2 = 0;
        for (String string : SettingsHandler.getGame().getBonusStatLevels()) {
            n2 = Globals.bonusParsing(string, n, n2, playerCharacter);
        }
        return n2;
    }

    public static <T> List<T> getChoiceFromList(String string, List<T> list, List<T> list2, int n) {
        return Globals.getChoiceFromList(string, list, list2, n, false);
    }

    public static <T> List<T> getChoiceFromList(String string, List<T> list, List<T> list2, int n, boolean bl) {
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setTotalChoicesAvail(n);
        chooserInterface.setPoolFlag(bl);
        chooserInterface.setAllowsDups(false);
        chooserInterface.setTitle(string);
        chooserInterface.setAvailableList(list);
        if (list2 != null) {
            chooserInterface.setSelectedList(list2);
        }
        chooserInterface.setVisible(true);
        return chooserInterface.getSelectedList();
    }

    static List<String> getCustColumnWidth() {
        return custColumnWidth;
    }

    static String getDefaultPcgPath() {
        return Globals.expandRelativePath(defaultPcgPath);
    }

    static String getFilepathsPath() {
        String string = System.getProperty("pcgen.filepaths");
        if (string == null) {
            string = System.getProperty("user.dir") + File.separator + "filepaths.ini";
        } else {
            File file = new File(Globals.expandRelativePath(string));
            if (file.exists() && file.isDirectory()) {
                string = file.getAbsolutePath() + File.separator + "filepaths.ini";
                file = new File(string);
            }
            if (file.exists() && !file.canWrite()) {
                Logging.errorPrint("WARNING: The filepaths file you specified is not updatable. Filepath changes will not be saved. File is " + file.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(string);
    }

    static String getFilterPath() {
        String string = System.getProperty("pcgen.filter");
        if (string == null) {
            string = Globals.getFilePath("filter.ini");
        } else {
            File file = new File(Globals.expandRelativePath(string));
            if (file.exists() && file.isDirectory()) {
                string = file.getAbsolutePath() + File.separator + "filter.ini";
                file = new File(string);
            }
            if (file.exists() && !file.canWrite()) {
                Logging.errorPrint("WARNING: The filter file you specified is not updatable. Filter changes will not be saved. File is " + file.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(string);
    }

    static String getOptionsPath() {
        String string = System.getProperty("pcgen.options");
        if (string == null) {
            string = Globals.getFilePath("options.ini");
        } else {
            File file = new File(Globals.expandRelativePath(string));
            if (file.exists() && file.isDirectory()) {
                string = file.getAbsolutePath() + File.separator + "options.ini";
                file = new File(string);
            }
            if (file.exists() && !file.canWrite()) {
                Logging.errorPrint("WARNING: The options file you specified is not updatable. Settings changes will not be saved. File is " + file.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(string);
    }

    public static int getRandomInt(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = Globals.getRandom().nextInt(n);
        Logging.debugPrint("Generated random number between 0 and " + n + ": " + n2);
        return n2;
    }

    public static int getSkillMultiplierForLevel(int n) {
        List<String> list = SettingsHandler.getGame().getSkillMultiplierLevels();
        if (n > list.size() || n <= 0) {
            return 1;
        }
        return Integer.parseInt(list.get(n - 1));
    }

    static String adjustDamage(String string, String string2, String string3) {
        if (string.length() == 0) {
            return string;
        }
        return Globals.adjustDamage(string, Globals.sizeInt(string2), Globals.sizeInt(string3));
    }

    static double calcEncumberedMove(Load load, double d, boolean bl) {
        return Globals.calcEncumberedMove(load, d, bl, null);
    }

    static double calcEncumberedMove(Load load, double d, boolean bl, PlayerCharacter playerCharacter) {
        double d2;
        if (bl) {
            if (playerCharacter != null && playerCharacter.ignoreEncumberedLoadMove(load)) {
                d2 = d;
            } else {
                String string;
                if (playerCharacter != null && (string = SystemCollections.getLoadInfo().getLoadMoveFormula(load.toString())).length() != 0) {
                    string = string.replaceAll(Pattern.quote("$$MOVE$$"), Double.toString(Math.floor(d)));
                    return playerCharacter.getVariableValue(string, backupPcgPath).doubleValue();
                }
                switch (load) {
                    case LIGHT: {
                        d2 = d;
                        break;
                    }
                    case MEDIUM: 
                    case HEAVY: {
                        if (CoreUtility.doublesEqual(d, 5.0)) {
                            d2 = 5.0;
                            break;
                        }
                        if (CoreUtility.doublesEqual(d, 10.0)) {
                            d2 = 5.0;
                            break;
                        }
                        d2 = Math.floor(d / 15.0) * 10.0 + (double)((int)d % 15);
                        break;
                    }
                    case OVERLOAD: {
                        d2 = 0.0;
                        break;
                    }
                    default: {
                        Logging.errorPrint("The load " + (Object)((Object)load) + " is not possible.");
                        d2 = 0.0;
                        break;
                    }
                }
            }
        } else {
            d2 = d;
        }
        return d2;
    }

    static void initCustColumnWidth(List<String> list) {
        Globals.getCustColumnWidth().clear();
        Globals.getCustColumnWidth().addAll(list);
    }

    private static String getDamageDownKey(String string) {
        if (SettingsHandler.getGame().getDamageDownMap().containsKey(string)) {
            return "1|" + SettingsHandler.getGame().getDamageDownMap().get(string);
        }
        RollInfo rollInfo = new RollInfo(string);
        String string2 = "1d" + Integer.toString(rollInfo.sides);
        if (SettingsHandler.getGame().getDamageDownMap().containsKey(string2)) {
            return Integer.toString(rollInfo.times) + "|" + SettingsHandler.getGame().getDamageDownMap().get(string2);
        }
        return null;
    }

    private static String getDamageUpKey(String string) {
        if (SettingsHandler.getGame().getDamageUpMap().containsKey(string)) {
            return "1|" + SettingsHandler.getGame().getDamageUpMap().get(string);
        }
        RollInfo rollInfo = new RollInfo(string);
        String string2 = "1d" + Integer.toString(rollInfo.sides);
        if (SettingsHandler.getGame().getDamageUpMap().containsKey(string2)) {
            return Integer.toString(rollInfo.times) + "|" + SettingsHandler.getGame().getDamageUpMap().get(string2);
        }
        return null;
    }

    private static String getFilePath(String string) {
        String string2 = SettingsHandler.getFilePaths();
        if (string2 == null || string2.equals("pcgen")) {
            return System.getProperty("user.dir") + File.separator + string;
        }
        if (string2.equals("user")) {
            return System.getProperty("user.home") + File.separator + ".pcgen" + File.separator + string;
        }
        if (string2.equals("mac_user")) {
            return System.getProperty("user.home") + "/Library/Preferences/pcgen" + File.separator + string;
        }
        return string2 + File.separator + string;
    }

    private static double getLoadMultForSize(PlayerCharacter playerCharacter) {
        SizeAdjustment sizeAdjustment;
        double d = 1.0;
        String string = playerCharacter.getSize();
        Float f = SystemCollections.getLoadInfo().getSizeAdjustment(string);
        if (f != null) {
            d = f.doubleValue();
        }
        if ((sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(Globals.sizeInt(string))) == null) {
            sizeAdjustment = SettingsHandler.getGame().getDefaultSizeAdjustment();
        }
        if (sizeAdjustment != null) {
            d += sizeAdjustment.bonusTo("LOADMULT", "TYPE=SIZE", playerCharacter, playerCharacter);
        }
        return d;
    }

    private static Random getRandom() {
        return random;
    }

    private static void setSelectedPaper(int n) {
        selectedPaper = n;
    }

    private static SortedSet<String> getSubschoolsSet() {
        return subschoolsSet;
    }

    private static boolean isUseGUI() {
        return useGUI;
    }

    private static int bonusParsing(String string, int n, int n2, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        int n4 = playerCharacter.getVariableValue(string2, backupPcgPath).intValue();
        int n5 = 1;
        if (stringTokenizer.hasMoreTokens()) {
            n5 = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (n == n3 || n > n3 && n4 > 0 && (n - n3) % n4 == 0) {
            n2 += n5;
        }
        return n2;
    }

    private static void clearSpellSets() {
        castingTimesSet.clear();
        componentSet.clear();
        descriptorSet.clear();
        durationSet.clear();
        rangesSet.clear();
        saveInfoSet.clear();
        srSet.clear();
        targetSet.clear();
    }

    public static void createEmptyRace() {
        if (s_EMPTYRACE == null) {
            s_EMPTYRACE = new Race();
            s_EMPTYRACE.setName("<none selected>");
            s_EMPTYRACE.addToListFor(ListKey.TYPE, Type.HUMANOID);
        }
        Globals.getContext().ref.importObject(s_EMPTYRACE);
    }

    private static String expandRelativePath(String string) {
        if (string.startsWith("@")) {
            string = System.getProperty("user.dir") + File.separator + string.substring(1);
        }
        return string;
    }

    public static void addSponsor(Map<String, String> map) {
        sponsors.put(map.get("SPONSOR"), map);
        sponsorList.add(map);
    }

    public static List<Map<String, String>> getSponsors() {
        return sponsorList;
    }

    public static Map<String, String> getSponsor(String string) {
        return sponsors.get(string);
    }

    public static List<String> getAllGenders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PropertyFactory.getString("in_genderMale"));
        arrayList.add(PropertyFactory.getString("in_genderFemale"));
        arrayList.add(PropertyFactory.getString("in_genderNeuter"));
        arrayList.add(PropertyFactory.getString("in_comboNone"));
        arrayList.add(PropertyFactory.getString("in_comboOther"));
        return arrayList;
    }

    public static int[] getDieSizes() {
        return SettingsHandler.getGame().getDieSizes();
    }

    public static int getMaxDieSize() {
        return SettingsHandler.getGame().getMaxDieSize();
    }

    public static int getMinDieSize() {
        return SettingsHandler.getGame().getMinDieSize();
    }

    public static LoadContext getContext() {
        return SettingsHandler.getGame().getContext();
    }

    public static MasterListInterface getMasterLists() {
        return SettingsHandler.getGame().getMasterLists();
    }

    public static boolean hasSpellPPCost() {
        return hasSpellPPCost;
    }

    public static void setSpellPPCost(boolean bl) {
        hasSpellPPCost = bl;
    }

    public static <T extends PObject> List<T> getObjectsOfVisibility(Collection<T> collection, Visibility visibility) {
        ArrayList<PObject> arrayList = new ArrayList<PObject>();
        for (PObject pObject : collection) {
            Visibility visibility2 = pObject.getSafe(ObjectKey.VISIBILITY);
            if (visibility != Visibility.DEFAULT && visibility2 != Visibility.DEFAULT && visibility2 != visibility) continue;
            arrayList.add(pObject);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        javaVersion = System.getProperty("java.version");
        javaVersionMajor = Integer.valueOf(javaVersion.substring(0, javaVersion.indexOf(46)));
        javaVersionMinor = Integer.valueOf(javaVersion.substring(javaVersion.indexOf(46) + 1, javaVersion.lastIndexOf(46)));
        defaultPath = System.getProperty("user.dir");
        defaultPcgPath = Globals.getUserFilesPath() + File.separator + "characters";
        language = "en";
        country = "US";
        bioSet = new BioSet();
        custColumnWidth = new ArrayList<String>();
        sourceDisplay = SourceFormat.LONG;
        selectedPaper = -1;
        abilityStore = new CategorisableStore();
        campaignMap = new HashMap<URI, Campaign>();
        spellMap = new TreeMap<String, Object>();
        eqSlotMap = new HashMap<String, String>();
        companionModMap = new TreeMap<CDOMObject, List<CompanionMod>>(CDOMObjectUtilities.CDOM_SORTER);
        campaignList = new ArrayList<Campaign>(85);
        saSet = new TreeSet<SpecialAbility>();
        sponsors = new HashMap<String, Map<String, String>>();
        sponsorList = new ArrayList<Map<String, String>>();
        random = new Random(System.currentTimeMillis());
        subschoolsSet = new TreeSet<String>();
        castingTimesSet = new TreeSet<String>();
        componentSet = new TreeSet<String>();
        descriptorSet = new TreeSet<String>();
        durationSet = new TreeSet<String>();
        typeForSpellsSet = new TreeSet<String>();
        rangesSet = new TreeSet<String>();
        saveInfoSet = new TreeSet<String>();
        srSet = new TreeSet<String>();
        targetSet = new TreeSet<String>();
        section15 = new StringBuffer(30000);
        useGUI = true;
        isMacPlatform = System.getProperty("os.name").equals("Mac OS X");
        defaultMacOptionsPath = System.getProperty("user.home") + "/Library/Preferences/pcgen";
        pObjectComp = new Comparator<PObject>(){

            @Override
            public int compare(PObject pObject, PObject pObject2) {
                return pObject.getKeyName().compareToIgnoreCase(pObject2.getKeyName());
            }
        };
        pObjectNameComp = new Comparator<CDOMObject>(){

            @Override
            public int compare(CDOMObject cDOMObject, CDOMObject cDOMObject2) {
                Collator collator = Collator.getInstance();
                return collator.compare(cDOMObject.getDisplayName(), cDOMObject2.getDisplayName());
            }
        };
        pObjectStringComp = new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                String string = object instanceof PObject ? ((PObject)object).getKeyName() : object.toString();
                String string2 = object2 instanceof PObject ? ((PObject)object2).getKeyName() : object2.toString();
                return string.compareToIgnoreCase(string2);
            }
        };
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_DOUBLE_ARRAY = new Double[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_STRING_ARRAY = new String[0];
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            resourceBundle.getString("VersionNumber");
        }
        catch (MissingResourceException missingResourceException) {
            Logging.errorPrint("Can't find the VersionNumber property.", missingResourceException);
        }
        finally {
            Object var0_1 = null;
        }
    }
}

