/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.Qualifier;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CDOMTransparentCategorizedSingleRef;
import pcgen.core.Campaign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconstructedValidator {
    private static final Class<CategorizedCDOMObject> CATEGORIZED_CDOM_OBJECT_CLASS = CategorizedCDOMObject.class;
    private final List<Campaign> campaignList;
    private HashMapToList<Class<?>, String> simpleMap;
    private DoubleKeyMapToList<Class<?>, String, String> categoryMap;

    public UnconstructedValidator(List<Campaign> list) {
        this.campaignList = new ArrayList<Campaign>(list);
    }

    public <T extends CDOMObject> boolean allow(Class<T> clazz, String string) {
        List list;
        if (this.simpleMap == null) {
            this.buildSimpleMap();
        }
        if ((list = this.simpleMap.getListFor(clazz)) != null) {
            for (String string2 : list) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildSimpleMap() {
        this.simpleMap = new HashMapToList();
        for (Campaign campaign : this.campaignList) {
            for (Qualifier qualifier : campaign.getSafeListFor(ListKey.FORWARDREF)) {
                Class<? extends CDOMObject> clazz = qualifier.getQualifiedClass();
                if (CATEGORIZED_CDOM_OBJECT_CLASS.isAssignableFrom(clazz)) continue;
                this.simpleMap.addToListFor(clazz, qualifier.getQualifiedReference().getLSTformat());
            }
        }
    }

    private void buildCategoryMap() {
        this.categoryMap = new DoubleKeyMapToList();
        for (Campaign campaign : this.campaignList) {
            for (Qualifier qualifier : campaign.getSafeListFor(ListKey.FORWARDREF)) {
                Class<? extends CDOMObject> clazz = qualifier.getQualifiedClass();
                if (!CATEGORIZED_CDOM_OBJECT_CLASS.isAssignableFrom(clazz)) continue;
                CDOMSingleRef<? extends CDOMObject> cDOMSingleRef = qualifier.getQualifiedReference();
                String string = ((CDOMTransparentCategorizedSingleRef)cDOMSingleRef).getCDOMCategory();
                this.categoryMap.addToListFor(clazz, string, cDOMSingleRef.getLSTformat());
            }
        }
    }

    public <T extends CDOMObject> boolean allow(Class<T> clazz, Category<T> category, String string) {
        List<String> list;
        if (this.categoryMap == null) {
            this.buildCategoryMap();
        }
        if ((list = this.categoryMap.getListFor(clazz, category.getKeyName())) != null) {
            for (String string2 : list) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowDuplicates(Class<?> clazz) {
        for (Campaign campaign : this.campaignList) {
            if (!campaign.containsInList(ListKey.DUPES_ALLOWED, clazz)) continue;
            return true;
        }
        return false;
    }
}

