/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.utils.CoreUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EqModNameOpt {
    NORMAL{

        public String returnName(Equipment equipment, EquipmentModifier equipmentModifier) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(equipmentModifier.getDisplayName());
            if (!equipment.getAssociationList(equipmentModifier).isEmpty()) {
                stringBuilder.append(" (");
                stringBuilder.append(this.associatedList(equipment.getAssociationList(equipmentModifier)));
                stringBuilder.append(')');
            }
            return stringBuilder.toString().trim().replace('|', ' ');
        }
    }
    ,
    NOLIST{

        public String returnName(Equipment equipment, EquipmentModifier equipmentModifier) {
            return equipmentModifier.getDisplayName().trim().replace('|', ' ');
        }
    }
    ,
    NONAME{

        public String returnName(Equipment equipment, EquipmentModifier equipmentModifier) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(equipmentModifier.getDisplayName());
            stringBuilder.append(this.associatedList(equipment.getAssociationList(equipmentModifier)));
            return stringBuilder.toString().trim().replace('|', ' ');
        }
    }
    ,
    NOTHING{

        public String returnName(Equipment equipment, EquipmentModifier equipmentModifier) {
            return "";
        }
    }
    ,
    SPELL{

        public String returnName(Equipment equipment, EquipmentModifier equipmentModifier) {
            StringBuilder stringBuilder = new StringBuilder(100);
            boolean bl = true;
            for (String string : equipment.getAssociationList(equipmentModifier)) {
                String string2;
                List<String> list;
                Object object;
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                String string3 = EqModSpellInfo.getSpellInfoString(string, "SPELLNAME");
                if (SettingsHandler.guiUsesOutputNameSpells() && (object = Globals.getSpellKeyed(string3)) != null) {
                    string3 = ((PObject)object).getOutputName();
                }
                stringBuilder.append(string3);
                object = EqModSpellInfo.getSpellInfoString(string, "VARIANT");
                if (((String)object).length() != 0) {
                    stringBuilder.append(" (").append((String)object).append(')');
                }
                if (!(list = CoreUtility.split(string2 = EqModSpellInfo.getSpellInfoString(string, "METAFEATS"), ',')).isEmpty()) {
                    stringBuilder.append('/').append(StringUtil.join(list, "/"));
                }
                stringBuilder.append('/').append(EqModSpellInfo.getSpellInfoString(string, "CASTER"));
                stringBuilder.append('/').append(CoreUtility.ordinal(EqModSpellInfo.getSpellInfo(string, "CASTERLEVEL")));
            }
            return stringBuilder.toString().trim().replace('|', ' ');
        }
    }
    ,
    TEXT{

        public String returnName(Equipment equipment, EquipmentModifier equipmentModifier) {
            return equipmentModifier.get(StringKey.NAME_TEXT);
        }
    };

    private static CaseInsensitiveMap<EqModNameOpt> typeMap;

    public abstract String returnName(Equipment var1, EquipmentModifier var2);

    public static EqModNameOpt valueOfIgnoreCase(String string) {
        EqModNameOpt eqModNameOpt;
        if (typeMap == null) {
            EqModNameOpt.buildMap();
        }
        if ((eqModNameOpt = typeMap.get(string)) == null) {
            throw new IllegalArgumentException(string + " is not a valid EqModNameOpt");
        }
        return eqModNameOpt;
    }

    private static void buildMap() {
        typeMap = new CaseInsensitiveMap();
        Class<EqModNameOpt> clazz = EqModNameOpt.class;
        for (Field field : clazz.getDeclaredFields()) {
            int n = field.getModifiers();
            String string = field.getName();
            if (!Modifier.isStatic(n) || !Modifier.isFinal(n) || !Modifier.isPublic(n)) continue;
            try {
                Object object = field.get(null);
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                EqModNameOpt eqModNameOpt = (EqModNameOpt)((Object)clazz.cast(object));
                if (typeMap.containsKey(string)) {
                    throw new UnreachableError("Attempt to redefine constant value " + string + ", value was " + (Object)((Object)typeMap.get(string)));
                }
                typeMap.put(string, eqModNameOpt);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InternalError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        }
    }

    public String associatedList(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : list) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            if (string == null) {
                stringBuilder.append('*');
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    static {
        typeMap = null;
    }
}

