/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellReferenceChoiceSet
implements PrimitiveChoiceSet<CDOMListObject<Spell>> {
    private final Set<CDOMReference<? extends CDOMListObject<Spell>>> set;

    public SpellReferenceChoiceSet(Collection<CDOMReference<? extends CDOMListObject<Spell>>> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.set = new HashSet<CDOMReference<? extends CDOMListObject<Spell>>>(collection);
    }

    @Override
    public String getLSTformat(boolean bl) {
        TreeSet treeSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        treeSet.addAll(this.set);
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<CDOMReference> arrayList = new ArrayList<CDOMReference>();
        boolean bl2 = false;
        for (CDOMReference cDOMReference : treeSet) {
            if (DomainSpellList.class.equals(cDOMReference.getReferenceClass())) {
                arrayList.add(cDOMReference);
                continue;
            }
            if (bl2) {
                stringBuilder.append(",");
            }
            stringBuilder.append(cDOMReference.getLSTformat());
            bl2 = true;
        }
        for (CDOMReference cDOMReference : arrayList) {
            if (bl2) {
                stringBuilder.append(",");
            }
            stringBuilder.append("DOMAIN.");
            stringBuilder.append(cDOMReference.getLSTformat());
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    @Override
    public Class<CDOMListObject> getChoiceClass() {
        return CDOMListObject.class;
    }

    @Override
    public Set<CDOMListObject<Spell>> getSet(PlayerCharacter playerCharacter) {
        HashSet<CDOMListObject<Spell>> hashSet = new HashSet<CDOMListObject<Spell>>();
        for (CDOMReference<? extends CDOMListObject<Spell>> cDOMReference : this.set) {
            hashSet.addAll(cDOMReference.getContainedObjects());
        }
        return hashSet;
    }

    public int hashCode() {
        return this.set.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpellReferenceChoiceSet) {
            SpellReferenceChoiceSet spellReferenceChoiceSet = (SpellReferenceChoiceSet)object;
            return ((Object)this.set).equals(spellReferenceChoiceSet.set);
        }
        return false;
    }
}

