/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChoiceSet<T extends PrereqObject>
implements PrimitiveChoiceSet<T> {
    private final Collection<CDOMReference<T>> set;

    public ReferenceChoiceSet(Collection<? extends CDOMReference<T>> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.set = new WeightedCollection<CDOMReference<T>>(collection);
    }

    @Override
    public String getLSTformat(boolean bl) {
        WeightedCollection weightedCollection = new WeightedCollection(ReferenceUtilities.REFERENCE_SORTER);
        weightedCollection.addAll(this.set);
        return ReferenceUtilities.joinLstFormat(weightedCollection, ",", bl);
    }

    @Override
    public Class<T> getChoiceClass() {
        return this.set == null ? null : this.set.iterator().next().getReferenceClass();
    }

    @Override
    public Set<T> getSet(PlayerCharacter playerCharacter) {
        HashSet<T> hashSet = new HashSet<T>();
        for (CDOMReference<T> cDOMReference : this.set) {
            hashSet.addAll(cDOMReference.getContainedObjects());
        }
        return hashSet;
    }

    public int hashCode() {
        return this.set.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ReferenceChoiceSet) {
            ReferenceChoiceSet referenceChoiceSet = (ReferenceChoiceSet)object;
            return ((Object)this.set).equals(referenceChoiceSet.set);
        }
        return false;
    }
}

