/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.ChoiceSetUtilities;
import pcgen.core.PlayerCharacter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundOrChoiceSet<T>
implements PrimitiveChoiceSet<T> {
    private final Set<PrimitiveChoiceSet<T>> set = new TreeSet(ChoiceSetUtilities.WRITEABLE_SORTER);

    public CompoundOrChoiceSet(Collection<PrimitiveChoiceSet<T>> collection) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        this.set.addAll(collection);
    }

    @Override
    public Set<T> getSet(PlayerCharacter playerCharacter) {
        HashSet<T> hashSet = new HashSet<T>();
        for (PrimitiveChoiceSet<T> primitiveChoiceSet : this.set) {
            hashSet.addAll(primitiveChoiceSet.getSet(playerCharacter));
        }
        return hashSet;
    }

    @Override
    public String getLSTformat(boolean bl) {
        return ChoiceSetUtilities.joinLstFormat(this.set, ",", bl);
    }

    @Override
    public Class<? super T> getChoiceClass() {
        return this.set == null ? null : this.set.iterator().next().getChoiceClass();
    }

    public int hashCode() {
        return ((Object)this.set).hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof CompoundOrChoiceSet && ((Object)((CompoundOrChoiceSet)object).set).equals(this.set);
    }
}

