/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.AbilityRef;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChooserUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityRefChoiceSet
implements PrimitiveChoiceSet<AbilitySelection> {
    private final Set<AbilityRef> set;
    private final Category<Ability> category;
    private final Ability.Nature nature;

    public AbilityRefChoiceSet(Category<Ability> category, Collection<? extends AbilityRef> collection, Ability.Nature nature) {
        if (collection == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.set = new HashSet<AbilityRef>(collection);
        if (nature == null) {
            throw new IllegalArgumentException("Choice Nature cannot be null");
        }
        this.nature = nature;
        if (category == null) {
            throw new IllegalArgumentException("Choice Category cannot be null");
        }
        this.category = category;
    }

    @Override
    public String getLSTformat(boolean bl) {
        TreeSet treeSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        for (AbilityRef abilityRef : this.set) {
            treeSet.add(abilityRef.getRef());
        }
        return ReferenceUtilities.joinLstFormat(treeSet, ",", bl);
    }

    @Override
    public Class<AbilitySelection> getChoiceClass() {
        return AbilitySelection.class;
    }

    @Override
    public Set<AbilitySelection> getSet(PlayerCharacter playerCharacter) {
        HashSet<AbilitySelection> hashSet = new HashSet<AbilitySelection>();
        for (AbilityRef abilityRef : this.set) {
            for (Ability ability : abilityRef.getRef().getContainedObjects()) {
                if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                    hashSet.addAll(this.addMultiplySelectableAbility(playerCharacter, ability, abilityRef.getChoice()));
                    continue;
                }
                hashSet.add(new AbilitySelection(ability, this.nature));
            }
        }
        return hashSet;
    }

    private Collection<AbilitySelection> addMultiplySelectableAbility(PlayerCharacter playerCharacter, Ability ability, String string) {
        Ability ability2 = playerCharacter.getFeatNamed(ability.getKeyName());
        Ability ability3 = ability;
        if (ability2 != null) {
            ability3 = ability2;
        }
        boolean bl = false;
        String string2 = null;
        if (string != null) {
            int n = string.indexOf(37);
            if (n > -1) {
                bl = true;
                string2 = string.substring(0, n);
            } else if (string.length() != 0) {
                string2 = string;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ChooserUtilities.modChoices(ability3, arrayList2, arrayList3, false, playerCharacter, true, AbilityCategory.FEAT);
        for (Object object : arrayList2) {
            String string3 = object.toString();
            if ("NOCHOICE".equals(string3)) {
                arrayList.add("");
                continue;
            }
            arrayList.add(string3);
        }
        if (string2 != null && string2.length() != 0) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Object object;
                object = (String)arrayList.get(i);
                if (((String)object).startsWith(string2)) continue;
                arrayList.remove(i);
            }
            if (bl && !arrayList.isEmpty()) {
                arrayList.add(string2);
            }
        }
        ArrayList arrayList4 = new ArrayList(arrayList.size());
        for (String string3 : arrayList) {
            arrayList4.add(new AbilitySelection(ability3, this.nature, string3));
        }
        return arrayList4;
    }

    public int hashCode() {
        return this.set.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbilityRefChoiceSet) {
            AbilityRefChoiceSet abilityRefChoiceSet = (AbilityRefChoiceSet)object;
            return ((Object)this.set).equals(abilityRefChoiceSet.set);
        }
        return false;
    }

    public Category<Ability> getCategory() {
        return this.category;
    }

    public Ability.Nature getNature() {
        return this.nature;
    }
}

