/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.GenericMapToList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleKeyMap<K1, K2, K3, V>
implements Cloneable {
    private final Class<? extends Map> thirdClass;
    private DoubleKeyMap<K1, K2, Map<K3, V>> map;

    public TripleKeyMap() {
        this.thirdClass = HashMap.class;
        this.map = new DoubleKeyMap(HashMap.class, HashMap.class);
    }

    public TripleKeyMap(Class<? extends Map> clazz, Class<? extends Map> clazz2, Class<? extends Map> clazz3) {
        this.map = new DoubleKeyMap(clazz, clazz2);
        if (clazz3 == null) {
            throw new IllegalArgumentException("Third underlying Class cannot be null for TripleKeyMap");
        }
        this.thirdClass = clazz3;
        GenericMapToList.getMapToList(this.thirdClass);
    }

    public V put(K1 K1, K2 K2, K3 K3, V v) {
        Map<K3, V> map = this.map.get(K1, K2);
        if (map == null) {
            map = this.createLocalMap();
            this.map.put(K1, K2, map);
        }
        return map.put(K3, v);
    }

    public V get(K1 K1, K2 K2, K3 K3) {
        Map<K3, V> map = this.map.get(K1, K2);
        if (map == null) {
            return null;
        }
        return map.get(K3);
    }

    public boolean containsKey(K1 K1, K2 K2, K3 K3) {
        Map<K3, V> map = this.map.get(K1, K2);
        if (map == null) {
            return false;
        }
        return map.containsKey(K3);
    }

    public V remove(K1 K1, K2 K2, K3 K3) {
        Map<K3, V> map = this.map.get(K1, K2);
        if (map == null) {
            return null;
        }
        V v = map.remove(K3);
        if (map.isEmpty()) {
            this.map.remove(K1, K2);
        }
        return v;
    }

    public Set<K1> getKeySet() {
        return this.map.getKeySet();
    }

    public Set<K2> getSecondaryKeySet(K1 K1) {
        return this.map.getSecondaryKeySet(K1);
    }

    public Set<K3> getTertiaryKeySet(K1 K1, K2 K2) {
        Map<K3, V> map = this.map.get(K1, K2);
        if (map == null) {
            return Collections.emptySet();
        }
        return new HashSet<K3>(map.keySet());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int firstKeyCount() {
        return this.map.primaryKeyCount();
    }

    public TripleKeyMap<K1, K2, K3, V> clone() throws CloneNotSupportedException {
        TripleKeyMap tripleKeyMap = (TripleKeyMap)super.clone();
        tripleKeyMap.map = new DoubleKeyMap();
        for (K1 K1 : this.map.getKeySet()) {
            for (K2 K2 : this.map.getSecondaryKeySet(K1)) {
                Map<K3, V> map = this.map.get(K1, K2);
                for (Map.Entry<K3, V> entry : map.entrySet()) {
                    tripleKeyMap.put(K1, K2, entry.getKey(), entry.getValue());
                }
            }
        }
        return tripleKeyMap;
    }

    public Set<V> values(K1 K1, K2 K2) {
        Map<K3, V> map = this.map.get(K1, K2);
        if (map == null) {
            return Collections.emptySet();
        }
        return new HashSet<V>(map.values());
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof TripleKeyMap && this.map.equals(((TripleKeyMap)object).map);
    }

    private Map<K3, V> createLocalMap() {
        try {
            return this.thirdClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Class for TripleKeyMap must possess a zero-argument constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Class for TripleKeyMap must possess a public zero-argument constructor", illegalAccessException);
        }
    }
}

