/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCollection
extends AbstractCollection<Object> {
    private final Map<?, ?> map;

    public MapCollection(Map<?, ?> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot provide null to MapCollection");
        }
        this.map = map;
    }

    @Override
    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object) || this.map.containsValue(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.map.containsKey(obj) || this.map.containsValue(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return new MapCollectionIterator(this.map);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return 2 * this.map.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapCollectionIterator
    implements Iterator<Object> {
        private Map.Entry<?, ?> workingEntry;
        private boolean returnedKey = false;
        private final Iterator<?> hashIterator;

        MapCollectionIterator(Map<?, ?> map) {
            this.hashIterator = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.returnedKey || this.hashIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            if (this.returnedKey) {
                this.returnedKey = false;
                return this.workingEntry.getValue();
            }
            this.workingEntry = (Map.Entry)this.hashIterator.next();
            this.returnedKey = true;
            return this.workingEntry.getKey();
        }
    }
}

