/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import pcgen.base.lang.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedStringList
extends AbstractList<String>
implements List<String>,
RandomAccess {
    public static final Comparator<FixedStringList> CASE_SENSITIVE_ORDER = new Comparator<FixedStringList>(){

        @Override
        public int compare(FixedStringList fixedStringList, FixedStringList fixedStringList2) {
            return FixedStringList.compare(fixedStringList, fixedStringList2, StringUtil.CASE_SENSITIVE_ORDER);
        }
    };
    public static final Comparator<FixedStringList> CASE_INSENSITIVE_ORDER = new Comparator<FixedStringList>(){

        @Override
        public int compare(FixedStringList fixedStringList, FixedStringList fixedStringList2) {
            return FixedStringList.compare(fixedStringList, fixedStringList2, String.CASE_INSENSITIVE_ORDER);
        }
    };
    private final String[] array;

    public FixedStringList(int n) {
        this.array = new String[n];
    }

    public FixedStringList(Collection<String> collection) {
        this.array = collection.toArray(new String[collection.size()]);
    }

    public FixedStringList(String ... stringArray) {
        this.array = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.array, 0, stringArray.length);
    }

    @Override
    public boolean add(String string) {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != null) continue;
            this.array[i] = string;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends String> collection) {
        for (String string : collection) {
            if (this.add(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String remove(int n) {
        String string = this.array[n];
        this.array[n] = null;
        return string;
    }

    @Override
    public String set(int n, String string) {
        String string2 = this.array[n];
        this.array[n] = string;
        return string2;
    }

    @Override
    public String get(int n) {
        return this.array[n];
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FixedStringList) {
            FixedStringList fixedStringList = (FixedStringList)object;
            return Arrays.deepEquals(this.array, fixedStringList.array);
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        if (this.array.length == 0) {
            return 0;
        }
        return this.array.length + 29 * (this.array[0] == null ? 0 : this.array[0].hashCode());
    }

    public boolean equalsIgnoreCase(FixedStringList fixedStringList) {
        String[] stringArray = fixedStringList.array;
        int n = this.array.length;
        if (stringArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.array[i];
            if (!(string == null ? stringArray[i] != null : !string.equalsIgnoreCase(stringArray[i]))) continue;
            return false;
        }
        return true;
    }

    public static int compare(FixedStringList fixedStringList, FixedStringList fixedStringList2, Comparator<String> comparator) {
        String[] stringArray = fixedStringList.array;
        int n = stringArray.length;
        String[] stringArray2 = fixedStringList2.array;
        int n2 = stringArray2.length;
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            if (string == null) {
                if (string2 == null) continue;
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            int n3 = comparator.compare(string, string2);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }
}

