/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.formula;

import pcgen.base.formula.ReferenceFormula;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DividingFormula
implements ReferenceFormula<Integer> {
    private final int denom;

    public DividingFormula(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Cannot build a DividingFormula that divides by Zero - will always cause an ArithmeticException when resolved");
        }
        this.denom = n;
    }

    @Override
    public Integer resolve(Number ... numberArray) {
        if (numberArray == null || numberArray.length != 1) {
            throw new IllegalArgumentException("DividingFormula only has one backreference");
        }
        return numberArray[0].intValue() / this.denom;
    }

    public String toString() {
        return "/" + this.denom;
    }

    public int hashCode() {
        return this.denom;
    }

    public boolean equals(Object object) {
        return object instanceof DividingFormula && ((DividingFormula)object).denom == this.denom;
    }
}

