/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Dice;
import gmgen.plugin.SystemAttribute;

public class SystemInitiative {
    protected Dice die;
    protected SystemAttribute attribute;
    protected int bonus;
    protected int currentInitiative = 0;
    protected int mod = 0;
    protected int roll;

    public SystemInitiative(SystemAttribute systemAttribute, int n) {
        this.attribute = systemAttribute;
        this.bonus = n;
        this.die = new Dice(1, 20);
    }

    public SystemInitiative(SystemAttribute systemAttribute) {
        this(systemAttribute, 0);
    }

    public SystemInitiative(int n) {
        this(new SystemAttribute("Attribute", 10), n);
    }

    public SystemInitiative() {
        this(new SystemAttribute("Attribute", 10), 0);
    }

    public void setAttribute(SystemAttribute systemAttribute) {
        this.attribute = systemAttribute;
    }

    public SystemAttribute getAttribute() {
        return this.attribute;
    }

    public void setBonus(int n) {
        this.bonus = n - this.attribute.getModifier();
        if (this.getCurrentInitiative() > 0) {
            this.setCurrentInitiative(this.roll + this.getModifier() + this.mod);
        }
    }

    public int getBonus() {
        return this.bonus;
    }

    public void resetCurrentInitiative() {
        this.currentInitiative = 0;
    }

    public void setCurrentInitiative(int n) {
        this.currentInitiative = n >= 1 ? n : 1;
    }

    public int getCurrentInitiative() {
        return this.currentInitiative;
    }

    public int getModifier() {
        return this.attribute.getModifier() + this.bonus;
    }

    public int check() {
        return this.check(0);
    }

    public int check(int n) {
        this.roll = this.die.roll();
        this.mod = n;
        this.setCurrentInitiative(this.roll + this.getModifier() + n);
        return this.currentInitiative;
    }

    public int checkExtRoll(int n) {
        return this.checkExtRoll(n, 0);
    }

    public int checkExtRoll(int n, int n2) {
        this.roll = n;
        this.mod = n2;
        this.setCurrentInitiative(n + this.getModifier() + n2);
        return this.currentInitiative;
    }

    public int refocus() {
        return this.checkExtRoll(20, 0);
    }

    public int refocus(int n) {
        return this.checkExtRoll(20, n);
    }
}

