/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import gmgen.util.LogReceiver;
import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class LogPanel
extends JPanel
implements LogReceiver {
    private static final String defaultOwner = "General";
    private JTabbedPane pane = new JTabbedPane();

    public LogPanel() {
        this.pane.addTab(defaultOwner, new TabContents());
        this.setLayout(new GridLayout(1, 1));
        this.add(this.pane);
        LogUtilities.inst().addReceiver(this);
    }

    public void clearCurrentTab() {
        TabContents tabContents = (TabContents)this.pane.getSelectedComponent();
        tabContents.clearContents();
    }

    public void logMessage(String string, String string2) {
        int n = this.pane.indexOfTab(string);
        if (n == -1) {
            this.pane.addTab(string, new TabContents());
            n = this.pane.indexOfTab(string);
            this.pane.setSelectedIndex(n);
        }
        TabContents tabContents = (TabContents)this.pane.getComponentAt(n);
        tabContents.addString(string2);
    }

    public void logMessage(String string) {
        this.logMessage(defaultOwner, string);
    }

    private static class TabContents
    extends JPanel {
        private JScrollPane debugCenter = new JScrollPane();
        private JTextArea txtAreaDebug = new JTextArea();

        public TabContents() {
            this.setLayout(new BorderLayout());
            this.debugCenter.setHorizontalScrollBarPolicy(32);
            this.debugCenter.setVerticalScrollBarPolicy(22);
            this.debugCenter.setDoubleBuffered(true);
            this.debugCenter.setPreferredSize(new Dimension(446, 37));
            this.add((Component)this.debugCenter, "Center");
            this.txtAreaDebug.setLineWrap(true);
            this.txtAreaDebug.setWrapStyleWord(true);
            this.txtAreaDebug.setDoubleBuffered(true);
            this.txtAreaDebug.setMinimumSize(new Dimension(426, 17));
            this.txtAreaDebug.setEditable(false);
            this.debugCenter.getViewport().add((Component)this.txtAreaDebug, null);
        }

        public void addString(String string) {
            this.txtAreaDebug.append(string + "\n");
        }

        public void clearContents() {
            this.txtAreaDebug.setText("");
        }
    }
}

