/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.helper.EqModRef;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.AbstractObjectContext;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlteqmodToken
extends AbstractToken
implements CDOMPrimaryToken<Equipment> {
    private static final Class<EquipmentModifier> EQMOD_CLASS = EquipmentModifier.class;
    private static final String EQMOD_WEIGHT = "_WEIGHTADD";
    private static final String EQMOD_DAMAGE = "_DAMAGE";

    public String getTokenName() {
        return "ALTEQMOD";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) throws PersistenceLayerException {
        if (this.isEmpty(string) || this.hasIllegalSeparator('.', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        EquipmentHead equipmentHead = equipment.getEquipmentHead(2);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("None")) {
                Logging.deprecationPrint((String)("'NONE' EqMod in " + this.getTokenName() + " will be ignored"));
                continue;
            }
            if (this.hasIllegalSeparator('|', string2)) {
                return false;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "|");
            String string3 = stringTokenizer2.nextToken();
            if (string3.equals(EQMOD_WEIGHT)) {
                if (!stringTokenizer2.hasMoreTokens()) continue;
                loadContext.obj.put((CDOMObject)equipment, ObjectKey.WEIGHT_MOD, (Object)new BigDecimal(stringTokenizer2.nextToken().replace(',', '.')));
                continue;
            }
            if (string3.equals(EQMOD_DAMAGE)) {
                if (!stringTokenizer2.hasMoreTokens()) continue;
                loadContext.obj.put((CDOMObject)equipment, StringKey.DAMAGE_OVERRIDE, stringTokenizer2.nextToken());
                continue;
            }
            CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(EQMOD_CLASS, string3);
            EqModRef eqModRef = new EqModRef(cDOMSingleRef);
            while (stringTokenizer2.hasMoreTokens()) {
                eqModRef.addChoice(stringTokenizer2.nextToken().replace('=', '|'));
            }
            loadContext.obj.addToList((CDOMObject)equipmentHead, ListKey.EQMOD_INFO, (Object)eqModRef);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        Changes changes;
        Collection collection;
        EquipmentHead equipmentHead;
        BigDecimal bigDecimal;
        AbstractObjectContext abstractObjectContext = loadContext.getObjectContext();
        String string = abstractObjectContext.getString((CDOMObject)equipment, StringKey.DAMAGE_OVERRIDE);
        TreeSet<String> treeSet = new TreeSet<String>();
        if (string != null) {
            treeSet.add("_DAMAGE|" + string);
        }
        if ((bigDecimal = (BigDecimal)abstractObjectContext.getObject((CDOMObject)equipment, ObjectKey.WEIGHT_MOD)) != null) {
            treeSet.add("_WEIGHTADD|" + bigDecimal.toString().replace('.', ','));
        }
        if ((equipmentHead = equipment.getEquipmentHeadReference(2)) != null && (collection = (changes = abstractObjectContext.getListChanges((CDOMObject)equipmentHead, ListKey.EQMOD_INFO)).getAdded()) != null) {
            for (EqModRef eqModRef : collection) {
                String string2 = eqModRef.getRef().getLSTformat();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                for (String string3 : eqModRef.getChoices()) {
                    stringBuilder.append("|");
                    stringBuilder.append(string3.replace('|', '='));
                }
                treeSet.add(stringBuilder.toString());
            }
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(treeSet, (String)".")};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

