/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.io.SimpleFileFilter;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.FileOpenMessage;
import gmgen.pluginmgr.messages.FileTypeMessage;
import gmgen.pluginmgr.messages.LoadMessage;
import gmgen.pluginmgr.messages.NewMessage;
import gmgen.pluginmgr.messages.OpenMessage;
import gmgen.pluginmgr.messages.SaveMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.TabbedPaneUtilities;
import plugin.dicebag.gui.DiceBagPluginController;

public class DiceBagPlugin
extends GMBPlugin {
    private static final String DICEBAG_TOOLS_COMMAND = "TOOLS_MENU_ENTRY";
    public static final String LOG_NAME = "DiceBag";
    private DiceBagPluginController theController = null;
    private JMenuItem notesToolsItem;
    private String name = "DiceBag";
    private String version = "00.00.00.01";

    public FileFilter[] getFileTypes() {
        FileFilter[] fileFilterArray = new FileFilter[]{this.getFileType()};
        return fileFilterArray;
    }

    public FileFilter getFileType() {
        String[] stringArray = new String[]{"dbg"};
        return new SimpleFileFilter(stringArray, "GMGen Dice Bag");
    }

    public void start() {
        this.theController = new DiceBagPluginController();
        GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, this.theController.getComponent(), this.getPluginSystem()));
        this.initMenus();
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"DiceBag.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"DiceBag.LoadOrder", (int)20);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof StateChangedMessage) {
            this.handleStateChangedMessage((StateChangedMessage)gMBMessage);
        } else if (gMBMessage instanceof WindowClosedMessage) {
            this.handleWindowClosedMessage((WindowClosedMessage)gMBMessage);
        } else if (gMBMessage instanceof FileOpenMessage) {
            this.handleFileOpenMessage((FileOpenMessage)gMBMessage);
        } else if (gMBMessage instanceof SaveMessage) {
            this.handleSaveMessage((SaveMessage)gMBMessage);
        } else if (gMBMessage instanceof LoadMessage) {
            this.handleLoadMessage((LoadMessage)gMBMessage);
        } else if (gMBMessage instanceof OpenMessage) {
            this.handleOpenMessage((OpenMessage)gMBMessage);
        } else if (gMBMessage instanceof NewMessage) {
            this.handleNewMessage((NewMessage)gMBMessage);
        } else if (gMBMessage instanceof FileTypeMessage) {
            this.handleFileTypeMessage((FileTypeMessage)gMBMessage);
        }
    }

    private void handleFileTypeMessage(FileTypeMessage fileTypeMessage) {
        fileTypeMessage.addFileTypes(this.getFileTypes());
    }

    private void handleOpenMessage(OpenMessage openMessage) {
        File[] fileArray = openMessage.getFile();
        FileFilter fileFilter = this.getFileType();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileFilter.accept(fileArray[i])) continue;
            this.theController.openFile(fileArray[i]);
        }
    }

    private void handleNewMessage(NewMessage newMessage) {
        if (this.isActive()) {
            this.theController.fileNew();
            newMessage.veto();
        }
    }

    public void toolMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!jTabbedPane.getComponentAt(i).equals(this.theController.getComponent())) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    private void handleFileOpenMessage(FileOpenMessage fileOpenMessage) {
        if (GMGenSystemView.getTabPane().getSelectedComponent().equals(this.theController.getComponent())) {
            this.theController.fileOpen();
            fileOpenMessage.veto();
        }
    }

    private void handleLoadMessage(LoadMessage loadMessage) {
        if (GMGenSystemView.getTabPane().getSelectedComponent().equals(this.theController.getComponent())) {
            this.theController.fileNew();
            loadMessage.veto();
        }
    }

    private void handleSaveMessage(SaveMessage saveMessage) {
        if (this.isActive()) {
            this.theController.fileSave();
            saveMessage.veto();
        }
    }

    private void handleStateChangedMessage(StateChangedMessage stateChangedMessage) {
        if (GMGenSystemView.getTabPane() != null) {
            if (this.isActive()) {
                this.notesToolsItem.setEnabled(false);
                GMGenSystem.inst.openFileItem.setEnabled(true);
                GMGenSystem.inst.saveFileItem.setEnabled(true);
                GMGenSystem.inst.newFileItem.setEnabled(true);
            } else {
                this.notesToolsItem.setEnabled(true);
            }
        }
    }

    private void handleWindowClosedMessage(WindowClosedMessage windowClosedMessage) {
        this.theController.windowClosed();
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.theController.getComponent());
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.theController.getComponent());
    }

    private void initMenus() {
        this.notesToolsItem = this.makeMenuItem(LOG_NAME, DICEBAG_TOOLS_COMMAND, null, "Dice Bag Plugin", 71);
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.notesToolsItem));
    }

    private JMenuItem makeMenuItem(String string, String string2, String string3, String string4, Integer n) {
        URL uRL = null;
        if (string3 != null && string3.length() > 0) {
            uRL = ((Object)((Object)this)).getClass().getResource(string3);
        }
        ActionDelegate actionDelegate = uRL != null ? new ActionDelegate(string, new ImageIcon(uRL)) : new ActionDelegate(string);
        actionDelegate.putValue("ShortDescription", string4);
        actionDelegate.putValue("MnemonicKey", n);
        actionDelegate.putValue("ActionCommandKey", string2);
        JMenuItem jMenuItem = new JMenuItem(actionDelegate);
        return jMenuItem;
    }

    private class ActionDelegate
    extends AbstractAction {
        public ActionDelegate() {
        }

        public ActionDelegate(String string) {
            super(string);
        }

        public ActionDelegate(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (DiceBagPlugin.DICEBAG_TOOLS_COMMAND.equals(string)) {
                DiceBagPlugin.this.toolMenuItem(actionEvent);
            }
        }
    }
}

