/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Deity;
import pcgen.core.PCAlignment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.analysis.SpecialAbilityResolution;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class DeityToken
extends Token {
    public static final String TOKENNAME = "DEITY";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        if (playerCharacter.getDeity() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
            String string3 = "OUTPUTNAME";
            Deity deity = playerCharacter.getDeity();
            if (stringTokenizer.countTokens() > 1) {
                stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            if ("NAME".equals(string3)) {
                string2 = deity.getDisplayName();
            } else if ("OUTPUTNAME".equals(string3)) {
                string2 = deity.getOutputName();
            } else if ("DOMAINLIST".equals(string3)) {
                string2 = DeityToken.getDomainListToken(deity);
            } else if ("FOLLOWERALIGNMENT".equals(string3)) {
                Logging.errorPrint((String)"Output Sheet uses DEITY.FOLLOWERALIGN: Function has been removed from PCGen");
            } else if ("ALIGNMENT".equals(string3)) {
                PCAlignment pCAlignment = (PCAlignment)deity.get(ObjectKey.ALIGNMENT);
                string2 = pCAlignment == null ? "" : pCAlignment.getKeyName();
            } else if ("APPEARANCE".equals(string3)) {
                string2 = deity.getSafe(StringKey.APPEARANCE);
            } else if ("DESCRIPTION".equals(string3)) {
                string2 = playerCharacter.getDescription((PObject)deity);
            } else if ("HOLYITEM".equals(string3)) {
                string2 = deity.getSafe(StringKey.HOLY_ITEM);
            } else if ("FAVOREDWEAPON".equals(string3)) {
                List list = deity.getSafeListFor(ListKey.DEITYWEAPON);
                string2 = ReferenceUtilities.joinLstFormat((Collection)list, (String)"|", (boolean)true);
            } else if ("PANTHEONLIST".equals(string3)) {
                string2 = StringUtil.join((Collection)deity.getSafeListFor(ListKey.PANTHEON), (String)", ");
            } else if ("SOURCE".equals(string3)) {
                string2 = deity.getDefaultSourceString();
            } else if ("SA".equals(string3)) {
                string2 = DeityToken.getSAToken(deity, playerCharacter);
            } else if ("TITLE".equals(string3)) {
                string2 = deity.getSafe(StringKey.TITLE);
            } else if ("WORSHIPPERS".equals(string3)) {
                string2 = deity.getSafe(StringKey.WORSHIPPERS);
            }
        }
        return string2;
    }

    public static String getDomainListToken(Deity deity) {
        return ReferenceUtilities.joinDisplayFormat((Collection)deity.getSafeListMods(Deity.DOMAINLIST), (String)", ");
    }

    public static String getSAToken(Deity deity, PlayerCharacter playerCharacter) {
        ArrayList arrayList = new ArrayList();
        deity.addSpecialAbilitiesToList(arrayList, playerCharacter);
        SpecialAbilityResolution.addSABToList(arrayList, (PlayerCharacter)playerCharacter, (CDOMObject)deity);
        if (arrayList.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (SpecialAbility specialAbility : arrayList) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(specialAbility.getDisplayName());
        }
        return stringBuffer.toString();
    }
}

