/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseResultActor;
import pcgen.cdom.content.ConditionalChoiceActor;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
ChooseResultActor {
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "EQUIP";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        String string2;
        if (this.isEmpty(string)) {
            return false;
        }
        Prerequisite prerequisite = null;
        if (string.indexOf("[") == -1) {
            string2 = string;
        } else {
            int n = string.indexOf("[");
            string2 = string.substring(0, n);
            if (!string.endsWith("]")) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Unresolved Prerequisite in " + string + " in " + this.getFullName()));
                return false;
            }
            prerequisite = this.getPrerequisite(string.substring(n + 1, string.length() - 1));
            if (prerequisite == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Error generating Prerequisite " + string.substring(n + 1, string.length() - 1) + " in " + this.getFullName()));
                return false;
            }
        }
        if (this.hasIllegalSeparator('|', string2)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            EquipToken equipToken;
            String string3 = stringTokenizer.nextToken();
            if ("%LIST".equals(string3)) {
                if (prerequisite == null) {
                    equipToken = this;
                } else {
                    ConditionalChoiceActor conditionalChoiceActor = new ConditionalChoiceActor((ChooseResultActor)this);
                    conditionalChoiceActor.addPrerequisite(prerequisite);
                    equipToken = conditionalChoiceActor;
                }
                loadContext.obj.addToList(cDOMObject, ListKey.CHOOSE_ACTOR, (Object)equipToken);
                continue;
            }
            equipToken = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, EQUIPMENT_CLASS, (String)string3);
            if (equipToken == null) {
                return false;
            }
            loadContext.obj.addToList(cDOMObject, ListKey.EQUIPMENT, (Object)new QualifiedObject((Object)equipToken, prerequisite));
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.CHOOSE_ACTOR);
        Changes changes2 = loadContext.obj.getListChanges(cDOMObject, ListKey.EQUIPMENT);
        Collection collection = changes2.getAdded();
        HashMapToList hashMapToList = new HashMapToList();
        if (collection != null) {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (QualifiedObject)object2.next();
                hashMapToList.addToListFor((Object)object.getPrerequisiteList(), object.getObject(null));
            }
        }
        if ((object2 = changes.getAdded()) != null && !object2.isEmpty()) {
            object = object2.iterator();
            while (object.hasNext()) {
                List list = (ChooseResultActor)object.next();
                if (!list.getSource().equals(this.getTokenName())) continue;
                try {
                    arrayList.add(list.getLstFormat());
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    loadContext.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)persistenceLayerException));
                    return null;
                }
            }
        }
        for (List list : hashMapToList.getKeySet()) {
            List list2 = hashMapToList.getListFor((Object)list);
            WeightedCollection weightedCollection = new WeightedCollection(ReferenceUtilities.REFERENCE_SORTER);
            weightedCollection.addAll((Collection)list2);
            String string = ReferenceUtilities.joinLstFormat((Collection)weightedCollection, (String)"|");
            if (list != null && !list.isEmpty()) {
                if (list.size() > 1) {
                    loadContext.addWriteMessage("Error: " + cDOMObject.getClass().getSimpleName() + " had more than one Prerequisite for " + this.getFullName());
                    return null;
                }
                Prerequisite prerequisite = (Prerequisite)list.get(0);
                StringWriter stringWriter = new StringWriter();
                try {
                    prerequisiteWriter.write((Writer)stringWriter, prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    loadContext.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)persistenceLayerException));
                    return null;
                }
                string = string + '[' + stringWriter.toString() + ']';
            }
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void apply(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        Equipment equipment = (Equipment)Globals.getContext().ref.silentlyGetConstructedCDOMObject(EQUIPMENT_CLASS, string);
        if (equipment != null) {
            equipment = equipment.clone();
            equipment.setQty(1.0);
            equipment.setAutomatic(true);
            playerCharacter.addAssoc((Object)cDOMObject, AssociationListKey.EQUIPMENT, (Object)equipment);
        }
    }

    public void remove(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        Equipment equipment = (Equipment)Globals.getContext().ref.silentlyGetConstructedCDOMObject(EQUIPMENT_CLASS, string);
        if (equipment != null) {
            playerCharacter.removeAssoc((Object)cDOMObject, AssociationListKey.EQUIPMENT, (Object)equipment);
        }
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

