/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;
import plugin.charactersheet.CharacterSheetModel;

public class PreferencesDisplayPanel
extends PreferencesPanel {
    private CharacterSheetModel model;
    private final Color blue = new Color(153, 153, 187);
    private final Color lightBlue = new Color(187, 187, 238);
    private final Color green = new Color(153, 187, 153);
    private final Color lightGreen = new Color(68, 204, 68);
    private final Color red = new Color(187, 153, 153);
    private final Color lightRed = new Color(204, 0, 0);
    private final Color yellow = new Color(187, 187, 153);
    private final Color lightYellow = new Color(204, 204, 68);
    private final Color grey = new Color(153, 153, 153);
    private final Color lightGrey = new Color(255, 255, 255);
    private JPanel colorPanel;
    private JComboBox cbColor;

    public PreferencesDisplayPanel(CharacterSheetModel characterSheetModel) {
        this.initComponents();
        this.initCb();
        this.initPreferences();
        this.model = characterSheetModel;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.cbColor = new JComboBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.colorPanel = new JPanel();
        this.colorPanel.setLayout(new BoxLayout(this.colorPanel, 1));
        this.colorPanel.setBorder(new TitledBorder("Color"));
        JLabel jLabel = new JLabel();
        jLabel.setText("Sheet Color");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(jLabel);
        jPanel3.add(this.cbColor);
        this.colorPanel.add(jPanel3);
        jPanel2.add(this.colorPanel);
        jPanel.add((Component)jPanel2, "North");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        this.add(jScrollPane, "Center");
    }

    private void initCb() {
        this.cbColor.setRenderer(new ColorRenderer());
        Vector<ColorContainer> vector = new Vector<ColorContainer>();
        vector.add(new ColorContainer(0));
        vector.add(new ColorContainer(1));
        vector.add(new ColorContainer(2));
        vector.add(new ColorContainer(3));
        vector.add(new ColorContainer(4));
        vector.add(new ColorContainer(5));
        vector.add(new ColorContainer(6));
        vector.add(new ColorContainer(7));
        vector.add(new ColorContainer(8));
        vector.add(new ColorContainer(9));
        this.cbColor.setModel(new DefaultComboBoxModel(vector));
    }

    public void setColor(int n) {
        this.cbColor.setSelectedIndex(n);
    }

    public int getColor() {
        Object object = this.cbColor.getSelectedItem();
        ColorContainer colorContainer = new ColorContainer(0);
        if (object instanceof ColorContainer) {
            colorContainer = (ColorContainer)object;
        }
        return colorContainer.intValue();
    }

    public void applyPreferences() {
        SettingsHandler.setGMGenOption((String)"CharacterSheet.color", (int)this.getColor());
        this.model.applyPrefs();
    }

    public void initPreferences() {
        this.setColor(SettingsHandler.getGMGenOption((String)"CharacterSheet.color", (int)0));
    }

    public String toString() {
        return "Display";
    }

    private class ColorContainer {
        private Color color;
        private int constant;

        public ColorContainer(int n) {
            this.color = this.getColorFromConstant(n);
            this.constant = n;
        }

        public int intValue() {
            return this.constant;
        }

        public String toString() {
            switch (this.constant) {
                case 0: {
                    return "Blue";
                }
                case 1: {
                    return "Light Blue";
                }
                case 2: {
                    return "Green";
                }
                case 3: {
                    return "Light Green";
                }
                case 4: {
                    return "Red";
                }
                case 5: {
                    return "Light Red";
                }
                case 6: {
                    return "Yellow";
                }
                case 7: {
                    return "Light Yellow";
                }
                case 8: {
                    return "Grey";
                }
                case 9: {
                    return "Light Grey";
                }
            }
            return "Blue";
        }

        public Color getColor() {
            return this.color;
        }

        private Color getColorFromConstant(int n) {
            switch (n) {
                case 0: {
                    return PreferencesDisplayPanel.this.blue;
                }
                case 1: {
                    return PreferencesDisplayPanel.this.lightBlue;
                }
                case 2: {
                    return PreferencesDisplayPanel.this.green;
                }
                case 3: {
                    return PreferencesDisplayPanel.this.lightGreen;
                }
                case 4: {
                    return PreferencesDisplayPanel.this.red;
                }
                case 5: {
                    return PreferencesDisplayPanel.this.lightRed;
                }
                case 6: {
                    return PreferencesDisplayPanel.this.yellow;
                }
                case 7: {
                    return PreferencesDisplayPanel.this.lightYellow;
                }
                case 8: {
                    return PreferencesDisplayPanel.this.grey;
                }
                case 9: {
                    return PreferencesDisplayPanel.this.lightGrey;
                }
            }
            return PreferencesDisplayPanel.this.blue;
        }
    }

    private class ColorRenderer
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            ColorContainer colorContainer = object instanceof ColorContainer ? (ColorContainer)object : new ColorContainer(0);
            jPanel.setBackground(colorContainer.getColor());
            jLabel.setText(colorContainer.toString());
            jPanel.add(jLabel);
            return jPanel;
        }
    }
}

