/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.VarToken;
import plugin.charactersheet.gui.CharacterPanel;

public class PerDayPane
extends JPanel {
    private PlayerCharacter pc;
    private String var = "";
    private String var2 = "";
    private List<JCheckBox> checkList = new ArrayList<JCheckBox>();
    private Properties pcProperties;
    private boolean updateProperties = false;
    private JPanel checkPane;
    private JCheckBox jCheckBox2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JLabel numDayLabel;
    private JLabel summaryLabel;
    private JLabel title;

    public PerDayPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jCheckBox2 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.title = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.summaryLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.numDayLabel = new JLabel();
        this.checkPane = new JPanel();
        this.jCheckBox2.setText("jCheckBox2");
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font("Dialog", 1, 14));
        this.title.setText(" ");
        this.jPanel1.add(this.title);
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jPanel5.setLayout(new FlowLayout(1, 1, 0));
        this.summaryLabel.setFont(new Font("Dialog", 0, 10));
        this.summaryLabel.setText(" ");
        this.jPanel5.add(this.summaryLabel);
        this.jPanel3.add(this.jPanel5);
        this.jPanel6.setLayout(new FlowLayout(1, 1, 0));
        this.numDayLabel.setFont(new Font("Dialog", 0, 10));
        this.jPanel6.add(this.numDayLabel);
        this.jPanel3.add(this.jPanel6);
        this.jPanel2.add(this.jPanel3);
        this.checkPane.setLayout(new BoxLayout(this.checkPane, 1));
        this.jPanel2.add(this.checkPane);
        this.add(this.jPanel2);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel2.setBackground(CharacterPanel.border);
        this.jPanel3.setBackground(CharacterPanel.header);
        this.jPanel3.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel5.setBackground(CharacterPanel.header);
        this.jPanel6.setBackground(CharacterPanel.header);
        this.checkPane.setBackground(CharacterPanel.border);
        this.checkPane.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties, String string, String string2, String string3, String string4) {
        this.pc = playerCharacter;
        this.pcProperties = properties;
        this.var = string;
        this.var2 = string2;
        this.title.setText(string3);
        this.summaryLabel.setText(string4);
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties, String string, String string2, String string3) {
        this.setPc(playerCharacter, properties, string, "", string2, string3);
    }

    public void refresh() {
        int n = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)this.var, (boolean)false);
        if (n > 0) {
            this.setVisible(true);
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.var2.equals("")) {
                int n2 = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)this.var2, (boolean)false);
                this.numDayLabel.setText(stringBuffer.append('(').append(n2).append(')').toString());
            } else {
                this.numDayLabel.setText(stringBuffer.append('(').append(n).append(')').toString());
            }
            this.addCheckBoxes(n);
        } else {
            this.setVisible(false);
        }
        this.updatePane();
    }

    private void addCheckBoxes(int n) {
        if (this.checkList.size() != n) {
            this.checkList.clear();
            this.checkPane.removeAll();
            JPanel jPanel = new JPanel();
            for (int i = 0; i < n; ++i) {
                JComponent jComponent;
                if (i % 25 == 0) {
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout(0, 0, 1));
                    jPanel.setBackground(CharacterPanel.white);
                    this.checkPane.add(jPanel);
                }
                if (i % 5 == 0) {
                    jComponent = new JLabel();
                    jComponent.setFont(new Font("Dialog", 0, 10));
                    ((JLabel)jComponent).setText(" ");
                    jPanel.add(jComponent);
                }
                jComponent = new JCheckBox();
                jComponent.setBackground(CharacterPanel.white);
                jComponent.setBorder(null);
                this.checkList.add((JCheckBox)jComponent);
                jPanel.add(jComponent);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PerDayPane.this.pc.setDirty(true);
                        PerDayPane.this.updateProperties();
                    }
                });
            }
        }
    }

    public void updateProperties() {
        if (this.updateProperties) {
            int n = 0;
            for (JCheckBox jCheckBox : this.checkList) {
                if (!jCheckBox.isSelected()) continue;
                ++n;
            }
            this.pcProperties.put("cs.PerDayPane." + this.getPropTitle(), Integer.toString(n));
        }
    }

    public void updatePane() {
        try {
            int n = Integer.parseInt((String)this.pcProperties.get("cs.PerDayPane." + this.getPropTitle()));
            for (JCheckBox jCheckBox : this.checkList) {
                if (n > 0) {
                    jCheckBox.setSelected(true);
                    --n;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
            this.updateProperties = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private String getPropTitle() {
        String string = this.title.getText();
        return string.replaceAll(" ", "");
    }

    public void destruct() {
    }
}

