/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import pcgen.core.Equipment;
import pcgen.core.EquipmentUtilities;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.EqToken;
import pcgen.io.exporttoken.TotalToken;
import pcgen.util.BigDecimalHelper;
import plugin.charactersheet.gui.CharacterPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentPane
extends JPanel {
    private PlayerCharacter pc;
    private List<Component> removeList = new ArrayList<Component>();
    private JPanel costHeaderPanel;
    private JPanel equipmentHeaderPanel;
    private JPanel itemHeaderPanel;
    private JPanel locationHeaderPanel;
    private JPanel qtyHeaderPanel;
    private JPanel wtHeaderPanel;
    private JLabel totalWeight = new JLabel();
    private JLabel totalGp = new JLabel();
    private static final String DIALOG = "Dialog";
    private static final String BLANK = "";
    private static final String SPACE = " ";
    private static final String TOTAL_VALUE = "TOTAL WEIGHT CARRIED/VALUE";
    private static final String EQUIPMENT = "Equipment";
    private static final String ITEM = "ITEM";
    private static final String LOCATION = "LOCATION";
    private static final String QTY = "QTY";
    private static final String COST = "COST";
    private static final String WT = "WT";
    private static final String COIN = "Coin";
    private static final String GEM = "Gem";
    private static final String AMMO = "Ammunition";
    private static final String POTION = "Potion";
    private static final String CONSUMABLE = "Consumable";

    public EquipmentPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.equipmentHeaderPanel = new JPanel();
        this.itemHeaderPanel = new JPanel();
        this.costHeaderPanel = new JPanel();
        this.locationHeaderPanel = new JPanel();
        this.qtyHeaderPanel = new JPanel();
        this.wtHeaderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.equipmentHeaderPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel.setFont(new Font(DIALOG, 1, 14));
        jLabel.setText(EQUIPMENT);
        this.equipmentHeaderPanel.add(jLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.add((Component)this.equipmentHeaderPanel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.itemHeaderPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel2.setFont(new Font(DIALOG, 0, 10));
        jLabel2.setText(ITEM);
        this.itemHeaderPanel.add(jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.itemHeaderPanel, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        this.locationHeaderPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel3.setFont(new Font(DIALOG, 0, 10));
        jLabel3.setText(LOCATION);
        this.locationHeaderPanel.add(jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.locationHeaderPanel, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        this.qtyHeaderPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel4.setFont(new Font(DIALOG, 0, 10));
        jLabel4.setText(QTY);
        this.qtyHeaderPanel.add(jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.qtyHeaderPanel, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        this.costHeaderPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel5.setFont(new Font(DIALOG, 0, 10));
        jLabel5.setText(COST);
        this.costHeaderPanel.add(jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.costHeaderPanel, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        this.wtHeaderPanel.setLayout(new FlowLayout(1, 1, 0));
        jLabel6.setFont(new Font(DIALOG, 0, 10));
        jLabel6.setText(WT);
        this.wtHeaderPanel.add(jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.wtHeaderPanel, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 200, 0, 0);
        this.add((Component)jLabel7, gridBagConstraints);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.setBorder(new LineBorder(CharacterPanel.border));
        this.equipmentHeaderPanel.setBackground(CharacterPanel.header);
        this.itemHeaderPanel.setBackground(CharacterPanel.header);
        this.locationHeaderPanel.setBackground(CharacterPanel.header);
        this.qtyHeaderPanel.setBackground(CharacterPanel.header);
        this.costHeaderPanel.setBackground(CharacterPanel.header);
        this.wtHeaderPanel.setBackground(CharacterPanel.header);
    }

    public void setPc(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    public void refresh() {
        List<Equipment> list = this.getEqList(this.pc);
        if (list.size() == 0) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            for (Component component : this.removeList) {
                this.remove(component);
            }
            this.removeList.clear();
            int n = 2;
            for (int i = 0; i < list.size(); ++i) {
                Color color = i % 2 == 0 ? CharacterPanel.bodyLight : CharacterPanel.bodyMedLight;
                Equipment equipment = list.get(i);
                n = this.addLine(equipment, color, n);
            }
            this.addEnd(n, TotalToken.getWeightToken((PlayerCharacter)this.pc), TotalToken.getValueToken((PlayerCharacter)this.pc));
        }
    }

    private int addLine(Equipment equipment, Color color, int n) {
        int n2;
        Object object;
        Object object2;
        Object object3;
        JComponent jComponent;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(color);
        int n3 = 0;
        if (equipment.isEquipped()) {
            n3 = 1;
        }
        jTextArea.setFont(new Font(DIALOG, n3, 11));
        jTextArea.setText(EqToken.getNameToken((Equipment)equipment, (PlayerCharacter)this.pc));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)jTextArea, gridBagConstraints);
        this.removeList.add(jTextArea);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jPanel.setLayout(new FlowLayout(1, 1, 0));
        jPanel.setBackground(color);
        jLabel.setFont(new Font(DIALOG, 0, 10));
        jLabel.setText(EqToken.getLocationToken((Equipment)equipment));
        jPanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        this.removeList.add(jPanel);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        jPanel2.setLayout(new FlowLayout(1, 1, 0));
        jPanel2.setBackground(color);
        jLabel2.setFont(new Font(DIALOG, 0, 10));
        jLabel2.setText(EqToken.getQtyToken((Equipment)equipment));
        jPanel2.add(jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel2, gridBagConstraints);
        this.removeList.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        jPanel3.setLayout(new FlowLayout(1, 1, 0));
        jPanel3.setBackground(color);
        jLabel3.setFont(new Font(DIALOG, 0, 10));
        jLabel3.setText(Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getWtTokenDouble((PlayerCharacter)this.pc, (Equipment)equipment)));
        jPanel3.add(jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel3, gridBagConstraints);
        this.removeList.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel4 = new JLabel();
        jPanel4.setLayout(new FlowLayout(1, 1, 0));
        jPanel4.setBackground(color);
        jLabel4.setFont(new Font(DIALOG, 0, 10));
        jLabel4.setText(EqToken.getCostToken((PlayerCharacter)this.pc, (Equipment)equipment));
        jPanel4.add(jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel4, gridBagConstraints);
        this.removeList.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(color);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel5, gridBagConstraints);
        this.removeList.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(color);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel6, gridBagConstraints);
        this.removeList.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(1, 1, 0));
        jPanel7.setBackground(color);
        if (equipment.qty() > 1.0) {
            jComponent = new JLabel();
            jComponent.setFont(new Font(DIALOG, 0, 10));
            object3 = new StringBuffer();
            ((StringBuffer)object3).append('(').append(Globals.getGameModeUnitSet().displayWeightInUnitSet(equipment.qty() * equipment.getWeightAsDouble(this.pc))).append(')');
            ((JLabel)jComponent).setText(((StringBuffer)object3).toString());
            jPanel7.add(jComponent);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel7, gridBagConstraints);
        this.removeList.add(jPanel7);
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(1, 1, 0));
        jComponent.setBackground(color);
        if (equipment.qty() > 1.0) {
            object3 = new JLabel();
            ((JComponent)object3).setFont(new Font(DIALOG, 0, 10));
            object2 = equipment.getCost(this.pc).multiply(new BigDecimal(equipment.qty()));
            object = new StringBuffer();
            ((StringBuffer)object).append('(').append(BigDecimalHelper.trimZeros((BigDecimal)object2)).append(')');
            ((JLabel)object3).setText(((StringBuffer)object).toString());
            jComponent.add((Component)object3);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        this.add((Component)jComponent, gridBagConstraints);
        this.removeList.add(jComponent);
        object3 = EqToken.getContentsToken((Equipment)equipment);
        if (!((String)object3).equals(BLANK)) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            object2 = new JTextArea();
            ((JTextArea)object2).setLineWrap(true);
            ((JTextArea)object2).setWrapStyleWord(true);
            ((JComponent)object2).setBackground(color);
            ((JTextArea)object2).setFont(new Font(DIALOG, 0, 9));
            ((JTextComponent)object2).setText((String)object3);
            this.add((Component)object2, gridBagConstraints);
            this.removeList.add((Component)object2);
        }
        if (!((String)(object2 = EqToken.getSpropToken((PlayerCharacter)this.pc, (Equipment)equipment))).equals(BLANK)) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            object = new JTextArea();
            ((JTextArea)object).setLineWrap(true);
            ((JTextArea)object).setWrapStyleWord(true);
            ((JComponent)object).setBackground(color);
            ((JTextArea)object).setFont(new Font(DIALOG, 0, 9));
            ((JTextComponent)object).setText((String)object2);
            this.add((Component)object, gridBagConstraints);
            this.removeList.add((Component)object);
        }
        if (!((String)(object = EqToken.getNoteToken((Equipment)equipment))).equals(BLANK)) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            JTextArea jTextArea2 = new JTextArea();
            jTextArea2.setLineWrap(true);
            jTextArea2.setWrapStyleWord(true);
            jTextArea2.setBackground(color);
            jTextArea2.setFont(new Font(DIALOG, 0, 9));
            jTextArea2.setText((String)object);
            this.add((Component)jTextArea2, gridBagConstraints);
            this.removeList.add(jTextArea2);
        }
        if ((n2 = this.getBoxes(equipment)) > 0) {
            JPanel jPanel8 = new JPanel();
            for (int i = 0; i < n2; ++i) {
                JComponent jComponent2;
                if (i % 25 == 0) {
                    jPanel8 = new JPanel();
                    jPanel8.setLayout(new FlowLayout(0, 0, 1));
                    jPanel8.setBackground(color);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridwidth = 5;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.fill = 1;
                    this.add((Component)jPanel8, gridBagConstraints);
                    this.removeList.add(jPanel8);
                }
                if (i % 5 == 0) {
                    jComponent2 = new JLabel();
                    jComponent2.setFont(new Font(DIALOG, 0, 10));
                    ((JLabel)jComponent2).setText(SPACE);
                    jPanel8.add(jComponent2);
                }
                jComponent2 = new JCheckBox();
                jComponent2.setBackground(color);
                jComponent2.setBorder(null);
                jPanel8.add(jComponent2);
            }
        }
        return n;
    }

    private void addEnd(int n, String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 1, 0));
        jPanel.setBackground(CharacterPanel.header);
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(DIALOG, 0, 10));
        jLabel.setText(TOTAL_VALUE);
        jPanel.add(jLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        this.removeList.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 1, 0));
        jPanel2.setBackground(CharacterPanel.header);
        this.totalWeight.setFont(new Font(DIALOG, 0, 10));
        this.totalWeight.setText(string);
        jPanel2.add(this.totalWeight);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel2, gridBagConstraints);
        this.removeList.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 1, 0));
        jPanel3.setBackground(CharacterPanel.header);
        this.totalGp.setFont(new Font(DIALOG, 0, 10));
        this.totalGp.setText(string2);
        jPanel3.add(this.totalGp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel3, gridBagConstraints);
        this.removeList.add(jPanel3);
    }

    private List<Equipment> getEqList(PlayerCharacter playerCharacter) {
        int n = 2;
        List list = playerCharacter.getEquipmentListInOutputOrder(n);
        list = EquipmentUtilities.removeEqType((List)list, (String)COIN);
        list = EquipmentUtilities.removeEqType((List)list, (String)GEM);
        return list;
    }

    private int getBoxes(Equipment equipment) {
        int n = 0;
        if (equipment.isType(AMMO) || equipment.isType(POTION) || equipment.isType(CONSUMABLE)) {
            n = (int)EqToken.getCheckboxesDoubleToken((Equipment)equipment);
        } else if (equipment.getRemainingCharges() > 0) {
            n = EqToken.getChargesTokenInt((Equipment)equipment);
        }
        return n;
    }

    public void destruct() {
    }
}

