/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.CampaignURL;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlToken
implements CDOMPrimaryToken<Campaign> {
    private static final String URL_KIND_NAME_WEBSITE = "WEBSITE";
    private static final String URL_KIND_NAME_SURVEY = "SURVEY";

    public String getTokenName() {
        return "URL";
    }

    public boolean parse(LoadContext loadContext, Campaign campaign, String string) throws PersistenceLayerException {
        URI uRI;
        CampaignURL.URLKind uRLKind;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() != 3) {
            Logging.log((Level)Logging.LST_ERROR, (String)("URL token requires three arguments. Link kind, link and description.  : " + string));
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase(URL_KIND_NAME_WEBSITE)) {
            if (!string2.equals(URL_KIND_NAME_WEBSITE)) {
                Logging.log((Level)Logging.LST_WARNING, (String)("URL type should be WEBSITE in upper case : " + string));
            }
            uRLKind = CampaignURL.URLKind.WEBSITE;
            string2 = "";
        } else if (string2.equalsIgnoreCase(URL_KIND_NAME_SURVEY)) {
            if (!string2.equals(URL_KIND_NAME_SURVEY)) {
                Logging.log((Level)Logging.LST_WARNING, (String)("URL type should be SURVEY in upper case : " + string));
            }
            uRLKind = CampaignURL.URLKind.SURVEY;
            string2 = "";
        } else {
            uRLKind = CampaignURL.URLKind.PURCHASE;
        }
        try {
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Invalid URL (" + uRISyntaxException.getMessage() + ") : " + string));
            return false;
        }
        CampaignURL campaignURL = new CampaignURL(uRLKind, string2, uRI, string4);
        loadContext.obj.addToList((CDOMObject)campaign, ListKey.CAMPAIGN_URL, (Object)campaignURL);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Campaign campaign) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)campaign, ListKey.CAMPAIGN_URL);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection collection = changes.getAdded();
        if (collection != null && !collection.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            for (CampaignURL campaignURL : collection) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(campaignURL.getUrlKind());
                stringBuilder.append("|");
                stringBuilder.append(campaignURL.getUri().toString());
                stringBuilder.append("|");
                stringBuilder.append(campaignURL.getUrlDesc());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

