/*
 * Decompiled with CFR 0.152.
 */
package plugin.doomsdaybook.gui;

import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdom.DataConversionException;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.Logging;
import plugin.doomsdaybook.gui.NameButton;
import plugin.doomsdaybook.gui.XMLFilter;
import plugin.doomsdaybook.util.CRRule;
import plugin.doomsdaybook.util.DDList;
import plugin.doomsdaybook.util.DataElement;
import plugin.doomsdaybook.util.DataElementComperator;
import plugin.doomsdaybook.util.DataValue;
import plugin.doomsdaybook.util.HyphenRule;
import plugin.doomsdaybook.util.Rule;
import plugin.doomsdaybook.util.RuleSet;
import plugin.doomsdaybook.util.SpaceRule;
import plugin.doomsdaybook.util.VariableHashMap;
import plugin.doomsdaybook.util.WeightedDataValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameGenPanel
extends JPanel {
    public Preferences namePrefs = Preferences.userNodeForPackage(NameGenPanel.class);
    private Map<String, List<RuleSet>> categories = new HashMap<String, List<RuleSet>>();
    private JButton generateButton;
    private JButton jButton1;
    private JCheckBox chkStructure;
    private JComboBox cbCatalog;
    private JComboBox cbCategory;
    private JComboBox cbSex;
    private JComboBox cbStructure;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel meaning;
    private JLabel pronounciation;
    private JPanel buttonPanel;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTextField name;
    private VariableHashMap allVars = new VariableHashMap();
    private Rule lastRule = null;

    public NameGenPanel() {
        this.initComponents();
        this.initPrefs();
        this.loadData(new File("."));
    }

    public NameGenPanel(File file) {
        this.initComponents();
        this.initPrefs();
        this.loadData(file);
    }

    public void setExitPrefs() {
    }

    public Rule generate() {
        try {
            ArrayList arrayList;
            Rule rule = null;
            if (this.chkStructure.isSelected()) {
                arrayList = (RuleSet)this.cbCatalog.getSelectedItem();
                rule = arrayList.getRule();
            } else {
                rule = (Rule)this.cbStructure.getSelectedItem();
            }
            arrayList = rule.getData();
            this.setNameText(arrayList);
            this.setMeaningText(arrayList);
            this.setPronounciationText(arrayList);
            return rule;
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public void initPrefs() {
        double d;
        boolean bl = this.namePrefs.getBoolean("arePrefsSet", false);
        if (!bl) {
            this.namePrefs.putBoolean("arePrefsSet", true);
        }
        if ((d = this.namePrefs.getDouble("Version", 0.0)) < 0.5 || !bl) {
            this.namePrefs.putDouble("Version", 0.5);
        }
        this.namePrefs.putDouble("SubVersion", 0.0);
    }

    private void setMeaningText(String string) {
        this.meaning.setText(string);
    }

    private void setMeaningText(ArrayList<DataValue> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (DataValue dataValue : arrayList) {
            String string = dataValue.getSubValue("meaning");
            if (string == null) {
                string = dataValue.getValue();
            }
            stringBuffer.append(string);
        }
        this.setMeaningText(stringBuffer.toString());
    }

    private void setNameText(String string) {
        this.name.setText(string);
        LogUtilities.inst().logMessage("Random_Name_Generator", string);
    }

    private void setNameText(ArrayList<DataValue> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (DataValue dataValue : arrayList) {
            stringBuffer.append(dataValue.getValue());
        }
        this.setNameText(stringBuffer.toString());
    }

    private void setPronounciationText(String string) {
        this.pronounciation.setText(string);
    }

    private void setPronounciationText(ArrayList<DataValue> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (DataValue dataValue : arrayList) {
            String string = dataValue.getSubValue("pronounciation");
            if (string == null) {
                string = dataValue.getValue();
            }
            stringBuffer.append(string);
        }
        this.setPronounciationText(stringBuffer.toString());
    }

    void NameButtonActionPerformed(ActionEvent actionEvent) {
        try {
            RuleSet ruleSet;
            NameButton nameButton = (NameButton)actionEvent.getSource();
            DataElement dataElement = nameButton.getDataElement();
            dataElement.getData();
            Rule rule = this.lastRule;
            if (rule == null) {
                if (this.chkStructure.isSelected()) {
                    ruleSet = (RuleSet)this.cbCatalog.getSelectedItem();
                    rule = ruleSet.getLastRule();
                } else {
                    rule = (Rule)this.cbStructure.getSelectedItem();
                }
                this.lastRule = rule;
            }
            ruleSet = rule.getLastData();
            this.setNameText(ruleSet);
            this.setMeaningText(ruleSet);
            this.setPronounciationText(ruleSet);
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    void cbCatalogActionPerformed(ActionEvent actionEvent) {
        this.loadStructureDD();
        this.clearButtons();
    }

    void cbStructureActionPerformed(ActionEvent actionEvent) {
        this.clearButtons();
    }

    void cbCategoryActionPerformed(ActionEvent actionEvent) {
        this.loadGenderDD();
        this.loadCatalogDD();
        this.loadStructureDD();
        this.clearButtons();
    }

    void cbSexActionPerformed(ActionEvent actionEvent) {
        this.loadCatalogDD();
        this.loadStructureDD();
        this.clearButtons();
    }

    void chkStructureActionPerformed(ActionEvent actionEvent) {
        this.loadStructureDD();
    }

    private void clearButtons() {
        this.buttonPanel.removeAll();
        this.buttonPanel.repaint();
    }

    private void displayButtons(Rule rule) {
        this.clearButtons();
        for (String string : rule) {
            try {
                DataElement dataElement = this.allVars.getDataElement(string);
                if (dataElement.getTitle() == null) continue;
                NameButton nameButton = new NameButton(dataElement);
                nameButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        NameGenPanel.this.NameButtonActionPerformed(actionEvent);
                    }
                });
                this.buttonPanel.add(nameButton);
            }
            catch (Exception exception) {
                Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            }
        }
        this.buttonPanel.repaint();
    }

    void generateButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.lastRule = this.generate();
            this.displayButtons(this.lastRule);
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jLabel4 = new JLabel();
        this.cbCatalog = new JComboBox();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbCategory = new JComboBox();
        this.jPanel14 = new JPanel();
        this.jPanel11 = new JPanel();
        this.generateButton = new JButton();
        this.jPanel9 = new JPanel();
        this.jLabel5 = new JLabel();
        this.cbSex = new JComboBox();
        this.jPanel7 = new JPanel();
        this.jSeparator4 = new JSeparator();
        this.jPanel12 = new JPanel();
        this.jLabel6 = new JLabel();
        this.cbStructure = new JComboBox();
        this.chkStructure = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.meaning = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.pronounciation = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.name = new JTextField();
        this.jPanel6 = new JPanel();
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 0));
        this.jPanel13.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new FlowLayout(0));
        this.jLabel4.setText("Catalog");
        this.jPanel10.add(this.jLabel4);
        this.cbCatalog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameGenPanel.this.cbCatalogActionPerformed(actionEvent);
            }
        });
        this.jPanel10.add(this.cbCatalog);
        this.jPanel13.add((Component)this.jPanel10, "Center");
        this.jPanel8.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Category");
        this.jPanel8.add(this.jLabel1);
        this.cbCategory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameGenPanel.this.cbCategoryActionPerformed(actionEvent);
            }
        });
        this.jPanel8.add(this.cbCategory);
        this.jPanel13.add((Component)this.jPanel8, "North");
        this.jPanel4.add(this.jPanel13);
        this.jPanel14.setLayout(new BorderLayout());
        this.jPanel11.setLayout(new FlowLayout(0));
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameGenPanel.this.generateButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel11.add(this.generateButton);
        this.jPanel14.add((Component)this.jPanel11, "Center");
        this.jPanel9.setLayout(new FlowLayout(0));
        this.jLabel5.setText("Sex");
        this.jPanel9.add(this.jLabel5);
        this.cbSex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameGenPanel.this.cbSexActionPerformed(actionEvent);
            }
        });
        this.jPanel9.add(this.cbSex);
        this.jPanel14.add((Component)this.jPanel9, "North");
        this.jPanel4.add(this.jPanel14);
        this.jPanel1.add((Component)this.jPanel4, "North");
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel7.add((Component)this.jSeparator4, "North");
        this.jPanel12.setLayout(new FlowLayout(0));
        this.jLabel6.setText("Structure");
        this.jPanel12.add(this.jLabel6);
        this.cbStructure.setEnabled(false);
        this.cbStructure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameGenPanel.this.cbStructureActionPerformed(actionEvent);
            }
        });
        this.jPanel12.add(this.cbStructure);
        this.chkStructure.setSelected(true);
        this.chkStructure.setText("Random");
        this.chkStructure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameGenPanel.this.chkStructureActionPerformed(actionEvent);
            }
        });
        this.jPanel12.add(this.chkStructure);
        this.jPanel7.add((Component)this.jPanel12, "Center");
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.jPanel7.add((Component)this.buttonPanel, "South");
        this.jPanel1.add((Component)this.jPanel7, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 1));
        this.jPanel5.add(this.jSeparator2);
        this.jLabel2.setText("Meaning:");
        this.jPanel5.add(this.jLabel2);
        this.meaning.setText("Name");
        this.jPanel5.add(this.meaning);
        this.jPanel5.add(this.jSeparator1);
        this.jLabel3.setText("Pronounciation:");
        this.jPanel5.add(this.jLabel3);
        this.pronounciation.setText("nAm");
        this.jPanel5.add(this.pronounciation);
        this.jPanel5.add(this.jSeparator3);
        this.jPanel2.add((Component)this.jPanel5, "South");
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 0));
        this.name.setFont(new Font("Dialog", 1, 18));
        this.name.setText("Name");
        this.jPanel3.add(this.name);
        this.jPanel6.setLayout(new FlowLayout(2));
        this.jButton1.setIcon(IconUtilitities.getImageIcon((String)"Copy16.gif"));
        this.jButton1.setAlignmentY(0.0f);
        this.jButton1.setIconTextGap(0);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameGenPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.jButton1);
        this.jPanel3.add(this.jPanel6);
        this.jPanel2.add((Component)this.jPanel3, "North");
        this.add((Component)this.jPanel2, "North");
    }

    void jButton1ActionPerformed(ActionEvent actionEvent) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.name.getText());
        clipboard.setContents(stringSelection, stringSelection);
    }

    private void loadCatalogDD() {
        try {
            String string = (String)this.cbCategory.getSelectedItem();
            String string2 = (String)this.cbSex.getSelectedItem();
            RuleSet ruleSet = (RuleSet)this.cbCatalog.getSelectedItem();
            String string3 = "";
            if (ruleSet != null) {
                string3 = ruleSet.getTitle();
            }
            List<RuleSet> list = this.categories.get(string);
            List<RuleSet> list2 = this.categories.get("Sex: " + string2);
            ArrayList<RuleSet> arrayList = new ArrayList<RuleSet>();
            arrayList.addAll(list);
            arrayList.retainAll(list2);
            Vector<RuleSet> vector = new Vector<RuleSet>();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                RuleSet ruleSet2 = (RuleSet)arrayList.get(i);
                if (!ruleSet2.getUsage().equals("final")) continue;
                vector.add(ruleSet2);
                if (ruleSet2.getTitle().equals(string3)) {
                    n = n2;
                }
                ++n2;
            }
            Collections.sort(vector, new DataElementComperator());
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
            this.cbCatalog.setModel(defaultComboBoxModel);
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    private Vector<String> getGenderCategoryNames() {
        Vector<String> vector = new Vector<String>();
        Set<String> set = this.categories.keySet();
        for (String string : set) {
            if (!string.startsWith("Sex:")) continue;
            vector.add(string.substring(5));
        }
        return vector;
    }

    private void loadGenderDD() {
        Vector<String> vector = this.getGenderCategoryNames();
        Vector<String> vector2 = new Vector<String>();
        String string = (String)this.cbCategory.getSelectedItem();
        List<RuleSet> list = this.categories.get(string);
        block0: for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.get(i);
            List<RuleSet> list2 = this.categories.get("Sex: " + string2);
            for (int j = 0; j < list.size(); ++j) {
                if (!list2.contains(list.get(j))) continue;
                vector2.add(string2);
                continue block0;
            }
        }
        Collections.sort(vector2);
        this.cbSex.setModel(new DefaultComboBoxModel(vector2));
    }

    private void loadCategory(Element element, RuleSet ruleSet) {
        List<RuleSet> list;
        List<RuleSet> list2 = this.categories.get(element.getAttributeValue("title"));
        if (list2 == null) {
            list = new ArrayList<RuleSet>();
            this.categories.put(element.getAttributeValue("title"), list);
        } else {
            list = list2;
        }
        list.add(ruleSet);
    }

    private void loadData(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new XMLFilter());
            SAXBuilder sAXBuilder = new SAXBuilder();
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    Document document = sAXBuilder.build(fileArray[i].toURI().toURL());
                    DocType docType = document.getDocType();
                    if (docType.getElementName().equals("GENERATOR")) {
                        this.loadFromDocument(document);
                    }
                    document = null;
                    docType = null;
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "XML Error with file " + fileArray[i].getName());
                    Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
                }
            }
            this.loadDropdowns();
        } else {
            JOptionPane.showMessageDialog(this, "No data files in directory " + file.getPath());
        }
    }

    private Vector<String> getCategoryNames() {
        Vector<String> vector = new Vector<String>();
        Set<String> set = this.categories.keySet();
        for (String string : set) {
            if (string.startsWith("Sex:")) continue;
            vector.add(string);
        }
        Collections.sort(vector);
        return vector;
    }

    private void loadDropdowns() {
        Vector<String> vector = this.getCategoryNames();
        this.cbCategory.setModel(new DefaultComboBoxModel<String>(vector));
        this.loadGenderDD();
        this.loadCatalogDD();
    }

    private void loadFromDocument(Document document) throws DataConversionException {
        Element element;
        Element element2 = document.getRootElement();
        List list = element2.getChildren("RULESET");
        List list2 = element2.getChildren("LIST");
        ListIterator listIterator = list2.listIterator();
        RuleSet ruleSet = new RuleSet(this.allVars);
        while (listIterator.hasNext()) {
            element = (Element)listIterator.next();
            this.loadList(element);
        }
        element = list.listIterator();
        while (element.hasNext()) {
            Element element3 = (Element)element.next();
            ruleSet = this.loadRuleSet(element3);
            this.allVars.addDataElement(ruleSet);
        }
    }

    private String loadList(Element element) throws DataConversionException {
        DDList dDList = new DDList(this.allVars, element.getAttributeValue("title"), element.getAttributeValue("id"));
        List list = element.getChildren();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            String string = element2.getName();
            if (!string.equals("VALUE")) continue;
            WeightedDataValue weightedDataValue = new WeightedDataValue(element2.getText(), element2.getAttribute("weight").getIntValue());
            List list2 = element2.getChildren("SUBVALUE");
            ListIterator listIterator2 = list2.listIterator();
            while (listIterator2.hasNext()) {
                Element element3 = (Element)listIterator2.next();
                weightedDataValue.addSubValue(element3.getAttributeValue("type"), element3.getText());
            }
            dDList.add(weightedDataValue);
        }
        this.allVars.addDataElement(dDList);
        return dDList.getId();
    }

    private String loadRule(Element element, String string) throws DataConversionException {
        Rule rule = new Rule(this.allVars, string, string, element.getAttribute("weight").getIntValue());
        List list = element.getChildren();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            Element element2 = (Element)listIterator.next();
            String string2 = element2.getName();
            if (string2.equals("GETLIST")) {
                object = element2.getAttributeValue("idref");
                rule.add(object);
                continue;
            }
            if (string2.equals("SPACE")) {
                object = new SpaceRule();
                this.allVars.addDataElement((DataElement)object);
                rule.add(((SpaceRule)object).getId());
                continue;
            }
            if (string2.equals("HYPHEN")) {
                object = new HyphenRule();
                this.allVars.addDataElement((DataElement)object);
                rule.add(((HyphenRule)object).getId());
                continue;
            }
            if (string2.equals("CR")) {
                object = new CRRule();
                this.allVars.addDataElement((DataElement)object);
                rule.add(((CRRule)object).getId());
                continue;
            }
            if (!string2.equals("GETRULE")) continue;
            object = element2.getAttributeValue("idref");
            rule.add(object);
        }
        this.allVars.addDataElement(rule);
        return rule.getId();
    }

    private RuleSet loadRuleSet(Element element) throws DataConversionException {
        RuleSet ruleSet = new RuleSet(this.allVars, element.getAttributeValue("title"), element.getAttributeValue("id"), element.getAttributeValue("usage"));
        List list = element.getChildren();
        ListIterator listIterator = list.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            Element element2 = (Element)listIterator.next();
            String string = element2.getName();
            if (string.equals("CATEGORY")) {
                this.loadCategory(element2, ruleSet);
            } else if (string.equals("RULE")) {
                ruleSet.add(this.loadRule(element2, ruleSet.getId() + n));
            }
            ++n;
        }
        return ruleSet;
    }

    private void loadStructureDD() {
        if (this.chkStructure.isSelected()) {
            this.cbStructure.setModel(new DefaultComboBoxModel());
            this.cbStructure.setEnabled(false);
        } else {
            Vector<DataElement> vector = new Vector<DataElement>();
            for (String string : (RuleSet)this.cbCatalog.getSelectedItem()) {
                try {
                    vector.add(this.allVars.getDataElement(string));
                }
                catch (Exception exception) {
                    Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
                }
            }
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
            this.cbStructure.setModel(defaultComboBoxModel);
            this.cbStructure.setEnabled(true);
        }
    }
}

