/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import pcgen.core.SettingsHandler;
import plugin.experience.DefeatedCombatant;
import plugin.experience.ExperienceAdjusterModel;
import plugin.experience.ExperienceListItem;

public class AddDefeatedCombatant
extends JDialog {
    public ExperienceAdjusterModel model;
    private JButton bCancel;
    private JButton bSave;
    private JLabel lBuffer;
    private JLabel lCR;
    private JLabel lCR2;
    private JLabel lName;
    private JLabel lNumber;
    private JSlider sNumber;
    private JTextField tCR;
    private JTextField tName;
    private JTextField tNumber;

    public AddDefeatedCombatant(Frame frame, boolean bl, ExperienceAdjusterModel experienceAdjusterModel) {
        super(frame, bl);
        this.initComponents();
        this.setLocation(frame.getX() + 100, frame.getY() + 100);
        this.model = experienceAdjusterModel;
        int n = SettingsHandler.getGMGenOption((String)"Experience_Adjuster.dbMaxNum", (int)20);
        this.sNumber.setMaximum(n);
    }

    private void setNumber() {
        this.tNumber.setText("" + this.sNumber.getValue());
    }

    private void bCancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void bSaveActionPerformed(ActionEvent actionEvent) {
        if (this.checkNumberField(this.tNumber, 1) > 1.0f) {
            int n = 1;
            while ((float)n <= this.checkNumberField(this.tNumber, 1)) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.tName.getText().equals("")) {
                    stringBuffer.append("Defeated Enemy CR: ");
                } else {
                    stringBuffer.append(this.tName.getText() + " CR: ");
                }
                stringBuffer.append(this.checkCRField(this.tCR, 0.0f) + " ");
                stringBuffer.append("(" + n + ")");
                this.model.addEnemy(new ExperienceListItem(new DefeatedCombatant(stringBuffer.toString(), this.checkCRField(this.tCR, 0.0f))));
                ++n;
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.tName.getText().equals("")) {
                stringBuffer.append("Defeated Enemy CR: ");
            } else {
                stringBuffer.append(this.tName.getText() + " CR: ");
            }
            stringBuffer.append(this.checkCRField(this.tCR, 0.0f));
            this.model.addEnemy(new ExperienceListItem(new DefeatedCombatant(stringBuffer.toString(), this.checkCRField(this.tCR, 0.0f))));
        }
        this.setVisible(false);
        this.dispose();
    }

    private float checkCRField(JTextField jTextField, float f) {
        try {
            float f2 = Float.parseFloat(jTextField.getText());
            if ((double)f2 > 1.0) {
                f2 = (int)f2 / 1;
            }
            return f2;
        }
        catch (NumberFormatException numberFormatException) {
            jTextField.setText(Float.toString(f));
            return f;
        }
    }

    private float checkNumberField(JTextField jTextField, int n) {
        try {
            return Integer.parseInt(jTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            jTextField.setText(Integer.toString(n));
            return n;
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.lName = new JLabel();
        this.tName = new JTextField();
        this.lNumber = new JLabel();
        this.sNumber = new JSlider();
        this.bSave = new JButton();
        this.bCancel = new JButton();
        this.tNumber = new JTextField();
        this.lBuffer = new JLabel();
        this.lCR = new JLabel();
        this.lCR2 = new JLabel();
        this.tCR = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddDefeatedCombatant.this.closeDialog(windowEvent);
            }
        });
        this.lCR.setText("CR");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.getContentPane().add((Component)this.lCR, gridBagConstraints);
        this.lNumber.setText("Number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.lNumber, gridBagConstraints);
        this.lName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.lName, gridBagConstraints);
        this.lCR2.setText("(Note, use decimal fractions for CR. Ex: .5 = 1/2)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.lCR2, gridBagConstraints);
        this.lBuffer.setText("        ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 10, 0);
        this.getContentPane().add((Component)this.lBuffer, gridBagConstraints);
        this.tCR.setText("1.0");
        this.tCR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDefeatedCombatant.this.tCRActionPerformed(actionEvent);
            }
        });
        this.tCR.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AddDefeatedCombatant.this.tCRFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.tCR, gridBagConstraints);
        this.sNumber.setMaximum(20);
        this.sNumber.setMinimum(1);
        this.sNumber.setValue(1);
        this.sNumber.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AddDefeatedCombatant.this.sNumberKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                AddDefeatedCombatant.this.sNumberKeyReleased(keyEvent);
            }
        });
        this.sNumber.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AddDefeatedCombatant.this.sNumberMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                AddDefeatedCombatant.this.sNumberMouseReleased(mouseEvent);
            }
        });
        this.sNumber.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                AddDefeatedCombatant.this.sNumberMouseDragged(mouseEvent);
            }
        });
        this.sNumber.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AddDefeatedCombatant.this.sNumberPropertyChange(propertyChangeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.sNumber, gridBagConstraints);
        this.tNumber.setText("1");
        this.tNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDefeatedCombatant.this.tNumberActionPerformed(actionEvent);
            }
        });
        this.tNumber.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AddDefeatedCombatant.this.tNumberFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.tNumber, gridBagConstraints);
        this.tName.setMinimumSize(new Dimension(100, 21));
        this.tName.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.tName, gridBagConstraints);
        this.bSave.setText("Save");
        this.bSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDefeatedCombatant.this.bSaveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.getContentPane().add((Component)this.bSave, gridBagConstraints);
        this.bCancel.setText("Cancel");
        this.bCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDefeatedCombatant.this.bCancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.bCancel, gridBagConstraints);
        this.pack();
    }

    private void sNumberKeyPressed(KeyEvent keyEvent) {
        this.setNumber();
    }

    private void sNumberKeyReleased(KeyEvent keyEvent) {
        this.setNumber();
    }

    private void sNumberMouseDragged(MouseEvent mouseEvent) {
        this.setNumber();
    }

    private void sNumberMousePressed(MouseEvent mouseEvent) {
        this.setNumber();
    }

    private void sNumberMouseReleased(MouseEvent mouseEvent) {
        this.setNumber();
    }

    private void sNumberPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setNumber();
    }

    private void tCRActionPerformed(ActionEvent actionEvent) {
        this.tCR.setText(Float.toString(this.checkCRField(this.tCR, 1.0f)));
    }

    private void tCRFocusLost(FocusEvent focusEvent) {
        this.tCR.setText(Float.toString(this.checkCRField(this.tCR, 1.0f)));
    }

    private void tNumberActionPerformed(ActionEvent actionEvent) {
        this.checkNumberField(this.tNumber, 1);
    }

    private void tNumberFocusLost(FocusEvent focusEvent) {
        this.checkNumberField(this.tNumber, 1);
    }
}

