/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.AbilityRef;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<AbilitySelection> {
    private static final Class<AbilitySelection> ABILITY_SELECTION_CLASS = AbilitySelection.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "ABILITY";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        Serializable serializable;
        PersistentTransitionChoice persistentTransitionChoice;
        AbilityRefChoiceSet abilityRefChoiceSet;
        String string2;
        Formula formula;
        String string3;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        if (n == 4) {
            string3 = stringTokenizer.nextToken();
            formula = FormulaFactory.getFormulaFor((String)string3);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
        } else if (n == 3) {
            formula = FormulaFactory.ONE;
        } else {
            Logging.log((Level)Logging.LST_ERROR, (String)("Syntax of ADD:" + this.getTokenName() + " requires three | when a count is not present: " + string));
            return false;
        }
        string3 = stringTokenizer.nextToken();
        Category category = loadContext.ref.getCategoryFor(ABILITY_CLASS, string3);
        if (category == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + ": Invalid ability category: " + string3));
            return false;
        }
        String string4 = stringTokenizer.nextToken();
        Ability.Nature nature = Ability.Nature.valueOf((String)string4);
        if (nature == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + ": Invalid ability nature: " + string4));
            return false;
        }
        if (Ability.Nature.ANY.equals((Object)nature)) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " refers to ANY Ability Nature, cannot be used in " + this.getTokenName() + ": " + string));
            return false;
        }
        if (Ability.Nature.AUTOMATIC.equals((Object)nature)) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " refers to AUTOMATIC Ability Nature, cannot be used in " + this.getTokenName() + ": " + string));
            return false;
        }
        String string5 = stringTokenizer.nextToken();
        if (this.isEmpty(string5) || this.hasIllegalSeparator(',', string5)) {
            Logging.log((Level)Logging.LST_ERROR, (String)"!!");
            return false;
        }
        ArrayList<PersistentTransitionChoice> arrayList = new ArrayList<PersistentTransitionChoice>();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ",");
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (stringTokenizer2.hasMoreTokens()) {
            string2 = stringTokenizer2.nextToken();
            if ("STACKS".equals(string2)) {
                if (bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " found second stacking specification in value: " + string));
                    return false;
                }
                bl = true;
                continue;
            }
            if (string2.startsWith("STACKS=")) {
                if (bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " found second stacking specification in value: " + string));
                    return false;
                }
                bl = true;
                try {
                    n2 = Integer.parseInt(string2.substring(7));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("Invalid Stack number in " + this.getFullName() + ": " + string));
                    return false;
                }
                if (n2 > 0) continue;
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid (less than 1) Stack number in " + this.getFullName() + ": " + string));
                return false;
            }
            if ("ALL".equals(string2)) {
                bl2 = true;
                abilityRefChoiceSet = loadContext.ref.getCDOMAllReference(ABILITY_CLASS, category);
            } else {
                bl3 = true;
                abilityRefChoiceSet = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)category, (String)string2);
            }
            if (abilityRefChoiceSet == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("  Error was encountered while parsing " + this.getTokenName() + ": " + string + " had an invalid reference: " + string2));
                return false;
            }
            persistentTransitionChoice = new AbilityRef((CDOMReference)abilityRefChoiceSet);
            arrayList.add(persistentTransitionChoice);
            if (string2.indexOf(40) == -1) continue;
            serializable = new ArrayList();
            AbilityUtilities.getUndecoratedName((String)string2, (Collection)((Object)serializable));
            if (serializable.size() != 1) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid use of multiple items in parenthesis (comma prohibited) in " + this.getFullName() + ": " + string2));
                return false;
            }
            persistentTransitionChoice.setChoice((String)serializable.get(0));
        }
        if (bl2 && bl3) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        if (arrayList.isEmpty()) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains no ability reference: " + string));
            return false;
        }
        abilityRefChoiceSet = new AbilityRefChoiceSet(category, arrayList, nature);
        string2 = new ChoiceSet.AbilityChoiceSet(this.getTokenName(), abilityRefChoiceSet);
        persistentTransitionChoice = new PersistentTransitionChoice((ChoiceSet)string2, formula);
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.ADD, (Object)persistentTransitionChoice);
        serializable = new StringBuilder();
        if (!Ability.Nature.NORMAL.equals((Object)nature)) {
            ((StringBuilder)serializable).append(nature.toString());
            ((StringBuilder)serializable).append(' ');
        }
        ((StringBuilder)serializable).append(category.getDisplayName());
        ((StringBuilder)serializable).append(" Choice");
        persistentTransitionChoice.setTitle(((StringBuilder)serializable).toString());
        persistentTransitionChoice.allowStack(bl);
        if (n2 != 0) {
            persistentTransitionChoice.setStackLimit(n2);
        }
        persistentTransitionChoice.setChoiceActor((ChoiceActor)this);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.ADD);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!this.getTokenName().equals(choiceSet.getName()) || !ABILITY_SELECTION_CLASS.equals(choiceSet.getChoiceClass())) continue;
            ChoiceSet.AbilityChoiceSet abilityChoiceSet = (ChoiceSet.AbilityChoiceSet)choiceSet;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            stringBuilder.append(abilityChoiceSet.getCategory().getKeyName());
            stringBuilder.append("|");
            stringBuilder.append(abilityChoiceSet.getNature());
            stringBuilder.append("|");
            if (persistentTransitionChoice.allowsStacking()) {
                stringBuilder.append("STACKS");
                int n = persistentTransitionChoice.getStackLimit();
                if (n != 0) {
                    stringBuilder.append("=");
                    stringBuilder.append(persistentTransitionChoice.getStackLimit());
                }
                stringBuilder.append(",");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject cDOMObject, AbilitySelection abilitySelection, PlayerCharacter playerCharacter) {
        Ability ability = abilitySelection.getAbility();
        String string = abilitySelection.getSelection();
        AbilityCategory abilityCategory = (AbilityCategory)abilitySelection.getAbilityCategory();
        boolean bl = Ability.Nature.VIRTUAL.equals((Object)abilitySelection.getNature());
        AbilityUtilities.applyAbility((PlayerCharacter)playerCharacter, null, (AbilityCategory)abilityCategory, (Ability)ability, (String)string, (boolean)bl);
        playerCharacter.addAssociation((CDOMObject)ability, string);
    }

    public boolean allow(AbilitySelection abilitySelection, PlayerCharacter playerCharacter, boolean bl) {
        boolean bl2 = Ability.Nature.VIRTUAL.equals((Object)abilitySelection.getNature());
        for (Ability ability : playerCharacter.getAllAbilities()) {
            if (!ability.getKeyName().equals(abilitySelection.getAbilityKey()) || playerCharacter.canSelectAbility(ability, bl2) && ((Visibility)ability.getSafe(ObjectKey.VISIBILITY)).equals((Object)Visibility.DEFAULT) && (this.allowStack(ability, bl) || !this.hasAssoc(playerCharacter.getAssociationList((CDOMObject)ability), abilitySelection))) continue;
            return false;
        }
        return true;
    }

    private boolean hasAssoc(List<String> list, AbilitySelection abilitySelection) {
        if (list == null) {
            return false;
        }
        for (String string : list) {
            if (!abilitySelection.containsAssociation(string)) continue;
            return true;
        }
        return false;
    }

    private boolean allowStack(Ability ability, boolean bl) {
        return (Boolean)ability.getSafe(ObjectKey.STACKS) != false && bl;
    }

    public AbilitySelection decodeChoice(String string) {
        return AbilitySelection.getAbilitySelectionFromPersistentFormat((String)string);
    }

    public String encodeChoice(Object object) {
        return ((AbilitySelection)object).getPersistentFormat();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
        AbilityUtilities.modAbility((PlayerCharacter)playerCharacter, null, (Ability)abilitySelection.getAbility(), (String)abilitySelection.getSelection(), (boolean)false, (AbilityCategory)((AbilityCategory)abilitySelection.getAbilityCategory()));
    }
}

