/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractSpellListToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellknownLst
extends AbstractSpellListToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "SPELLKNOWN";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        String string2;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        String string3 = string;
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        while (true) {
            int n;
            if ((n = string3.lastIndexOf(124)) == -1) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid " + this.getTokenName() + " not enough tokens: " + string));
                return false;
            }
            string2 = string3.substring(n + 1);
            if (!string2.startsWith("PRE") && !string2.startsWith("!PRE")) break;
            string3 = string3.substring(0, n);
            arrayList.add(this.getPrerequisite(string2));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        if (stringTokenizer.countTokens() < 3) {
            Logging.errorPrint((String)("Insufficient values in SPELLKNOWN tag: " + string));
            return false;
        }
        string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("CLASS")) {
                if (this.subParse(loadContext, cDOMObject, ClassSpellList.class, string4, string5, arrayList)) continue;
                Logging.log((Level)Logging.LST_ERROR, (String)("  " + this.getTokenName() + " error - entire token was " + string));
                return false;
            }
            Logging.errorPrint((String)("First token of " + this.getTokenName() + " must be CLASS: " + string));
            return false;
        }
        return true;
    }

    private <CL extends CDOMObject> boolean subParse(LoadContext loadContext, CDOMObject cDOMObject, Class<CL> clazz, String string, String string2, List<Prerequisite> list) {
        Object object;
        Object object2;
        Integer n;
        int n2 = string.indexOf("=");
        if (n2 == -1) {
            Logging.errorPrint((String)("Expected an = in SPELLKNOWN definition: " + string));
            return false;
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        try {
            n = Integer.decode(string4);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Expected a number for SPELLKNOWN, found: " + string4));
            return false;
        }
        if (this.isEmpty(string3) || this.hasIllegalSeparator(',', string3)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        ArrayList<CDOMSingleRef> arrayList = new ArrayList<CDOMSingleRef>();
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            object = ((String)object2).startsWith("SPELLCASTER.") ? loadContext.ref.getCDOMTypeReference(clazz, new String[]{((String)object2).substring(12)}) : loadContext.ref.getCDOMReference(clazz, (String)object2);
            arrayList.add((CDOMSingleRef)object);
        }
        if (this.hasIllegalSeparator(',', string2)) {
            return false;
        }
        object2 = new StringTokenizer(string2, ",");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(Spell.class, (String)object);
            for (CDOMReference cDOMReference : arrayList) {
                AssociatedPrereqObject associatedPrereqObject = loadContext.getListContext().addToList(this.getTokenName(), cDOMObject, cDOMReference, (CDOMReference)cDOMSingleRef);
                associatedPrereqObject.setAssociation(AssociationKey.SPELL_LEVEL, (Object)n);
                associatedPrereqObject.setAssociation(AssociationKey.KNOWN, (Object)Boolean.TRUE);
                associatedPrereqObject.addAllPrerequisites(list);
            }
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Collection collection = loadContext.getListContext().getChangedLists(cDOMObject, ClassSpellList.class);
        TripleKeyMapToList tripleKeyMapToList = this.getMap(loadContext, cDOMObject, collection, true);
        for (String string : tripleKeyMapToList.getKeySet()) {
            treeSet.add(this.processUnparse("CLASS", tripleKeyMapToList, string).toString());
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

