/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellsToken
implements CDOMSecondaryToken<CDOMObject> {
    public String getTokenName() {
        return "SPELLS";
    }

    public String getParentToken() {
        return "CHOOSE";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        CharSequence charSequence;
        if (string == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)("CHOOSE:" + this.getTokenName() + " requires additional arguments"));
            return false;
        }
        if (string.charAt(0) == '|') {
            Logging.log((Level)Logging.LST_ERROR, (String)("CHOOSE:" + this.getTokenName() + " arguments may not start with | : " + string));
            return false;
        }
        if (string.charAt(string.length() - 1) == '|') {
            Logging.log((Level)Logging.LST_ERROR, (String)("CHOOSE:" + this.getTokenName() + " arguments may not end with | : " + string));
            return false;
        }
        if (string.indexOf("||") != -1) {
            Logging.log((Level)Logging.LST_ERROR, (String)("CHOOSE:" + this.getTokenName() + " arguments uses double separator || : " + string));
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer((String)charSequence, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer2.nextToken();
                if (string3.startsWith("DOMAIN=") || string3.startsWith("DOMAIN.")) {
                    Logging.deprecationPrint((String)"DOMAIN is deprecated in CHOOSE:SPELLS, please use DOMAINLIST=x");
                    continue;
                }
                if (string3.startsWith("CLASS=") || string3.startsWith("CLASS.")) {
                    Logging.deprecationPrint((String)"CLASS is deprecated in CHOOSE:SPELLS, please use CLASSLIST=x");
                    continue;
                }
                if (string3.startsWith("DOMAINLIST=")) {
                    int n = string3.indexOf(91);
                    if (n == -1) {
                        if (string3.length() >= 12) continue;
                        Logging.log((Level)Logging.LST_ERROR, (String)"Invalid DOMAINLIST= entry for CHOOSE:SPELLS: requires a domain name");
                        return false;
                    }
                    if (!string3.endsWith("]")) {
                        Logging.log((Level)Logging.LST_ERROR, (String)("Invalid entry in CHOOSE:SPELLS: " + string3 + " did not have matching brackets"));
                        return false;
                    }
                    string2 = string3.substring(11, n);
                    if (string2 == null || string2.length() == 0) {
                        Logging.log((Level)Logging.LST_ERROR, (String)"Invalid DOMAINLIST= entry for CHOOSE:SPELLS: requires a domain name");
                        return false;
                    }
                    this.validateRestriction(string3.substring(n + 1, string3.length() - 1));
                    continue;
                }
                if (string3.startsWith("CLASSLIST=")) {
                    int n = string3.indexOf(91);
                    if (n == -1) {
                        if (string3.length() >= 10) continue;
                        Logging.log((Level)Logging.LST_ERROR, (String)"Invalid CLASSLIST= entry for CHOOSE:SPELLS: requires a class name");
                        return false;
                    }
                    if (!string3.endsWith("]")) {
                        Logging.log((Level)Logging.LST_ERROR, (String)("Invalid entry in CHOOSE:SPELLS: " + string3 + " did not have matching brackets"));
                        return false;
                    }
                    string2 = string3.substring(10, n);
                    if (string2 == null || string2.length() == 0) {
                        Logging.log((Level)Logging.LST_ERROR, (String)"Invalid CLASSLIST= entry for CHOOSE:SPELLS: requires a class name");
                        return false;
                    }
                    this.validateRestriction(string3.substring(n + 1, string3.length() - 1));
                    continue;
                }
                if (string3.startsWith("SPELLTYPE=")) {
                    int n = string3.indexOf(91);
                    if (n == -1) {
                        if (string3.length() >= 10) continue;
                        Logging.log((Level)Logging.LST_ERROR, (String)"Invalid SPELLTYPE= entry for CHOOSE:SPELLS: requires a spell type");
                        return false;
                    }
                    if (!string3.endsWith("]")) {
                        Logging.log((Level)Logging.LST_ERROR, (String)("Invalid entry in CHOOSE:SPELLS: " + string3 + " did not have matching brackets"));
                        return false;
                    }
                    string2 = string3.substring(10, n);
                    if (string2 == null || string2.length() == 0) {
                        Logging.log((Level)Logging.LST_ERROR, (String)"Invalid SPELLTYPE= entry for CHOOSE:SPELLS: requires a spell type");
                        return false;
                    }
                    this.validateRestriction(string3.substring(n + 1, string3.length() - 1));
                    continue;
                }
                if (string3.startsWith("ANY")) {
                    int n = string3.indexOf(91);
                    if (n > -1 && n != 3) {
                        Logging.log((Level)Logging.LST_ERROR, (String)"Invalid ANY entry for CHOOSE:SPELLS, bracket must immediately follow 'ANY'");
                        return false;
                    }
                    if (!string3.endsWith("]")) {
                        Logging.log((Level)Logging.LST_ERROR, (String)("Invalid entry in CHOOSE:SPELLS: " + string3 + " did not have matching brackets"));
                        return false;
                    }
                    this.validateRestriction(string3.substring(n + 1, string3.length() - 1));
                    continue;
                }
                if (string3.startsWith("SCHOOL=")) {
                    if (string3.length() >= 8) continue;
                    Logging.log((Level)Logging.LST_ERROR, (String)"Invalid SCHOOL= entry for CHOOSE:SPELLS: requires a school name");
                    return false;
                }
                if (string3.startsWith("SUBSCHOOL=")) {
                    if (string3.length() >= 11) continue;
                    Logging.log((Level)Logging.LST_ERROR, (String)"Invalid SUBSCHOOL= entry for CHOOSE:SPELLS: requires a subschool name");
                    return false;
                }
                if (string3.startsWith("DESCRIPTOR=")) {
                    if (string3.length() >= 12) continue;
                    Logging.log((Level)Logging.LST_ERROR, (String)"Invalid DESCRIPTOR= entry for CHOOSE:SPELLS: requires a descriptor name");
                    return false;
                }
                if (string3.startsWith("SPELLBOOK=")) {
                    if (string3.length() >= 11) continue;
                    Logging.log((Level)Logging.LST_ERROR, (String)"Invalid SPELLBOOK= entry for CHOOSE:SPELLS: requires a spellbook name");
                    return false;
                }
                if (string3.startsWith("PROHIBITED=")) {
                    String string4 = string3.substring(11);
                    if ("YES".equals(string4) || "NO".equals(string4)) continue;
                    Logging.log((Level)Logging.LST_ERROR, (String)"Invalid PROHIBITED= entry for CHOOSE:SPELLS: must be YES or NO");
                    return false;
                }
                if (string3.startsWith("TYPE=") || string3.startsWith("TYPE.")) {
                    if (string3.length() >= 6) continue;
                    Logging.log((Level)Logging.LST_ERROR, (String)"Invalid TYPE= entry for CHOOSE:SPELLS: requires a type name");
                    return false;
                }
                if (string3.indexOf(91) == -1 && string3.indexOf(61) == -1) continue;
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid (unknown) entry: " + string3 + " for " + "CHOOSE:SPELLS:"));
                return false;
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.getTokenName()).append('|').append(string);
        loadContext.obj.put(cDOMObject, StringKey.CHOICE_STRING, ((StringBuilder)charSequence).toString());
        return true;
    }

    private void validateRestriction(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("LEVELMAX=") || string2.startsWith("LEVELMIN=") || "KNOWN=YES".equals(string2) || "KNOWN=NO".equals(string2)) continue;
            Logging.log((Level)Logging.LST_ERROR, (String)("Unknown restriction: " + string2 + " in CHOOSE:SPELLS"));
        }
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        String string = loadContext.getObjectContext().getString(cDOMObject, StringKey.CHOICE_STRING);
        if (string == null || string.indexOf(this.getTokenName() + '|') == -1) {
            return null;
        }
        return new String[]{string.substring(this.getTokenName().length() + 1)};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

