/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.logging;

import com.vladium.logging.ILogLevels;
import com.vladium.logging.LoggerInit;
import com.vladium.util.ClassLoaderResolver;
import java.io.PrintWriter;
import java.util.Set;

public abstract class Logger
implements ILogLevels {
    private static final int LEVEL = LoggerInit.s_level;
    private static final PrintWriter OUT = LoggerInit.s_out;
    private static final Set CLASS_MASK = LoggerInit.s_classMask;
    private static final String PREFIX = LoggerInit.s_prefix;
    private static final String PREFIX_TO_STRIP = "com.vladium.";
    private static final int PREFIX_TO_STRIP_LENGTH = "com.vladium.".length();
    private static final boolean FLUSH_LOG = true;

    public static PrintWriter getWriter() {
        return OUT;
    }

    public static boolean isLoggable(int level) {
        return level <= LEVEL;
    }

    public static boolean atVERBOSE() {
        return 3 <= LEVEL;
    }

    public static boolean atTRACE1() {
        return 4 <= LEVEL;
    }

    public static boolean atTRACE2() {
        return 5 <= LEVEL;
    }

    public static boolean atTRACE3() {
        return 6 <= LEVEL;
    }

    public static void warning(String msg) {
        Logger._log(1, null, msg, false);
    }

    public static void info(String msg) {
        Logger._log(2, null, msg, false);
    }

    public static void info(String method, String msg) {
        Logger._log(2, method, msg, false);
    }

    public static void verbose(String msg) {
        Logger._log(3, null, msg, false);
    }

    public static void trace1(String method, String msg) {
        Logger._log(4, method, msg, true);
    }

    public static void trace2(String method, String msg) {
        Logger._log(5, method, msg, true);
    }

    public static void trace3(String method, String msg) {
        Logger._log(6, method, msg, true);
    }

    public static void log(int level, String msg, boolean logCaller) {
        Logger._log(level, null, msg, logCaller);
    }

    public static void log(int level, String method, String msg, boolean logCaller) {
        Logger._log(level, method, msg, logCaller);
    }

    public static void log(int level, String msg, Throwable throwable) {
        Logger._log(level, null, msg, throwable);
    }

    public static void log(int level, String method, String msg, Throwable throwable) {
        Logger._log(level, method, msg, throwable);
    }

    private Logger() {
    }

    private static void _log(int level, String method, String msg, boolean logCaller) {
        if (level <= LEVEL && level >= 0) {
            PrintWriter out = OUT;
            Class caller = logCaller ? ClassLoaderResolver.getCallerClass(2) : null;
            StringBuffer buf = null;
            if (caller != null || method != null) {
                buf = new StringBuffer("[");
                if (caller != null) {
                    String callerName = caller.getName();
                    if (callerName.startsWith(PREFIX_TO_STRIP)) {
                        callerName = callerName.substring(PREFIX_TO_STRIP_LENGTH);
                    }
                    String parentName = callerName;
                    int firstDollar = callerName.indexOf(36);
                    if (firstDollar > 0) {
                        parentName = callerName.substring(0, firstDollar);
                    }
                    if (CLASS_MASK == null || CLASS_MASK.contains(parentName)) {
                        buf.append(callerName);
                    } else {
                        return;
                    }
                }
                if (method != null) {
                    buf.append("::");
                    buf.append(method);
                }
                buf.append("] ");
            }
            if (PREFIX != null) {
                out.print(PREFIX);
            }
            if (buf != null) {
                if (msg != null) {
                    buf.append(msg);
                }
                out.println(buf);
            } else if (msg != null) {
                out.println(msg);
            } else {
                out.println();
            }
            out.flush();
        }
    }

    private static void _log(int level, String method, String msg, Throwable throwable) {
        if (level <= LEVEL && level >= 0) {
            PrintWriter out = OUT;
            Class caller = ClassLoaderResolver.getCallerClass(2);
            StringBuffer buf = null;
            if (caller != null || method != null) {
                buf = new StringBuffer("[");
                if (caller != null) {
                    String callerName = caller.getName();
                    if (callerName.startsWith(PREFIX_TO_STRIP)) {
                        callerName = callerName.substring(PREFIX_TO_STRIP_LENGTH);
                    }
                    String parentName = callerName;
                    int firstDollar = callerName.indexOf(36);
                    if (firstDollar > 0) {
                        parentName = callerName.substring(0, firstDollar);
                    }
                    if (CLASS_MASK == null || CLASS_MASK.contains(parentName)) {
                        buf.append(callerName);
                    } else {
                        return;
                    }
                }
                if (method != null) {
                    buf.append("::");
                    buf.append(method);
                }
                buf.append("] ");
            }
            if (PREFIX != null) {
                out.print(PREFIX);
            }
            if (buf != null) {
                if (msg != null) {
                    buf.append(msg);
                }
                out.println(buf);
            } else if (msg != null) {
                out.println(msg);
            } else {
                out.println();
            }
            if (throwable != null) {
                throwable.printStackTrace(out);
            }
            out.flush();
        }
    }
}

