/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.PCTemplate;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonppToken
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "NONPP";
    }

    public boolean parse(LoadContext loadContext, PCTemplate pCTemplate, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n > 0) {
                Logging.errorPrint((String)("Non-Proficiency Penalty must be less than or equal to zero: " + string));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)pCTemplate, IntegerKey.NONPP, n);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Non-Proficiency Penalty must be a number less than or equal to zero: " + string));
            return false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCTemplate pCTemplate) {
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)pCTemplate, IntegerKey.NONPP);
        if (n == null) {
            return null;
        }
        if (n > 0) {
            loadContext.addWriteMessage("Non-Proficiency Penalty must be less than or equal to zero: " + n);
            return null;
        }
        return new String[]{n.toString()};
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

