/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.ExtendedHTMLDocument;
import gmgen.gui.ExtendedHTMLEditorKit;
import gmgen.plugin.Combatant;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.util.LogReceiver;
import gmgen.util.LogUtilities;
import gmgen.util.MiscUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import pcgen.core.SettingsHandler;
import plugin.network.NetworkClient;
import plugin.network.NetworkCombatant;
import plugin.network.NetworkServer;
import plugin.network.gui.NetworkView;

public class NetworkModel {
    private NetworkView view = new NetworkView();
    static List<Color> colorList = new ArrayList<Color>();
    private NetworkServer server;
    private NetworkClient client;
    private InitHolderList combat;
    private HashMap<String, Combatant> sentCombatants = new HashMap();
    private HashMap<String, NetworkCombatant> recievedCombatants = new HashMap();

    public NetworkModel() {
        this.applyPrefs();
        this.initLogging();
        this.initView();
        this.addListeners();
    }

    public NetworkView getView() {
        return this.view;
    }

    public void closeWindow() {
    }

    public void applyPrefs() {
    }

    public void handleServerPcgMessage(String string, String string2, Socket socket) {
        if (this.sentCombatants.containsKey(string)) {
            Combatant combatant = this.sentCombatants.get(string);
            NetworkCombatant.recieveServerMessage(string2, combatant);
        }
    }

    public void handlePcgMessage(String string, String string2, Socket socket) {
        if (this.recievedCombatants.containsKey(string)) {
            NetworkCombatant networkCombatant = this.recievedCombatants.get(string);
            networkCombatant.recieveNetMessage(string2);
        } else {
            NetworkCombatant networkCombatant = new NetworkCombatant(string, socket);
            networkCombatant.recieveNetMessage(string2);
            this.recievedCombatants.put(string, networkCombatant);
            this.combat.add((InitHolder)networkCombatant);
        }
    }

    public void sendCombatant(Combatant combatant) {
        String string = SettingsHandler.getGMGenOption((String)"Network.username", (String)"Player");
        if (this.client != null) {
            this.sentCombatants.put(NetworkCombatant.getCombatantUid(combatant, string), combatant);
            NetworkCombatant.sendCombatant(combatant, this.client);
        }
    }

    public void combatantUpdated(Combatant combatant) {
        if (this.combat != null) {
            for (InitHolder initHolder : this.combat) {
                if (initHolder != combatant) continue;
                this.sendCombatant(combatant);
            }
        }
    }

    private void initView() {
        this.view.getClientRadioButton().setSelected(true);
        this.view.hideLocalPanel();
        this.view.getServerAddressTextField().setText(SettingsHandler.getGMGenOption((String)"Network.ipAddress", (String)"0.0.0.0"));
        this.initList();
    }

    private void initList() {
        this.view.getUserList().setModel(new DefaultListModel());
        this.addUser("Broadcast");
    }

    private void addListeners() {
        this.view.getServerRadioButton().addActionListener(new RadioActionListener());
        this.view.getClientRadioButton().addActionListener(new RadioActionListener());
        this.view.getConnectButton().addActionListener(new ConnectionButtonActionListener());
        this.view.getLogPane().addFocusListener(new TabFocusListener());
        this.view.getMessageButton().addActionListener(new MessageButtonActionListener());
    }

    private void displayClientToolbar() {
        this.view.showClientPanel();
        this.view.hideLocalPanel();
        this.view.showConnectionPanel();
    }

    private void displayServerToolbar() {
        this.view.showLocalPanel();
        this.view.hideClientPanel();
    }

    private void startServer() {
        this.server = new NetworkServer(this);
        this.server.start();
    }

    private void stopServer() {
        if (this.server != null) {
            NetworkServer networkServer = null;
            ThreadGroup threadGroup = this.server.getThreadGroup();
            if (threadGroup != null) {
                Thread[] threadArray = new Thread[threadGroup.activeCount()];
                threadGroup.enumerate(threadArray);
                for (Thread thread : threadArray) {
                    if (thread instanceof NetworkServer) {
                        networkServer = (NetworkServer)thread;
                        continue;
                    }
                    if (!(thread instanceof NetworkServer.Handler)) continue;
                    ((NetworkServer.Handler)thread).setRun(false);
                }
                if (networkServer != null) {
                    networkServer.setRun(false);
                }
            }
        }
        this.server = null;
        this.log("Local", "Local", "Server Shut Down");
        this.initList();
    }

    private void startClient() {
        this.view.getConnectButton().setText("Disconnect");
        this.client = new NetworkClient(this);
        this.client.startClient();
    }

    private void stopClient() {
        if (this.client != null) {
            this.client.sendExitMessage();
        }
    }

    public void resetClient() {
        this.client = null;
        this.view.getConnectButton().setText("Connect");
        this.getView().setConnectionText("Client Status", "Disconnected from Server");
        this.initList();
    }

    private void initLogging() {
        LogUtilities.inst().addReceiver((LogReceiver)new NetworkLogReciever());
        JTabbedPane jTabbedPane = this.view.getLogPane();
        JTextPane jTextPane = new JTextPane();
        ExtendedHTMLEditorKit extendedHTMLEditorKit = new ExtendedHTMLEditorKit();
        jTextPane.setEditorKit((EditorKit)extendedHTMLEditorKit);
        ExtendedHTMLDocument extendedHTMLDocument = (ExtendedHTMLDocument)extendedHTMLEditorKit.createDefaultDocument();
        extendedHTMLDocument.putProperty((Object)"number", (Object)0);
        jTabbedPane.add("Logs", new JScrollPane(jTextPane));
        JTextPane jTextPane2 = new JTextPane();
        EditorKit editorKit = jTextPane2.getEditorKit();
        Document document = editorKit.createDefaultDocument();
        document.putProperty("number", 1);
    }

    public void log(String string, String string2) {
        JTextPane jTextPane = this.getLogPane("Logs");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh.mm.ss a z");
        ExtendedHTMLDocument extendedHTMLDocument = (ExtendedHTMLDocument)jTextPane.getDocument();
        int n = this.getUserNumber(string);
        Color color = this.getLineColor(n);
        try {
            extendedHTMLDocument.insertAfterEnd(extendedHTMLDocument.getCharacterElement(extendedHTMLDocument.getLength()), "<br>\n<b>" + simpleDateFormat.format(Calendar.getInstance().getTime()) + " <font color='" + MiscUtilities.colorToHex((Color)color) + "'>" + string + "</b></font>: " + string2);
            this.setPaneIcon();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void log(String string, String string2, String string3) {
        JTextPane jTextPane = this.getLogPane("Logs");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh.mm.ss a z");
        ExtendedHTMLDocument extendedHTMLDocument = (ExtendedHTMLDocument)jTextPane.getDocument();
        int n = this.getUserNumber(string);
        Color color = this.getLineColor(n);
        try {
            extendedHTMLDocument.insertAfterEnd(extendedHTMLDocument.getCharacterElement(extendedHTMLDocument.getLength()), "<br>\n<b>" + simpleDateFormat.format(Calendar.getInstance().getTime()) + " <font color='" + MiscUtilities.colorToHex((Color)color) + "'>" + string + "</b></font> " + string2 + ": " + string3);
            this.setPaneIcon();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getUserNumber(String string) {
        JList jList = this.view.getUserList();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        if (defaultListModel.contains(string)) {
            return defaultListModel.indexOf(string);
        }
        return 0;
    }

    public void addUser(String string) {
        JList jList = this.view.getUserList();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        if (!defaultListModel.contains(string)) {
            defaultListModel.addElement(string);
        }
    }

    public void removeUser(String string) {
        JList jList = this.view.getUserList();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        defaultListModel.removeElement(string);
    }

    public String getSelectedUser() {
        JList jList = this.view.getUserList();
        return jList.getSelectedValue().toString();
    }

    private Color getLineColor(int n) {
        return colorList.get(n >= colorList.size() ? n % colorList.size() : n);
    }

    private JTextPane getLogPane(String string) {
        JTabbedPane jTabbedPane = this.view.getLogPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!jTabbedPane.getTitleAt(i).equals(string)) continue;
            return (JTextPane)((JScrollPane)jTabbedPane.getComponent(i)).getViewport().getView();
        }
        JTextPane jTextPane = new JTextPane();
        EditorKit editorKit = jTextPane.getEditorKit();
        editorKit.createDefaultDocument();
        jTabbedPane.add(string, new JScrollPane(jTextPane));
        return jTextPane;
    }

    public void setPaneIcon() {
        JTabbedPane jTabbedPane = this.view.getLogPane();
        JTabbedPane jTabbedPane2 = GMGenSystemView.getTabPane();
        if (jTabbedPane2.getSelectedComponent() instanceof NetworkView && GMGenSystem.inst.isFocused()) {
            return;
        }
        jTabbedPane.setIconAt(jTabbedPane.indexOfTab("Logs"), new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/NewEnvelope.gif")));
        if (!(jTabbedPane2.getSelectedComponent() instanceof NetworkView)) {
            int n = jTabbedPane2.indexOfComponent(this.view);
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/NewEnvelope.gif"));
            jTabbedPane2.setIconAt(n, imageIcon);
        }
    }

    public void clearIcon() {
        JTabbedPane jTabbedPane = this.view.getLogPane();
        jTabbedPane.setIconAt(jTabbedPane.getSelectedIndex(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage() {
        try {
            if (this.server != null) {
                this.server.sendIM("GM", this.getSelectedUser(), this.view.getMessageTextField().getText());
            } else if (this.client != null) {
                if (this.getSelectedUser().equals("Broadcast")) {
                    this.client.sendBroadcast(this.view.getMessageTextField().getText());
                } else {
                    this.client.sendIM(this.getSelectedUser(), this.view.getMessageTextField().getText());
                }
            }
        }
        finally {
            this.view.getMessageTextField().setText("");
        }
    }

    public void setCombat(InitHolderList initHolderList) {
        this.combat = initHolderList;
    }

    public InitHolderList getCombat() {
        return this.combat;
    }

    public void refresh() {
        if (this.combat != null) {
            for (InitHolder initHolder : this.combat) {
                if (!(initHolder instanceof Combatant)) continue;
                this.sendCombatant((Combatant)initHolder);
            }
        }
    }

    static {
        colorList.add(Color.BLACK);
        colorList.add(Color.BLUE);
        colorList.add(Color.RED);
        colorList.add(Color.GREEN);
        colorList.add(Color.DARK_GRAY);
        colorList.add(Color.ORANGE);
        colorList.add(Color.CYAN);
        colorList.add(Color.MAGENTA);
        colorList.add(Color.LIGHT_GRAY);
        colorList.add(Color.YELLOW);
        colorList.add(Color.GRAY);
        colorList.add(Color.PINK);
    }

    private class MessageButtonActionListener
    implements ActionListener {
        private MessageButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkModel.this.sendMessage();
        }
    }

    private class TabFocusListener
    implements FocusListener {
        private TabFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            NetworkModel.this.clearIcon();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class ConnectionButtonActionListener
    implements ActionListener {
        private ConnectionButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NetworkModel.this.client == null) {
                NetworkModel.this.startClient();
            } else {
                NetworkModel.this.stopClient();
            }
        }
    }

    private class RadioActionListener
    implements ActionListener {
        private RadioActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NetworkModel.this.view.getServerRadioButton().isSelected()) {
                NetworkModel.this.displayServerToolbar();
                NetworkModel.this.startServer();
            } else {
                try {
                    NetworkModel.this.stopServer();
                }
                catch (Exception exception) {
                    NetworkModel.this.log("Local", "Local", "Failed to Shutdown Server.");
                }
                try {
                    NetworkModel.this.displayClientToolbar();
                }
                catch (Exception exception) {
                    NetworkModel.this.log("Local", "Local", "Failed to Display the client tool bar.");
                }
            }
        }
    }

    private class NetworkLogReciever
    implements LogReceiver {
        public void logMessage(String string, String string2) {
            NetworkModel.this.log("Local", string, string2);
            if (NetworkModel.this.client != null) {
                NetworkModel.this.client.sendLogMessage(string, string2);
            }
        }

        public void logMessage(String string) {
            this.logMessage("Misc", string);
        }
    }
}

