/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import plugin.dicebag.gui.DiceBagGridLayout;
import plugin.dicebag.gui.DiceBagModel;

public class DiceBagView
extends JInternalFrame
implements Observer {
    DiceBagModel m_bag = null;
    private BagListener m_bagListener = new BagListener();
    private BagTableModel m_tableModel = new BagTableModel();
    private JButton m_deleteSelected;
    private JButton m_editButton;
    private JButton m_moveDown;
    private JButton m_moveUp;
    private JButton m_rollButton;
    private JButton m_stopEditing;
    private JLabel m_exprFieldLabel;
    private JLabel m_exprResult;
    private JLabel m_nameFieldLabel;
    private JPanel m_center;
    private JPanel m_top;
    private JPanel m_topBottom;
    private JPanel m_topTop;
    private JScrollPane m_scrollPane;
    private JTable m_table;
    private JTextField m_exprField;
    private JTextField m_nameField;
    private List<JButton> m_diceButtons;

    public DiceBagView(DiceBagModel diceBagModel) {
        this.m_bag = diceBagModel;
        this.initComponents();
    }

    public DiceBagModel getBag() {
        return this.m_bag;
    }

    public void handleEdit(ActionEvent actionEvent) {
        this.setupEditMode();
    }

    public void update(Observable observable, Object object) {
    }

    private void setRollResult(String string, double d) {
        String string2 = null;
        string2 = d % 1.0 == 0.0 ? Integer.toString((int)Math.round(d)) : Double.toString(d);
        this.m_exprResult.setText("<html><b>" + string + ": " + string2 + "</b></html>");
    }

    private void cleanup() {
        this.m_top.removeAll();
        this.m_topTop.removeAll();
        this.m_topBottom.removeAll();
        this.m_center.removeAll();
        this.getContentPane().removeAll();
    }

    private void deleteRecords(ActionEvent actionEvent) {
        while (this.m_table.getSelectedRow() >= 0 && this.m_table.getSelectedRow() < this.m_bag.diceCount()) {
            this.m_bag.removeDie(this.m_table.getSelectedRow());
            this.m_tableModel.fireTableRowsDeleted(this.m_table.getSelectedRow(), this.m_table.getSelectedRow());
        }
    }

    private void initComponents() {
        this.setTitle(this.m_bag.getName());
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_top = new JPanel();
        this.m_topTop = new JPanel();
        this.m_topBottom = new JPanel();
        this.m_center = new JPanel();
        this.m_top.setLayout(new GridLayout(2, 1));
        this.m_topTop.setLayout(new BoxLayout(this.m_topTop, 0));
        this.m_topBottom.setLayout(new BoxLayout(this.m_topBottom, 0));
        this.m_center.setLayout(new DiceBagGridLayout(0, 3, 1, 75, 100));
        this.m_center.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_rollButton = new JButton("Roll");
        this.m_rollButton.setActionCommand("ROLL");
        this.m_rollButton.addActionListener(this.m_bagListener);
        this.m_exprResult = new JLabel(" ");
        this.m_exprResult.setMinimumSize(new Dimension(50, this.m_exprResult.getMinimumSize().height));
        this.m_exprResult.setPreferredSize(new Dimension(50, this.m_exprResult.getPreferredSize().height));
        this.m_exprResult.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.m_exprResult.getMaximumSize().height));
        this.m_editButton = new JButton("Edit");
        this.m_editButton.setActionCommand("EDIT");
        this.m_editButton.addActionListener(this.m_bagListener);
        this.m_diceButtons = new ArrayList<JButton>();
        this.m_exprField = new JTextField();
        this.m_exprFieldLabel = new JLabel("Roll Expr: ");
        this.m_table = new JTable(this.m_tableModel);
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_stopEditing = new JButton("Stop Editing");
        this.m_stopEditing.setActionCommand("STOP_EDITING");
        this.m_stopEditing.addActionListener(this.m_bagListener);
        this.m_deleteSelected = new JButton("Delete");
        this.m_deleteSelected.setActionCommand("DELETE");
        this.m_deleteSelected.addActionListener(this.m_bagListener);
        this.m_moveUp = new JButton("Move up");
        this.m_moveUp.setActionCommand("MOVE_UP");
        this.m_moveUp.addActionListener(this.m_bagListener);
        this.m_moveDown = new JButton("Move down");
        this.m_moveDown.setActionCommand("MOVE_DOWN");
        this.m_moveDown.addActionListener(this.m_bagListener);
        this.m_nameField = new JTextField();
        this.m_nameFieldLabel = new JLabel("Name: ");
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                DiceBagView.this.m_bag.setName(DiceBagView.this.m_nameField.getText());
                DiceBagView.this.setTitle(DiceBagView.this.m_nameField.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DiceBagView.this.m_bag.setName(DiceBagView.this.m_nameField.getText());
                DiceBagView.this.setTitle(DiceBagView.this.m_nameField.getText());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(this.getClass().getResource("/pcgen/gui/resource/gmgen_icon.png"));
        this.setFrameIcon(new ImageIcon(image));
        this.setupRollingMode();
        this.pack();
    }

    private void moveRecordsDown(ActionEvent actionEvent) {
        for (int i = this.m_table.getRowCount() - 2; i >= 0; --i) {
            if (i >= this.m_table.getRowCount() - 2 || !this.m_table.isRowSelected(i) || this.m_table.isRowSelected(i + 1)) continue;
            String string = this.m_bag.getDie(i);
            String string2 = this.m_bag.getDie(i + 1);
            this.m_bag.setDie(i + 1, string);
            this.m_bag.setDie(i, string2);
            this.m_tableModel.fireTableRowsUpdated(i, i + 1);
            this.m_table.getSelectionModel().addSelectionInterval(i + 1, i + 1);
            this.m_table.getSelectionModel().removeSelectionInterval(i, i);
        }
    }

    private void moveRecordsUp(ActionEvent actionEvent) {
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            if (i <= 0 || !this.m_table.isRowSelected(i) || this.m_table.isRowSelected(i - 1)) continue;
            String string = this.m_bag.getDie(i);
            String string2 = this.m_bag.getDie(i - 1);
            this.m_bag.setDie(i - 1, string);
            this.m_bag.setDie(i, string2);
            this.m_tableModel.fireTableRowsUpdated(i - 1, i);
            this.m_table.getSelectionModel().addSelectionInterval(i - 1, i - 1);
            this.m_table.getSelectionModel().removeSelectionInterval(i, i);
        }
    }

    private void setupEditMode() {
        this.cleanup();
        this.getContentPane().add((Component)this.m_center, "Center");
        this.getContentPane().add((Component)this.m_top, "North");
        this.m_top.add(this.m_topTop);
        this.m_top.add(this.m_topBottom);
        this.m_nameField.setPreferredSize(new Dimension(100, this.m_nameField.getPreferredSize().height));
        this.m_topBottom.add(this.m_nameFieldLabel);
        this.m_topBottom.add(this.m_nameField);
        this.m_nameField.setText(this.m_bag.getName());
        if (this.m_center.getLayout() instanceof DiceBagGridLayout) {
            ((DiceBagGridLayout)this.m_center.getLayout()).setRows(1);
            ((DiceBagGridLayout)this.m_center.getLayout()).setColumns(1);
        }
        this.m_center.add(this.m_scrollPane);
        this.m_topTop.add(this.m_stopEditing);
        this.m_topTop.add(Box.createHorizontalStrut(5));
        this.m_topTop.add(this.m_deleteSelected);
        this.m_topTop.add(Box.createHorizontalStrut(5));
        this.m_topTop.add(this.m_moveUp);
        this.m_topTop.add(Box.createHorizontalStrut(5));
        this.m_topTop.add(this.m_moveDown);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(this.m_table.getPreferredScrollableViewportSize().width, 200));
        this.getContentPane().validate();
        this.pack();
    }

    private void setupRollingMode() {
        this.cleanup();
        if (this.m_center.getLayout() instanceof DiceBagGridLayout) {
            ((DiceBagGridLayout)this.m_center.getLayout()).setRows(0);
            ((DiceBagGridLayout)this.m_center.getLayout()).setColumns(3);
        }
        this.getContentPane().add((Component)this.m_top, "North");
        this.getContentPane().add((Component)this.m_center, "Center");
        this.m_top.add(this.m_topTop);
        this.m_top.add(this.m_topBottom);
        this.m_topTop.add(this.m_exprFieldLabel);
        this.m_exprField.setPreferredSize(new Dimension(50, this.m_exprField.getPreferredSize().height));
        this.m_topTop.add(this.m_exprField);
        this.m_topTop.add(Box.createHorizontalStrut(10));
        this.m_topTop.add(this.m_rollButton);
        this.m_topBottom.add(this.m_exprResult);
        this.m_topBottom.add(Box.createHorizontalStrut(10));
        this.m_topBottom.add(this.m_editButton);
        for (int i = 0; i < this.m_bag.diceCount(); ++i) {
            JButton jButton = null;
            if (this.m_diceButtons.size() > i) {
                jButton = this.m_diceButtons.get(i);
            } else {
                jButton = new JButton(" ");
                jButton.setPreferredSize(new Dimension(100, jButton.getPreferredSize().height));
                jButton.addActionListener(this.m_bagListener);
                jButton.setActionCommand(Integer.toString(i));
                this.m_diceButtons.add(jButton);
            }
            jButton.setText(this.m_bag.getDie(i));
            this.m_center.add(jButton);
        }
        this.getContentPane().validate();
        this.pack();
    }

    private void stopEditing(ActionEvent actionEvent) {
        this.setupRollingMode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BagTableModel
    extends AbstractTableModel {
        private BagTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return "Dice Expression";
        }

        @Override
        public int getRowCount() {
            return DiceBagView.this.m_bag.diceCount() + 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n >= 0 && n < this.getRowCount() - 1) {
                if (object == null || object.toString().length() == 0) {
                    DiceBagView.this.m_bag.removeDie(n);
                    this.fireTableRowsDeleted(n, n);
                } else {
                    DiceBagView.this.m_bag.setDie(n, object.toString());
                }
            } else if (n == this.getRowCount() - 1) {
                DiceBagView.this.m_bag.addDie(object.toString());
                this.fireTableRowsInserted(n, n);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n >= 0 && n < this.getRowCount() - 1) {
                string = DiceBagView.this.m_bag.getDie(n);
            }
            return string;
        }
    }

    private class BagListener
    implements ActionListener {
        private BagListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("ROLL".equals(string)) {
                DiceBagView.this.setRollResult(DiceBagView.this.m_exprField.getText(), DiceBagView.this.m_bag.rollDie(DiceBagView.this.m_exprField.getText()));
            } else if ("EDIT".equals(string)) {
                DiceBagView.this.handleEdit(actionEvent);
            } else if ("STOP_EDITING".equals(string)) {
                DiceBagView.this.stopEditing(actionEvent);
            } else if ("DELETE".equals(string)) {
                DiceBagView.this.deleteRecords(actionEvent);
            } else if ("MOVE_UP".equals(string)) {
                DiceBagView.this.moveRecordsUp(actionEvent);
            } else if ("MOVE_DOWN".equals(string)) {
                DiceBagView.this.moveRecordsDown(actionEvent);
            } else {
                try {
                    int n = Integer.parseInt(string);
                    DiceBagView.this.setRollResult(DiceBagView.this.m_bag.getDie(n), DiceBagView.this.m_bag.rollDie(n));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Invalid command passed to BagListener.");
                    numberFormatException.printStackTrace();
                }
            }
        }
    }
}

