/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.WeaponToken;
import plugin.charactersheet.gui.CharacterPanel;

public class WeaponSpecialPane
extends JPanel {
    private PlayerCharacter pc;
    private Equipment eq;
    private JPanel labelPanel;
    private JPanel propPanel;
    private JTextArea specialProperties;
    private static final String SPROPS = "Special Properties";
    private static final String BLANK = "";
    private static final Font FONT_TEN = new Font("Dialog", 0, 10);

    public WeaponSpecialPane() {
        this.initComponents();
        this.setColor();
    }

    private void initComponents() {
        this.labelPanel = new JPanel();
        this.propPanel = new JPanel();
        this.specialProperties = new JTextArea();
        this.setLayout(new BoxLayout(this, 0));
        JLabel jLabel = new JLabel();
        jLabel.setFont(FONT_TEN);
        jLabel.setText(SPROPS);
        this.labelPanel.add(jLabel);
        this.add(this.labelPanel);
        this.propPanel.setLayout(new BoxLayout(this.propPanel, 0));
        this.specialProperties.setFont(FONT_TEN);
        this.specialProperties.setLineWrap(true);
        this.specialProperties.setWrapStyleWord(true);
        this.propPanel.add(this.specialProperties);
        this.add(this.propPanel);
    }

    public void setColor() {
        this.setBackground(CharacterPanel.border);
        this.setBorder(new LineBorder(CharacterPanel.border));
        this.labelPanel.setBackground(CharacterPanel.header);
        this.labelPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.propPanel.setBackground(CharacterPanel.border);
        this.specialProperties.setBackground(CharacterPanel.bodyLight);
        this.specialProperties.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setWeapon(PlayerCharacter playerCharacter, Equipment equipment) {
        this.pc = playerCharacter;
        this.eq = equipment;
        this.refresh();
    }

    public void refresh() {
        String string = WeaponToken.getSpropToken((PlayerCharacter)this.pc, (Equipment)this.eq).trim();
        if (!string.equals(BLANK)) {
            this.setVisible(true);
            this.specialProperties.setText(string);
        } else {
            this.setVisible(false);
        }
    }
}

